/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.JenaProcessProfile;
import com.hp.hpl.deli.Workspace;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFException;
import java.io.InputStream;

public class UAProfValidator
implements RDFErrorHandler {
    private JenaReader myARPReader = new JenaReader();
    boolean profileValidFlag = false;

    public static void main(String[] args) {
        try {
            Workspace.getInstance().configure(null, "config/deliValidatorConfig.xml");
            UAProfValidator validator = new UAProfValidator();
            if (args.length < 1) {
                System.out.println("No profile specified");
                System.exit(1);
            }
            int validProfiles = 0;
            int invalidProfiles = 0;
            int i = 0;
            while (i < args.length) {
                System.out.println("Validating:" + args[i]);
                if (validator.validate(args[i])) {
                    System.out.println("Profile is valid");
                    ++validProfiles;
                } else {
                    System.out.println("Profile is not valid");
                    ++invalidProfiles;
                }
                System.out.println();
                ++i;
            }
            System.out.println("Scanned " + validProfiles + " valid profiles and " + invalidProfiles + " invalid profiles");
        }
        catch (Exception f) {
            System.out.println("DELI error:" + f.toString());
        }
    }

    public UAProfValidator() {
        this.myARPReader.setErrorHandler((RDFErrorHandler)this);
    }

    public void warning(Exception e) {
        this.error(e);
    }

    public void error(Exception e) {
        System.out.println("RDF parser error:" + e.getMessage());
        this.profileValidFlag = false;
    }

    public void fatalError(Exception e) {
        this.error(e);
    }

    public boolean validate(String resource) {
        this.profileValidFlag = true;
        JenaProcessProfile profile = new JenaProcessProfile();
        profile.jenaProfile = ModelFactory.createDefaultModel();
        try {
            InputStream in = Workspace.getInstance().getResource(resource);
            this.myARPReader.read(profile.jenaProfile, in, "");
        }
        catch (RDFException e) {
            System.out.println("Could not parse profile " + resource);
            this.profileValidFlag = false;
        }
        catch (Exception e) {
            System.out.println("Could not load profile " + resource);
            this.profileValidFlag = false;
        }
        try {
            profile.processModel(true);
            this.profileValidFlag = profile.validFlag;
        }
        catch (RDFException e) {
            System.out.println(e.toString());
            this.profileValidFlag = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            this.profileValidFlag = false;
            e.printStackTrace();
        }
        return this.profileValidFlag;
    }
}

