/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.URI;
import com.hp.hpl.deli.VectorUnique;
import com.hp.hpl.deli.Workspace;
import java.io.Serializable;
import java.util.Vector;

public abstract class ProfileAttribute
implements Serializable {
    protected URI qName;
    protected URI componentQName;
    protected VectorUnique attributeValue = new VectorUnique();
    protected VectorUnique defaultAttributeValue = new VectorUnique();

    protected URI getQName() {
        return this.qName;
    }

    public Vector getValue() {
        return this.attributeValue.size() == 0 ? null : this.attributeValue;
    }

    public Vector getDefaultValue() {
        return this.defaultAttributeValue.size() == 0 ? null : this.defaultAttributeValue;
    }

    public boolean contains(String value) {
        if (!this.attributeValue.isEmpty()) {
            return this.attributeValue.contains(value);
        }
        return this.defaultAttributeValue.contains(value);
    }

    public URI getProperty(String propName) {
        return Workspace.getInstance().vocabulary.getAttributeProperty(this.qName, propName);
    }

    public String getComponent() {
        if (this.componentQName == null) {
            Workspace.printDebug("Attribute doesnt belong to a component." + this.qName.toString());
            return null;
        }
        return this.componentQName.getFragment();
    }

    public String getAttribute() {
        return this.qName.getFragment();
    }

    public String getResolution() {
        URI theProperty = this.getProperty("ccppResolution");
        return theProperty != null ? theProperty.getFragment() : null;
    }

    public String getCollectionType() {
        URI theProperty = this.getProperty("ccppCollectionType");
        return theProperty != null ? theProperty.getFragment() : null;
    }

    public String getType() {
        URI theProperty = this.getProperty("ccppType");
        return theProperty != null ? theProperty.getFragment() : null;
    }

    public String getUri() {
        return this.qName.getNamespace();
    }

    protected void set(URI qn, URI cqn, VectorUnique b, boolean isDefault) {
        this.qName = qn;
        this.componentQName = cqn;
        if (isDefault) {
            this.defaultAttributeValue = b;
        } else {
            this.attributeValue = b;
        }
    }

    protected abstract void set(ProfileAttribute var1);

    public Vector get() {
        return this.getValue() == null ? this.getDefaultValue() : this.getValue();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("\nAttribute:  " + this.getAttribute());
        result.append("\nComponent:  " + this.getComponent());
        result.append("\nResolution: " + this.getResolution());
        result.append("\ncollectionType:" + this.getCollectionType());
        result.append("\nType:       " + this.getType());
        result.append("\nUri:    " + this.getUri());
        if (Workspace.getInstance().printDefaults) {
            result.append("\nValue:      " + this.getValue());
            result.append("\nDefaultVal: " + this.getDefaultValue() + "\n");
        } else {
            result.append("\nResolvedVal:" + this.get() + "\n");
        }
        return result.toString();
    }
}

