/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.Workspace;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class LocalProfiles {
    private Vector useragents = new Vector();
    private Vector profileRefs = new Vector();

    protected LocalProfiles(String localProfile) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = dbf.newDocumentBuilder();
        try {
            InputSource inputSource = Workspace.getInstance().getInputSource(localProfile);
            this.traverse(parser.parse(inputSource));
        }
        catch (Exception e) {
            Workspace.printDebug("LocalProfiles: Cannot load local profiles configuration file from " + localProfile);
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    protected String getReference(String s) {
        int i = 0;
        while (i < this.useragents.size()) {
            if (s.lastIndexOf((String)this.useragents.get(i)) != -1) {
                String localProfile = Workspace.getInstance().localProfilesPath + "/" + (String)this.profileRefs.get(i);
                Workspace.printDebug("LocalProfiles: Useragent string " + s);
                Workspace.printDebug(" maps on to " + localProfile);
                return localProfile;
            }
            ++i;
        }
        return null;
    }

    private void traverse(Node n) {
        if (n.getNodeName().equals("device") && n.hasChildNodes()) {
            NodeList list = n.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node a = list.item(i);
                if (a.getNodeName().equals("ua")) {
                    String useragentString = null;
                    String profileReference = null;
                    NamedNodeMap nodeMap = a.getAttributes();
                    if (nodeMap.getNamedItem("value") != null) {
                        useragentString = nodeMap.getNamedItem("value").getNodeValue();
                    }
                    if (nodeMap.getNamedItem("profile") != null) {
                        profileReference = nodeMap.getNamedItem("profile").getNodeValue();
                    }
                    if (useragentString != null && profileReference != null && !useragentString.equals("") && !profileReference.equals("")) {
                        this.useragents.add(useragentString);
                        this.profileRefs.add(profileReference);
                    }
                }
                ++i;
            }
        } else if (n.hasChildNodes()) {
            this.traverse(n.getFirstChild());
        }
        Node next = n.getNextSibling();
        if (next != null) {
            this.traverse(next);
        }
    }
}

