/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.DeliUtil;
import com.hp.hpl.deli.ExtendedStatement;
import com.hp.hpl.deli.UAProfProfileAttribute;
import com.hp.hpl.deli.UAProfValidator;
import com.hp.hpl.deli.URI;
import com.hp.hpl.deli.VectorUnique;
import com.hp.hpl.deli.Vocabulary;
import com.hp.hpl.deli.Workspace;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.SelectorImpl;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Vector;

class JenaProcessProfile
implements RDFErrorHandler {
    protected Model jenaProfile;
    private Property componentProperty;
    private Property typeProperty;
    private boolean validationOn = true;
    protected boolean validFlag = true;
    private boolean defaultFlag = false;
    private Vector profileAttributes = new Vector();
    Vocabulary vocabulary = null;
    Workspace workspace = Workspace.getInstance();
    private JenaReader arpReader;

    protected JenaProcessProfile() {
        this.vocabulary = this.workspace.vocabulary;
        this.arpReader = new JenaReader();
        this.arpReader.setErrorHandler((RDFErrorHandler)this);
    }

    public void warning(Exception e) {
    }

    public void error(Exception e) {
    }

    public void fatalError(Exception e) {
    }

    protected Vector process(String resource) throws Exception {
        this.jenaProfile = ModelFactory.createDefaultModel();
        try {
            InputStream in = this.workspace.getResource(resource);
            this.arpReader.read(this.jenaProfile, in, "");
        }
        catch (RDFException e) {
            Workspace.printDebug("JenaProcessProfile: Could not load profile " + resource);
            Workspace.printDebug(e.toString());
            e.printStackTrace();
        }
        return this.processModel(false);
    }

    protected Vector process(Vector profileVector) throws Exception {
        int i = 0;
        while (i < profileVector.size()) {
            StringReader reader = new StringReader((String)profileVector.get(i));
            this.jenaProfile = ModelFactory.createDefaultModel();
            try {
                this.arpReader.read(this.jenaProfile, (Reader)reader, "");
            }
            catch (Exception e) {
                Workspace.printDebug("JenaProcessProfile: Could not process profile-diff");
                Workspace.printDebug(e.toString());
                e.printStackTrace();
            }
            this.processModel(false);
            ++i;
        }
        return this.profileAttributes;
    }

    protected void println(String message) {
        if (this.validationOn) {
            System.out.println(message);
        } else {
            Workspace.printDebug(message);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Vector processModel(boolean validationMode) throws RDFException, Exception {
        this.validationOn = validationMode;
        namespaces = this.jenaProfile.listNameSpaces();
        if (!namespaces.hasNext()) {
            this.println("The profile does not contain any RDF information - use W3C RDF Validator");
            this.validFlag = false;
        }
        this.typeProperty = this.jenaProfile.createProperty(this.workspace.rdfUri + "type");
        while (namespaces.hasNext()) {
            theNamespace = namespaces.nextNs();
            this.println(theNamespace);
            if (theNamespace.equals(this.workspace.rdfUri)) continue;
            this.componentProperty = this.jenaProfile.createProperty(theNamespace + this.workspace.componentProperty);
            this.println("Model uses " + theNamespace);
            if (!this.vocabulary.getRealNamespace(theNamespace).equals(theNamespace)) {
                this.println("The profile uses namespace aliasing");
                this.println("Real namespace is:    " + theNamespace);
                this.println("Aliased namespace is: " + this.vocabulary.getRealNamespace(theNamespace));
            }
            currentComponent = null;
            component = null;
            componentList = this.jenaProfile.listObjectsOfProperty(this.componentProperty);
            if (componentList.hasNext() || this.validationOn) ** GOTO lbl29
            p = new ProcessAttributeList(this.findRoot(), null);
            continue;
lbl-1000:
            // 1 sources

            {
                component = (Resource)componentList.next();
                if (component.hasProperty(this.typeProperty)) {
                    currentComponent = component.getProperty(this.typeProperty).getObject().toString();
                } else {
                    this.println("Warning: Profile omits type information");
                }
                p = new ProcessAttributeList(component, currentComponent);
lbl29:
                // 2 sources

                ** while (componentList.hasNext())
            }
lbl30:
            // 1 sources

        }
        return this.profileAttributes;
    }

    private Resource findRoot() throws Exception {
        Resource root = null;
        RDFNode currentNode = this.jenaProfile.listStatements().nextStatement().getObject();
        while (root == null) {
            StmtIterator iter = this.jenaProfile.listStatements((Selector)new SelectorImpl((Resource)null, (Property)null, currentNode));
            if (iter.hasNext()) {
                currentNode = iter.nextStatement().getSubject();
                continue;
            }
            root = (Resource)currentNode;
        }
        return root;
    }

    private void validatorError(String component, String attribute, String message) {
        this.println("[C: " + component + ", A: " + attribute + "] " + message);
        this.validFlag = false;
    }

    private class ProcessAttributeList {
        String currentComponent;

        ProcessAttributeList(Resource theResource, String _currentComponent) throws Exception {
            this.currentComponent = _currentComponent;
            NsIterator namespaces = JenaProcessProfile.this.jenaProfile.listNameSpaces();
            while (namespaces.hasNext()) {
                String vocabularyURI = namespaces.nextNs();
                if (vocabularyURI.equals(JenaProcessProfile.this.workspace.rdfUri)) continue;
                Property defaultProperty = JenaProcessProfile.this.jenaProfile.createProperty(vocabularyURI + "defaults");
                Property capsDefaultProperty = JenaProcessProfile.this.jenaProfile.createProperty(vocabularyURI + "Defaults");
                StmtIterator theProperties = theResource.listProperties();
                while (theProperties.hasNext()) {
                    Statement statement = theProperties.nextStatement();
                    String subject = theResource.toString();
                    String property = statement.getPredicate().toString();
                    String propertyNamespace = property.substring(0, property.lastIndexOf(35) + 1);
                    if (statement.getPredicate().equals((Object)JenaProcessProfile.this.typeProperty)) continue;
                    if (statement.getPredicate().equals((Object)defaultProperty) || statement.getPredicate().equals((Object)capsDefaultProperty)) {
                        this.processDefaultBlock(statement);
                        continue;
                    }
                    if (JenaProcessProfile.this.validationOn || DeliUtil.getID(property).equals(JenaProcessProfile.this.workspace.componentProperty) || JenaProcessProfile.this.vocabulary.namespaceLookup.get(vocabularyURI) == null && !JenaProcessProfile.this.workspace.processUnconfiguredNamespaces || !vocabularyURI.equals(propertyNamespace) || this.currentComponent != null) continue;
                    JenaProcessProfile.this.println("Component is null for: " + property);
                    Vector props = JenaProcessProfile.this.vocabulary.getAttPropertiesWithAttName(property);
                    if (props != null) {
                        JenaProcessProfile.this.println("Determining component from vocabulary");
                        this.currentComponent = ((URI)((HashMap)props.firstElement()).get("ccppComponent")).toString();
                        continue;
                    }
                    JenaProcessProfile.this.println("Determining component from local ID");
                    this.currentComponent = vocabularyURI + subject.substring(subject.lastIndexOf(35) + 1, subject.length());
                }
            }
            StmtIterator theProperties = theResource.listProperties();
            while (theProperties.hasNext()) {
                Statement statement = theProperties.nextStatement();
                if (statement.getPredicate().equals((Object)JenaProcessProfile.this.typeProperty)) continue;
                ProcessAttribute p = new ProcessAttribute(statement, this.currentComponent);
            }
        }

        private void processDefaultBlock(Statement statement) throws Exception {
            StmtIterator iter = ((Resource)statement.getObject()).listProperties();
            if (!iter.hasNext()) {
                String url = statement.getObject().toString();
                JenaProcessProfile.this.println("Retrieving profile " + url);
                if (JenaProcessProfile.this.validationOn) {
                    UAProfValidator tempValidator = new UAProfValidator();
                    if (!tempValidator.validate(url)) {
                        JenaProcessProfile.this.println("Referenced profile " + url + " is invalid");
                        JenaProcessProfile.this.validFlag = false;
                    }
                } else {
                    JenaProcessProfile tempProfile = new JenaProcessProfile();
                    tempProfile.defaultFlag = true;
                    JenaProcessProfile.this.profileAttributes.addAll(tempProfile.process(url));
                }
            } else {
                JenaProcessProfile.this.defaultFlag = true;
                ProcessAttributeList p = new ProcessAttributeList((Resource)statement.getObject(), this.currentComponent);
                JenaProcessProfile.this.defaultFlag = false;
            }
        }
    }

    private class ProcessAttribute {
        String currentComponent;
        String attributeName;
        ExtendedStatement attributeStatement;
        URI ccppType;
        URI ccppCollectionType;

        ProcessAttribute(Statement _attributeStatement, String _currentComponent) throws RDFException, Exception {
            this.attributeStatement = new ExtendedStatement(_attributeStatement, JenaProcessProfile.this.jenaProfile);
            this.currentComponent = JenaProcessProfile.this.vocabulary.getRealNamespace(_currentComponent);
            String qualifiedAttribute = this.attributeStatement.getPredicate().toString();
            this.attributeName = DeliUtil.getID(qualifiedAttribute);
            URI qn = new URI(JenaProcessProfile.this.vocabulary.getRealNamespace(qualifiedAttribute));
            URI currentComponentUri = null;
            if (this.currentComponent != null) {
                currentComponentUri = new URI(JenaProcessProfile.this.vocabulary.getRealNamespace(this.currentComponent));
            }
            URI ccppComponent = JenaProcessProfile.this.vocabulary.getAttributeProperty(qn, "ccppComponent");
            this.ccppCollectionType = JenaProcessProfile.this.vocabulary.getAttributeProperty(qn, "ccppCollectionType");
            this.ccppType = JenaProcessProfile.this.vocabulary.getAttributeProperty(qn, "ccppType");
            HashMap attribute = JenaProcessProfile.this.vocabulary.getAttribute(qn);
            if (attribute == null) {
                JenaProcessProfile.this.validatorError(this.currentComponent, qualifiedAttribute, "Attribute not defined in vocabulary");
                if (!JenaProcessProfile.this.validationOn && JenaProcessProfile.this.workspace.processUndefinedAttributes) {
                    String collectionType = this.attributeStatement.determineCollectionType();
                    JenaProcessProfile.this.vocabulary.addAttributeToVocabulary(qualifiedAttribute, this.currentComponent, collectionType);
                }
            } else if (JenaProcessProfile.this.validationOn) {
                this.processValues();
                if (!(ccppComponent == null || this.currentComponent == null || ccppComponent.equals(this.currentComponent) || this.currentComponent == null || this.attributeName.equals("CcppAccept") || this.attributeName.equals("CcppAccept-Language") || this.attributeName.equals("CcppAccept-Charset"))) {
                    JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "Attribute is in wrong component should be " + ccppComponent.toString());
                }
            }
            if (!JenaProcessProfile.this.validationOn && (attribute == null && JenaProcessProfile.this.workspace.processUndefinedAttributes || attribute != null)) {
                VectorUnique attributeValue = this.getValues();
                if (JenaProcessProfile.this.vocabulary.getAttributeProperty(qn, "ccppComponent") == null) {
                    JenaProcessProfile.this.println("Could not retrieve " + this.attributeName);
                    JenaProcessProfile.this.println(qn.toString());
                    if (currentComponentUri != null) {
                        Workspace.printDebug(currentComponentUri.toString());
                    }
                }
                UAProfProfileAttribute newAttribute = new UAProfProfileAttribute();
                newAttribute.set(qn, currentComponentUri, attributeValue, JenaProcessProfile.this.defaultFlag);
                JenaProcessProfile.this.profileAttributes.add(newAttribute);
            }
        }

        private void processValues() throws Exception {
            if (this.ccppCollectionType.getFragment().equals("Simple")) {
                this.checkDatatype(this.attributeStatement.getObject());
            } else {
                this.validateContainer("Bag");
                this.validateContainer("Seq");
            }
        }

        private void validateContainer(String container) throws Exception {
            if (this.ccppCollectionType.getFragment().equals(container)) {
                if (!(this.attributeStatement.getObject() instanceof Resource)) {
                    JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "does not match collection type " + container);
                } else if (!this.attributeStatement.getContainer(container).hasNext()) {
                    JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "does not match collection type " + container);
                } else {
                    NodeIterator i = this.attributeStatement.getContainerIterator();
                    if (i != null) {
                        while (i.hasNext()) {
                            this.checkDatatype(i.nextNode());
                        }
                    }
                }
            }
        }

        private void checkDatatype(RDFNode value) throws Exception {
            if (!(value instanceof Literal)) {
                JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "Expected literal found resource");
            }
            String valueString = value.toString();
            String type = this.ccppType.getFragment();
            String regExpression = (String)JenaProcessProfile.this.workspace.datatypeExpressions.get(type);
            if (regExpression == null) {
                JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "Datatype error: " + type + " is not defined");
            } else if (!valueString.matches(regExpression)) {
                JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "Datatype error:" + valueString + " does not match datatype " + type);
            }
        }

        private VectorUnique getValues() throws Exception {
            VectorUnique attributeValue = new VectorUnique();
            if (this.attributeStatement.getObject() instanceof Literal) {
                attributeValue.add(new String(this.attributeStatement.getObject().toString().trim()));
            } else {
                NodeIterator i = this.attributeStatement.getContainerIterator();
                if (i != null) {
                    while (i.hasNext()) {
                        attributeValue.add(new String(i.next().toString().trim()));
                    }
                }
            }
            return attributeValue;
        }
    }
}

