/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.Workspace;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DatatypeExpression {
    public DatatypeExpression(String configFile) throws Exception {
        Node currentChild;
        Document document;
        Workspace.getInstance().datatypeExpressions = new HashMap();
        HashMap datatype = Workspace.getInstance().datatypeExpressions;
        datatype.clear();
        datatype.put("Literal", "[A-Za-z0-9/.\\-;:_ ()=*+]+");
        datatype.put("Number", "[0-9]+");
        datatype.put("Boolean", "(Yes)|(No)");
        datatype.put("Dimension", "[0-9,.]+x[0-9,.]+");
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            InputSource inputSource = Workspace.getInstance().getInputSource(configFile);
            document = parser.parse(inputSource);
        }
        catch (Exception e) {
            throw new Exception("Could not parse config file");
        }
        NodeList children = document.getChildNodes();
        Node config = document;
        int i = 0;
        while (i < children.getLength()) {
            currentChild = children.item(i);
            if (currentChild.getNodeName().equals("validator")) {
                config = currentChild;
                break;
            }
            ++i;
        }
        if (config == null) {
            throw new Exception("Config file is invalid");
        }
        children = config.getChildNodes();
        Workspace.getInstance().datatypeExpressions.clear();
        int i2 = 0;
        while (i2 < children.getLength()) {
            currentChild = children.item(i2);
            if (currentChild.getNodeName().equals("datatype")) {
                this.setDatatypeFromConfig(currentChild);
            }
            ++i2;
        }
    }

    protected void setDatatypeFromConfig(Node datatype) throws Exception {
        NodeList children = datatype.getChildNodes();
        Node name = null;
        Node expression = null;
        int i = 0;
        while (i < children.getLength()) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeName().equals("name")) {
                name = currentChild;
            } else if (currentChild.getNodeName().equals("expression")) {
                expression = currentChild;
            }
            ++i;
        }
        if (name == null || expression == null) {
            throw new Exception("Config file is invalid");
        }
        String nameString = name.getFirstChild().getNodeValue();
        String expressionString = expression.getFirstChild().getNodeValue();
        Workspace.getInstance().datatypeExpressions.put(nameString, expressionString);
    }
}

