/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.CapClass;
import com.hp.hpl.deli.Operand;
import com.hp.hpl.deli.Operator;
import com.hp.hpl.deli.Workspace;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class CapabilityDefinition
implements Serializable {
    protected Vector classes = new Vector();
    private HashMap equivalentVocabGroups;

    public CapabilityDefinition(InputStream in) throws ParserConfigurationException {
        Workspace.printDebug("CapabilityDefinition: Processing from InputStream");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = dbf.newDocumentBuilder();
        try {
            if (in == null || in.available() <= 0) {
                throw new IOException("InputStream for capability class null or has no content");
            }
            this.traverse(parser.parse(in));
        }
        catch (Exception e) {
            Workspace.printDebug("Capability class: Cannot load from InputStream");
        }
    }

    public CapabilityDefinition(String filename) throws ParserConfigurationException {
        Workspace.printDebug("CapabilityDefinition: Processing " + filename);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = dbf.newDocumentBuilder();
        try {
            InputSource inputSource = Workspace.getInstance().getInputSource(filename);
            this.traverse(parser.parse(inputSource));
        }
        catch (Exception e) {
            Workspace.printDebug("Capability class: Cannot load " + filename);
        }
    }

    private void traverse(Node n) {
        String nodename = n.getNodeName();
        if (nodename.equals("class")) {
            CapClass capClass = new CapClass();
            capClass.name = CapabilityDefinition.getAttribute(n, "name");
            NamedNodeMap nodeMap = n.getAttributes();
            capClass.constraints = new TraverseCapabilityClass(n);
            this.classes.add(capClass);
        } else if (nodename.equals("vocabularyAlias")) {
            Vector<String> uriList = new Vector<String>();
            String aliasName = null;
            NodeList nl = n.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node li = nl.item(i);
                String liName = li.getNodeName();
                if (liName.equals("aliasName")) {
                    aliasName = li.getFirstChild().getNodeValue();
                } else if (liName.equals("aliasList")) {
                    NodeList uriNl = li.getChildNodes();
                    int j = 0;
                    while (j < uriNl.getLength()) {
                        if (uriNl.item(j).getNodeName().equals("li")) {
                            uriList.add(uriNl.item(j).getFirstChild().getNodeValue());
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (this.equivalentVocabGroups == null) {
                this.equivalentVocabGroups = new HashMap();
            }
            this.equivalentVocabGroups.put(aliasName, uriList);
        } else if (n.hasChildNodes()) {
            this.traverse(n.getFirstChild());
        }
        Node next = n.getNextSibling();
        if (next != null) {
            this.traverse(next);
        }
    }

    protected boolean memberOfAliasGroup(String group, String URI2) {
        String resolvedUri = Workspace.getInstance().vocabulary.getRealNamespace(URI2);
        if (this.equivalentVocabGroups.containsKey(group)) {
            Vector uriList = (Vector)this.equivalentVocabGroups.get(group);
            Iterator iterator = uriList.iterator();
            while (iterator.hasNext()) {
                if (!((String)iterator.next()).equals(resolvedUri)) continue;
                return true;
            }
        }
        return false;
    }

    protected Vector getGroupURIs(String theGroup) {
        Vector uriList = new Vector();
        Vector v = (Vector)this.equivalentVocabGroups.get(theGroup);
        if (v != null) {
            uriList.addAll(v);
        }
        return uriList;
    }

    private static String getAttribute(Node n, String name) {
        String value = null;
        NamedNodeMap attrs = n.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr current = (Attr)attrs.item(i);
            String attrName = current.getName();
            if (attrName.equals(name)) {
                value = current.getValue();
            }
            ++i;
        }
        return value;
    }

    protected class TraverseCapabilityClass
    extends Stack {
        protected TraverseCapabilityClass(Node n) {
            NodeList nl = n.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                this.traverseOperator(nl.item(i));
                ++i;
            }
        }

        private int childCount(Node n) {
            int operandCount = 0;
            NodeList nl = n.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                if (this.traverseOperator(nl.item(i))) {
                    ++operandCount;
                }
                ++i;
            }
            return operandCount;
        }

        private boolean traverseOperator(Node n) {
            String nodename = n.getNodeName();
            if (nodename.equals("and") || nodename.equals("or")) {
                this.add(new Operator(nodename, this.childCount(n)));
            } else if (nodename.equals("not")) {
                if (this.childCount(n) == 1) {
                    this.add(new Operator(nodename, 1));
                } else {
                    Workspace.printDebug("CapabilityDefinition: NOT can only take a single operand");
                }
            } else if (nodename.equals("lessthan") || nodename.equals("greaterthan") || nodename.equals("lessthanequals") || nodename.equals("greaterthanequals") || nodename.equals("equals") || nodename.equals("contains")) {
                this.add(new Operand(nodename, n.getFirstChild().getNodeValue(), CapabilityDefinition.getAttribute(n, "value"), CapabilityDefinition.getAttribute(n, "namespaceAlias"), CapabilityDefinition.getAttribute(n, "namespace")));
            } else if (nodename.equals("true")) {
                this.add(new Operand(nodename, n.getFirstChild().getNodeValue(), null, CapabilityDefinition.getAttribute(n, "namespaceAlias"), CapabilityDefinition.getAttribute(n, "namespace")));
            } else {
                return false;
            }
            return true;
        }
    }
}

