/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.CapClass;
import com.hp.hpl.deli.Operand;
import com.hp.hpl.deli.Operator;
import com.hp.hpl.deli.Profile;
import com.hp.hpl.deli.ProfileAttribute;
import com.hp.hpl.deli.URI;
import com.hp.hpl.deli.Workspace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class CapabilityClass {
    private Vector matched = new Vector();
    private Vector unmatched = new Vector();
    private Vector unresolved = new Vector();

    public CapabilityClass(Profile theProfile) {
        try {
            this.evaluate(theProfile);
        }
        catch (Exception use) {
            Workspace.printDebug(use.toString());
            use.printStackTrace();
        }
    }

    public Vector getMatched() {
        return this.matched;
    }

    public Vector getUnmatched() {
        return this.unmatched;
    }

    public Vector getUnresolved() {
        return this.unresolved;
    }

    private void evaluate(Profile theProfile) throws Exception {
        if (Workspace.capabilityClasses == null) {
            return;
        }
        Iterator classesIter = Workspace.capabilityClasses.classes.iterator();
        while (classesIter.hasNext()) {
            CapClass current = (CapClass)classesIter.next();
            this.evaluateReversePolish(current, theProfile);
        }
    }

    private void evaluateReversePolish(CapClass current, Profile theProfile) throws Exception {
        Iterator constraintIter = current.constraints.iterator();
        Stack<Boolean> results = new Stack<Boolean>();
        while (constraintIter.hasNext()) {
            String type;
            Object expression = constraintIter.next();
            if (expression instanceof Operator) {
                Boolean secondValue;
                Boolean firstValue;
                Operator tOperand = (Operator)expression;
                type = tOperand.type;
                int children = tOperand.children;
                if (type.equals("and")) {
                    while (children-- > 1) {
                        firstValue = (Boolean)results.pop();
                        secondValue = (Boolean)results.pop();
                        if (firstValue == null || secondValue == null) {
                            results.push(null);
                            continue;
                        }
                        results.push(new Boolean(firstValue != false && secondValue != false));
                    }
                    continue;
                }
                if (type.equals("or")) {
                    while (children-- > 1) {
                        firstValue = (Boolean)results.pop();
                        secondValue = (Boolean)results.pop();
                        if (firstValue == null && secondValue == null) {
                            results.push(null);
                            continue;
                        }
                        if (firstValue != null && secondValue != null) {
                            results.push(new Boolean(firstValue != false || secondValue != false));
                            continue;
                        }
                        if (firstValue != null && secondValue == null) {
                            if (firstValue.booleanValue()) {
                                results.push(firstValue);
                                continue;
                            }
                            results.push(null);
                            continue;
                        }
                        if (firstValue != null || secondValue == null) continue;
                        if (secondValue.booleanValue()) {
                            results.push(secondValue);
                            continue;
                        }
                        results.push(null);
                    }
                    continue;
                }
                if (!type.equals("not")) continue;
                firstValue = (Boolean)results.pop();
                if (firstValue == null) {
                    results.push(null);
                    continue;
                }
                results.push(new Boolean(firstValue == false));
                continue;
            }
            if (!(expression instanceof Operand)) continue;
            Operand tOperator = (Operand)expression;
            type = tOperator.type;
            String value = tOperator.value;
            String ns = tOperator.namespace;
            String nsAlias = tOperator.namespaceAlias;
            String unqualifiedAttributeName = tOperator.unqualifiedAttributeName;
            URI qn = null;
            if (ns == null && nsAlias == null) {
                Vector v = Workspace.getInstance().vocabulary.getAttPropertiesWithAttName(unqualifiedAttributeName);
                qn = (URI)((HashMap)v.firstElement()).get("ccppAttribute");
            } else if (ns != null) {
                qn = new URI(ns + unqualifiedAttributeName);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                Workspace.getInstance();
                qn = new URI(stringBuffer.append(Workspace.capabilityClasses.getGroupURIs(nsAlias).firstElement()).append(unqualifiedAttributeName).toString());
            }
            ProfileAttribute tAttribute = theProfile.getAttribute(qn);
            if (tAttribute != null) {
                Vector attributeValue = tAttribute.get();
                String attributeType = tAttribute.getProperty("ccppType").getFragment();
                String attributeUri = tAttribute.getUri();
                boolean operandApplicable = false;
                if (ns == null && nsAlias == null) {
                    operandApplicable = true;
                } else if (ns != null) {
                    operandApplicable = attributeUri.equals(Workspace.getInstance().vocabulary.getRealNamespace(ns));
                } else {
                    Workspace.getInstance();
                    operandApplicable = Workspace.capabilityClasses.memberOfAliasGroup(nsAlias, attributeUri);
                }
                if (attributeType.equals("Number")) {
                    int devVal = Integer.parseInt((String)attributeValue.firstElement());
                    int conVal = Integer.parseInt(value);
                    results.push(new Boolean(operandApplicable && (type.equals("greaterthan") && devVal > conVal || type.equals("greaterthanequals") && devVal >= conVal || type.equals("lessthan") && devVal < conVal || type.equals("lessthanequals") && devVal <= conVal || type.equals("equals") && devVal == conVal)));
                    continue;
                }
                if (attributeType.equals("Dimension")) {
                    StringTokenizer devDim = new StringTokenizer((String)attributeValue.firstElement(), "x");
                    StringTokenizer valDim = new StringTokenizer(value, "x");
                    int devX = Integer.parseInt(devDim.nextToken());
                    int devY = Integer.parseInt(devDim.nextToken());
                    int valX = Integer.parseInt(valDim.nextToken());
                    int valY = Integer.parseInt(valDim.nextToken());
                    results.push(new Boolean(operandApplicable && (type.equals("greaterthan") && devX > valX && devY > valY || type.equals("greaterthanequals") && devX >= valX && devY >= valY || type.equals("lessthan") && devX < valX && devY < valY || type.equals("lessthanequals") && devX <= valX && devY <= valY || type.equals("equals") && devX == valX && devY == valY)));
                    continue;
                }
                if (attributeType.equals("Literal")) {
                    results.push(new Boolean(operandApplicable && (type.equals("equals") && tAttribute.getCollectionType().equals("Simple") && ((String)attributeValue.firstElement()).equals(value) || type.equals("contains") && attributeValue.contains(value))));
                    continue;
                }
                if (attributeType.equals("Boolean") && type.equals("true")) {
                    boolean b = operandApplicable && ((String)attributeValue.firstElement()).equals("Yes");
                    results.push(new Boolean(b));
                    continue;
                }
                Workspace.printDebug("CapabilityDefinition: Operand applied to illegal attribute type");
                Workspace.printDebug(attributeType + " " + type);
                continue;
            }
            results.push(null);
        }
        if (!results.empty()) {
            Boolean finalValue = (Boolean)results.pop();
            if (finalValue != null && finalValue.booleanValue()) {
                this.matched.add(current.name);
            } else if (finalValue != null) {
                this.unmatched.add(current.name);
            } else {
                this.unresolved.add(current.name);
            }
        } else {
            Workspace.printDebug("CapabilityDefinition: Stack error for " + current.name);
        }
    }
}

