/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.logger;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.slide.util.logger.Logger;

public class SimpleLogger
implements Logger {
    protected int loggerLevel = 0;
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.US);
    protected String[] loggingLevels = new String[]{"EMERGENCY", "CRITICAL", "ERROR", "", "WARNING", "", "INFO", "DEBUG"};

    public int getLoggerLevel() {
        return this.getLoggerLevel("org.apache.slide.util.logger");
    }

    public int getLoggerLevel(String channel) {
        return this.loggerLevel;
    }

    public boolean isEnabled(int level) {
        return this.isEnabled("org.apache.slide.util.logger", level);
    }

    public boolean isEnabled(String channel, int level) {
        return this.getLoggerLevel() >= level;
    }

    public void log(Object data) {
        this.log(data, "org.apache.slide.util.logger", 7);
    }

    public void log(Object data, int level) {
        this.log(data, "org.apache.slide.util.logger", level);
    }

    public void log(Object data, String channel, int level) {
        if (this.isEnabled(channel, level)) {
            String levelValue = "";
            channel = channel.equals("org.apache.slide.util.logger") ? "" : String.valueOf(channel) + " - ";
            if (level >= 0 && level < this.loggingLevels.length) {
                levelValue = this.loggingLevels[level];
            }
            if (this.dateFormat == null) {
                System.out.println(String.valueOf(System.currentTimeMillis()) + " - " + channel + levelValue + " - " + data);
            } else {
                System.out.println(String.valueOf(this.dateFormat.format(new Date())) + " - " + channel + levelValue + " - " + data);
            }
            if (data instanceof Throwable) {
                ((Throwable)data).printStackTrace();
            }
        }
    }

    public void setDateFormat(String pattern) {
        this.dateFormat = new SimpleDateFormat(pattern);
    }

    public void setLoggerLevel(int loggerLevel) {
        this.setLoggerLevel("org.apache.slide.util.logger", loggerLevel);
    }

    public void setLoggerLevel(String channel, int loggerLevel) {
        this.loggerLevel = loggerLevel;
    }
}

