/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.structure;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.slide.common.Domain;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.common.UriTokenizer;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.Security;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectHasChildrenException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;

public final class StructureImpl
implements Structure {
    private Namespace namespace;
    private NamespaceConfig namespaceConfig;
    private Security securityHelper;
    private Lock lockHelper;

    public StructureImpl(Namespace namespace, NamespaceConfig namespaceConfig, Security securityHelper, Lock lockHelper) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.securityHelper = securityHelper;
        this.lockHelper = lockHelper;
    }

    public void create(SlideToken token, ObjectNode object, String strUri) throws ServiceAccessException, ObjectAlreadyExistsException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException {
        Enumeration roles = this.securityHelper.getRoles(object);
        while (roles.hasMoreElements()) {
            if (this.securityHelper.hasRole(token, (String)roles.nextElement())) continue;
            Uri rootUri = this.namespace.getUri(token, "/");
            ObjectNode rootObject = rootUri.getStore().retrieveObject(rootUri);
            this.securityHelper.checkCredentials(token, rootObject, this.namespaceConfig.getGrantPermissionAction());
            break;
        }
        String resolvedUri = strUri;
        UriTokenizer uriTokenizer = new UriTokenizer(this.namespace, resolvedUri);
        Uri courUri = null;
        ObjectNode courObject = null;
        ObjectNode parentObject = null;
        boolean alreadyExists = false;
        while (uriTokenizer.hasMoreElements()) {
            parentObject = courObject;
            courUri = uriTokenizer.nextUri();
            try {
                courObject = courUri.getStore().retrieveObject(courUri);
                this.securityHelper.checkCredentials(token, courObject, this.namespaceConfig.getReadObjectAction());
                if (!uriTokenizer.hasMoreElements()) {
                    alreadyExists = true;
                }
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                ObjectNode newObject = null;
                if (uriTokenizer.hasMoreElements()) {
                    throw new ObjectNotFoundException(courUri);
                }
                newObject = object;
                if (parentObject == null) {
                    throw new ObjectNotFoundException(courUri);
                }
                this.securityHelper.checkCredentials(token, courObject, this.namespaceConfig.getCreateObjectAction());
                Object grantedPermission = null;
                String userUri = String.valueOf(this.namespaceConfig.getUsersPath()) + "/" + token.getCredentialsToken().getPublicCredentials();
                Domain.debug("Checking basic permissions on new object");
                Domain.debug("Basic permissions granted for user " + token.getCredentialsToken().getPublicCredentials());
                newObject.setUri(courUri.toString());
                courUri.getStore().createObject(courUri, newObject);
                Uri parentUri = this.namespace.getUri(token, parentObject.getUri());
                parentObject = parentUri.getStore().retrieveObject(parentUri);
                parentObject.addChild(newObject);
                this.store(token, parentObject);
                courObject = newObject;
            }
            if (!uriTokenizer.hasMoreElements() || !(courObject instanceof LinkNode)) continue;
            Uri linkedUri = this.namespace.getUri(((LinkNode)courObject).getLinkedUri());
            String courStrUri = courUri.toString();
            resolvedUri = String.valueOf(linkedUri.toString()) + resolvedUri.substring(courStrUri.length());
            uriTokenizer = new UriTokenizer(this.namespace, resolvedUri);
            boolean isUriFound = false;
            while (!isUriFound && uriTokenizer.hasMoreElements()) {
                if (!linkedUri.equals(uriTokenizer.nextUri())) continue;
                isUriFound = true;
            }
            if (isUriFound) continue;
            throw new LinkedObjectNotFoundException(courUri, resolvedUri);
        }
        if (alreadyExists) {
            parentObject.addChild(courObject);
            this.store(token, parentObject);
            throw new ObjectAlreadyExistsException(strUri);
        }
    }

    public void createLink(SlideToken token, LinkNode link, String linkUri, ObjectNode linkedObject) throws ServiceAccessException, ObjectAlreadyExistsException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException {
        link.setLinkedUri(linkedObject.getUri());
        this.create(token, link, linkUri);
    }

    public Enumeration getChildren(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException, LinkedObjectNotFoundException {
        Enumeration childrenUri = object.enumerateChildren();
        Vector<ObjectNode> result = new Vector<ObjectNode>();
        while (childrenUri.hasMoreElements()) {
            String childUri = (String)childrenUri.nextElement();
            try {
                ObjectNode child = this.retrieve(token, childUri, false);
                result.addElement(child);
            }
            catch (AccessDeniedException accessDeniedException) {}
        }
        return result.elements();
    }

    public ObjectNode getParent(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException {
        String objectUriStr = object.getUri();
        Uri parentUri = this.namespace.getUri(token, objectUriStr).getParentUri();
        if (parentUri == null) {
            return null;
        }
        String parentUriStr = parentUri.toString();
        ObjectNode parent = this.retrieve(token, parentUriStr);
        return parent;
    }

    public void remove(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException, ObjectHasChildrenException, AccessDeniedException, LinkedObjectNotFoundException, ObjectLockedException {
        ObjectNode realObject = this.retrieve(token, object.getUri(), false);
        Enumeration enumeration = realObject.enumerateChildren();
        Uri uri = this.namespace.getUri(token, realObject.getUri());
        if (enumeration.hasMoreElements()) {
            throw new ObjectHasChildrenException(uri);
        }
        if (!object.getUri().equals("/")) {
            Uri curUri = this.namespace.getUri(token, realObject.getUri());
            Uri parentUri = curUri.getParentUri();
            ObjectNode obj = parentUri.getStore().retrieveObject(parentUri);
            obj.removeChild(realObject.getUri());
            this.securityHelper.checkCredentials(token, realObject, this.namespaceConfig.getRemoveObjectAction());
            this.lockHelper.checkLock(token, realObject, this.namespaceConfig.getRemoveObjectAction());
            this.store(token, obj);
            uri.getStore().removeObject(uri, realObject);
        }
    }

    public ObjectNode retrieve(SlideToken token, String strUri) throws ServiceAccessException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException {
        return this.retrieve(token, strUri, true);
    }

    public ObjectNode retrieve(SlideToken token, String strUri, boolean translateLastUriElement) throws ServiceAccessException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException {
        Uri uri = this.namespace.getUri(token, strUri);
        ObjectNode result = null;
        try {
            result = uri.getStore().retrieveObject(uri);
            this.securityHelper.checkCredentials(token, result, this.namespaceConfig.getReadObjectAction());
            if (translateLastUriElement && result instanceof LinkNode) {
                LinkNode link = (LinkNode)result;
                Uri linkedUri = this.namespace.getUri(token, link.getLinkedUri());
                result = linkedUri.getStore().retrieveObject(linkedUri);
                this.securityHelper.checkCredentials(token, result, this.namespaceConfig.getReadObjectAction());
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        if (result == null) {
            String resolvedUri = uri.toString();
            UriTokenizer uriTokenizer = new UriTokenizer(uri.getNamespace(), resolvedUri);
            Uri courUri = null;
            ObjectNode courObject = null;
            while (uriTokenizer.hasMoreElements()) {
                courUri = uriTokenizer.nextUri();
                courObject = courUri.getStore().retrieveObject(courUri);
                this.securityHelper.checkCredentials(token, courObject, this.namespaceConfig.getReadObjectAction());
                if ((!translateLastUriElement || !(courObject instanceof LinkNode)) && (translateLastUriElement || !uriTokenizer.hasMoreElements() || !(courObject instanceof LinkNode))) continue;
                Uri linkedUri = this.namespace.getUri(((LinkNode)courObject).getLinkedUri());
                String courStrUri = courUri.toString();
                resolvedUri = String.valueOf(linkedUri.toString()) + resolvedUri.substring(courStrUri.length());
                uriTokenizer = new UriTokenizer(uri.getNamespace(), resolvedUri);
                boolean isUriFound = false;
                while (!isUriFound && uriTokenizer.hasMoreElements()) {
                    if (!linkedUri.equals(uriTokenizer.nextUri())) continue;
                    isUriFound = true;
                }
                if (isUriFound) continue;
                throw new LinkedObjectNotFoundException(courUri, resolvedUri);
            }
            result = courObject;
        }
        return result;
    }

    public void store(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException {
        Enumeration roles = this.securityHelper.getRoles(object);
        while (roles.hasMoreElements()) {
            if (this.securityHelper.hasRole(token, (String)roles.nextElement())) continue;
            Uri rootUri = this.namespace.getUri(token, "/");
            ObjectNode rootObject = rootUri.getStore().retrieveObject(rootUri);
            this.securityHelper.checkCredentials(token, rootObject, this.namespaceConfig.getGrantPermissionAction());
            break;
        }
        ObjectNode realObject = this.retrieve(token, object.getUri(), false);
        this.securityHelper.checkCredentials(token, realObject, this.namespaceConfig.getCreateObjectAction());
        Uri realObjectUri = this.namespace.getUri(token, realObject.getUri());
        realObjectUri.getStore().storeObject(realObjectUri, object);
    }
}

