/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.structure;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.util.Messages;

public abstract class ObjectNode
implements Serializable,
Cloneable {
    protected String uri;
    private Vector children = new Vector();
    private boolean childrenShared;
    private Vector links = new Vector();
    private boolean linksShared;
    static /* synthetic */ Class class$org$apache$slide$structure$ObjectNode;

    public ObjectNode() {
    }

    public ObjectNode(String uri) {
        this.uri = uri;
    }

    public ObjectNode(String uri, Vector children, Vector links) {
        this.uri = uri;
        this.children = children;
        this.links = links;
    }

    void addChild(String uri) {
        if (uri != null && !this.hasChild(uri)) {
            if (this.childrenShared) {
                this.children = (Vector)this.children.clone();
                this.childrenShared = false;
            }
            this.children.addElement(uri);
        }
    }

    void addChild(ObjectNode child) {
        this.addChild(child.getUri());
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ObjectNode cloneObject() {
        ObjectNode result = null;
        try {
            this.childrenShared = true;
            this.linksShared = true;
            result = (ObjectNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ObjectNode copyObject() {
        ObjectNode result = null;
        try {
            result = (ObjectNode)super.clone();
            result.childrenShared = false;
            result.linksShared = false;
            result.children = new Vector();
            result.links = new Vector();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Enumeration enumerateChildren() {
        return this.children.elements();
    }

    public Enumeration enumerateLinks() {
        return this.links.elements();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof ObjectNode) {
            ObjectNode tempObject = (ObjectNode)obj;
            result = this.uri.equals(tempObject.getUri());
        }
        return result;
    }

    public Enumeration getChildren() {
        return this.enumerateChildren();
    }

    public String getUri() {
        return this.uri;
    }

    public boolean hasChild(String uri) {
        return this.children.contains(uri);
    }

    public boolean hasChild(ObjectNode child) {
        boolean result = false;
        if (child != null) {
            result = this.children.contains(child.getUri());
        }
        return result;
    }

    public boolean hasChildren() {
        return this.children.isEmpty() ^ true;
    }

    void removeChild(String uri) {
        if (this.childrenShared) {
            this.children = (Vector)this.children.clone();
            this.childrenShared = false;
        }
        this.children.removeElement(uri);
    }

    void removeChildren() {
        if (this.childrenShared) {
            this.children = new Vector();
            this.childrenShared = false;
        } else {
            this.children.removeAllElements();
        }
    }

    void setUri(String uri) {
        this.uri = uri;
    }

    public void validate(String expectedUri) {
        if (this.uri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$structure$ObjectNode != null ? class$org$apache$slide$structure$ObjectNode : (class$org$apache$slide$structure$ObjectNode = ObjectNode.class$("org.apache.slide.structure.ObjectNode"))).getName()) + ".nullUri"));
        }
        if (!this.uri.equals(expectedUri)) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$structure$ObjectNode != null ? class$org$apache$slide$structure$ObjectNode : (class$org$apache$slide$structure$ObjectNode = ObjectNode.class$("org.apache.slide.structure.ObjectNode"))).getName()) + ".incorrectUri"));
        }
        if (this.children == null) {
            throw new ObjectValidationFailedException(this.uri, Messages.message(String.valueOf((class$org$apache$slide$structure$ObjectNode != null ? class$org$apache$slide$structure$ObjectNode : (class$org$apache$slide$structure$ObjectNode = ObjectNode.class$("org.apache.slide.structure.ObjectNode"))).getName()) + ".nullChildrenVector"));
        }
        if (this.links == null) {
            throw new ObjectValidationFailedException(this.uri, Messages.message(String.valueOf((class$org$apache$slide$structure$ObjectNode != null ? class$org$apache$slide$structure$ObjectNode : (class$org$apache$slide$structure$ObjectNode = ObjectNode.class$("org.apache.slide.structure.ObjectNode"))).getName()) + ".nullLinksVector"));
        }
    }
}

