/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.impl.rdbms.AbstractRDBMSAdapter;
import org.apache.slide.store.impl.rdbms.JDBCAwareInputStream;
import org.apache.slide.store.impl.rdbms.JDBCUtils;
import org.apache.slide.store.impl.rdbms.StoreContentZip;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.util.QName;

public class StandardRDBMSAdapter
extends AbstractRDBMSAdapter {
    public static final int BUFFER_SIZE = 2048;
    private static final int CACHE_SIZE = 200;
    private static Hashtable uriIdLookup = new Hashtable(200);
    private static Hashtable uriLookup = new Hashtable(200);
    private static Hashtable qnIdLookup = new Hashtable(200);
    private static Hashtable qnLookup = new Hashtable(200);
    private NodeRevisionDescriptor myRevisionDescriptor = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Vector;

    public StandardRDBMSAdapter(Service service) {
        super(service);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createObject(Connection conn, Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        Statement stmt = null;
        try {
            try {
                long linkTargetId;
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                long uriId = this.getUriId(conn, uri.toString(), true);
                sql.setLength(0);
                sql.append("SELECT CLASS_NAME FROM SLIDE_OBJECT WHERE URI_ID = ").append(uriId);
                ResultSet rs = stmt.executeQuery(sql.toString());
                if (rs.next()) {
                    throw new ObjectAlreadyExistsException(uri.toString());
                }
                sql.setLength(0);
                sql.append("INSERT INTO SLIDE_OBJECT (URI_ID, CLASS_NAME) ").append("VALUES (").append(uriId).append(", '").append(object.getClass().getName()).append("')");
                stmt.executeUpdate(sql.toString());
                Enumeration children = this.getNewChildren(conn, uriId, object.enumerateChildren());
                if (children != null) {
                    while (children.hasMoreElements()) {
                        sql.setLength(0);
                        sql.append("INSERT INTO SLIDE_CHILD (URI_ID,CHILD_URI_ID) ").append("VALUES (").append(uriId).append(", ").append(this.getUriId(conn, (String)children.nextElement())).append(" )");
                        stmt.executeUpdate(sql.toString());
                    }
                }
                if (object instanceof LinkNode && !this.isLinkExist(conn, uriId, linkTargetId = this.getUriId(conn, ((LinkNode)object).getLinkedUri()))) {
                    sql.setLength(0);
                    sql.append("INSERT INTO SLIDE_LINK ").append("(URI_ID, TARGET_URI_ID) ").append("VALUES (").append(uriId).append(", ").append(linkTargetId).append(")");
                    stmt.executeUpdate(sql.toString());
                }
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_12 = null;
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return;
            stmt.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    public void createRevisionContent(Connection conn, Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        String revisionUri = uri.toString();
        NodeRevisionNumber nrn = revisionDescriptor.getRevisionNumber();
        long contentLength = revisionDescriptor.getContentLength();
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                long versionId = this.getRevisionId(conn, this.getUriId(conn, revisionUri), revisionDescriptor.getBranchName(), nrn);
                sql.setLength(0);
                sql.append("SELECT 1 FROM SLIDE_REVISION_CONTENT ").append("WHERE REVISION_ID = ").append(versionId);
                ResultSet rs = stmt.executeQuery(sql.toString());
                if (rs.next()) {
                    throw new RevisionAlreadyExistException(uri.toString(), revisionDescriptor.getRevisionNumber());
                }
                this.storeContent(conn, revisionUri, nrn.toString(), revisionDescriptor, revisionContent);
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, e.getMessage());
            }
            catch (IOException e) {
                throw new ServiceAccessException(this.service, e.getMessage());
            }
            catch (RevisionAlreadyExistException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServiceAccessException(this.service, e.getMessage());
            }
            Object var11_17 = null;
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            throw throwable;
        }
        try {
            stmt.close();
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createRevisionDescriptor(Connection conn, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        Statement stmt = null;
        Statement pstmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                ResultSet rs = null;
                stmt = conn.createStatement();
                long uriId = this.getUriId(conn, uri.toString());
                long branchId = this.getBranchId(conn, revisionDescriptor.getBranchName());
                if (branchId == 0L) {
                    this.setBranchId(conn, revisionDescriptor.getBranchName());
                    branchId = this.getBranchId(conn, revisionDescriptor.getBranchName());
                }
                sql.setLength(0);
                sql.append("SELECT 1 FROM SLIDE_REVISION_HISTORY WHERE URI_ID = ").append(uriId);
                rs = stmt.executeQuery(sql.toString());
                if (!rs.next()) {
                    sql.setLength(0);
                    sql.append("INSERT INTO SLIDE_REVISION_HISTORY ").append("(URI_ID, VERSIONED) ").append("VALUES (").append(uriId).append(", ").append(0).append(")");
                    stmt.execute(sql.toString());
                }
                sql.setLength(0);
                sql.append("SELECT 1 FROM SLIDE_REVISION WHERE URI_ID = ").append(uriId).append(" AND BRANCH_ID = ").append(branchId).append(" AND REVISION_NUMBER = '").append(revisionDescriptor.getRevisionNumber().toString()).append("'");
                rs = stmt.executeQuery(sql.toString());
                if (!rs.next()) {
                    sql.setLength(0);
                    sql.append("INSERT INTO SLIDE_REVISION (URI_ID, BRANCH_ID, ").append("REVISION_NUMBER) VALUES (").append(uriId).append(", ").append(branchId).append(", '").append(revisionDescriptor.getRevisionNumber().toString()).append("')");
                    stmt.execute(sql.toString());
                }
                long versionId = this.getRevisionId(conn, uriId, revisionDescriptor.getBranchName(), revisionDescriptor.getRevisionNumber());
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_REVISION_LABEL ").append("WHERE REVISION_ID = ").append(versionId);
                stmt.execute(sql.toString());
                Enumeration labels = revisionDescriptor.enumerateLabels();
                while (labels.hasMoreElements()) {
                    String label = (String)labels.nextElement();
                    long labelId = this.getLabelId(conn, label);
                    if (labelId == 0L) {
                        this.setLabelId(conn, label);
                        labelId = this.getLabelId(conn, label);
                    }
                    sql.setLength(0);
                    sql.append("INSERT INTO SLIDE_REVISION_LABEL ").append("(REVISION_ID,LABEL_ID) ").append("VALUES (").append(versionId).append(", ").append(labelId).append(")");
                    stmt.execute(sql.toString());
                }
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_REVISION_PROPERTY ").append("WHERE REVISION_ID = ").append(versionId);
                stmt.execute(sql.toString());
                Enumeration properties = revisionDescriptor.enumerateProperties();
                sql.setLength(0);
                sql.append("INSERT INTO SLIDE_REVISION_PROPERTY (REVISION_ID, ").append("QNAME_ID, PROPERTY_VALUE, PROTECTED) ").append("VALUES (?, ?, ?, ?)");
                pstmt = conn.prepareStatement(sql.toString());
                while (properties.hasMoreElements()) {
                    NodeProperty property = (NodeProperty)properties.nextElement();
                    long qnId = this.getQNameId(conn, new QName(property.getNamespace(), property.getName()), true);
                    pstmt.setLong(1, versionId);
                    pstmt.setLong(2, qnId);
                    pstmt.setString(3, property.getValue().toString());
                    pstmt.setBoolean(4, property.isProtected());
                    pstmt.execute();
                }
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var7_19 = null;
        }
        catch (Throwable throwable) {
            Object var7_20 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (pstmt == null) throw throwable;
                pstmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (pstmt == null) return;
            pstmt.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createRevisionDescriptors(Connection conn, Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                ResultSet rs = null;
                stmt = conn.createStatement();
                long uriId = this.getUriId(conn, uri.toString());
                sql.setLength(0);
                sql.append("SELECT 1 FROM SLIDE_REVISION_HISTORY WHERE URI_ID = ").append(uriId);
                rs = stmt.executeQuery(sql.toString());
                if (!rs.next()) {
                    sql.setLength(0);
                    sql.append("INSERT INTO SLIDE_REVISION_HISTORY ").append("(URI_ID, VERSIONED) ").append("VALUES (").append(uriId).append(", ").append(revisionDescriptors.isVersioned()).append(")");
                    stmt.execute(sql.toString());
                }
                String branch = "main";
                long branchId = this.getBranchId(conn, branch);
                NodeRevisionNumber nrn = revisionDescriptors.getLatestRevision();
                sql.setLength(0);
                sql.append("SELECT 1 FROM SLIDE_REVISION ").append("WHERE URI_ID = ").append(uriId).append(" AND BRANCH_ID = ").append(branchId).append(" AND REVISION_NUMBER ").append(nrn != null ? "= '" + nrn + "'" : " IS NULL");
                rs = stmt.executeQuery(sql.toString());
                if (!rs.next() && nrn != null) {
                    sql.setLength(0);
                    sql.append("INSERT INTO SLIDE_REVISION ").append("(URI_ID, BRANCH_ID, REVISION_NUMBER) ").append("VALUES (").append(uriId).append(", ").append(branchId).append(", '").append(nrn).append("')");
                    stmt.execute(sql.toString());
                }
                if (nrn != null) {
                    long revisionId = this.getRevisionId(conn, uriId, branch, nrn);
                    sql.setLength(0);
                    sql.append("INSERT INTO SLIDE_REVISION_LATEST ").append("VALUES (").append(uriId).append(", ").append(branchId).append(", ").append(revisionId).append(")");
                    stmt.execute(sql.toString());
                }
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_14 = null;
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return;
            stmt.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    public Enumeration enumerateLocks(Connection conn, Uri uri) throws ServiceAccessException {
        Vector<NodeLock> result = new Vector<NodeLock>();
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                sql.setLength(0);
                sql.append("SELECT * FROM SLIDE_LOCK WHERE OBJECT_ID = ").append(this.getUriId(conn, uri.toString()));
                ResultSet rs = stmt.executeQuery(sql.toString());
                while (rs.next()) {
                    Date expirationDate = null;
                    try {
                        long timeValue = rs.getLong("EXPIRATION_DATE");
                        expirationDate = new Date(timeValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        expirationDate = new Date();
                    }
                    NodeLock lock = new NodeLock(this.getUri(conn, rs.getLong("LOCK_ID")), this.getUri(conn, rs.getLong("OBJECT_ID")), this.getUri(conn, rs.getLong("SUBJECT_ID")), this.getUri(conn, rs.getLong("ACTION_ID")), expirationDate, rs.getBoolean("INHERITABLE"), rs.getBoolean("EXCLUSIVE"));
                    result.addElement(lock);
                }
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_12 = null;
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            throw throwable;
        }
        try {
            stmt.close();
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
        return result.elements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Enumeration enumeratePermissions(Connection conn, Uri uri) throws ServiceAccessException {
        Vector<NodePermission> result = new Vector<NodePermission>();
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                sql.setLength(0);
                sql.append("SELECT * FROM SLIDE_PERMISSION ").append("WHERE OBJECT_ID = ").append(this.getUriId(conn, uri.toString()));
                ResultSet rs = stmt.executeQuery(sql.toString());
                while (rs.next()) {
                    String subject = this.getUri(conn, rs.getLong("SUBJECT_ID"));
                    String action = this.getUri(conn, rs.getLong("ACTION_ID"));
                    String revision = rs.getString("REVISION_NUMBER");
                    boolean inheritable = rs.getBoolean("INHERITABLE");
                    boolean negative = rs.getBoolean("NEGATIVE");
                    NodePermission permission = new NodePermission(uri.toString(), revision, subject, action, inheritable, negative);
                    result.addElement(permission);
                }
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_15 = null;
        }
        catch (Throwable throwable) {
            Object var6_16 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return result.elements();
            stmt.close();
            return result.elements();
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getBranchId(Connection conn, String branchName) throws SQLException {
        long l;
        Statement stmt;
        block8: {
            long l2;
            block7: {
                stmt = null;
                try {
                    StringBuffer sql = new StringBuffer();
                    sql.append("SELECT BRANCH_ID FROM SLIDE_BRANCH ").append("WHERE BRANCH_NAME = '").append(branchName).append("'");
                    stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(sql.toString());
                    if (rs.next()) {
                        l2 = rs.getLong("BRANCH_ID");
                        Object var7_8 = null;
                        if (stmt == null) return l2;
                        break block7;
                    }
                    l = 0L;
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        throw throwable;
                    }
                }
            }
            try {}
            catch (SQLException sQLException) {}
            stmt.close();
            return l2;
        }
        Object var7_9 = null;
        if (stmt == null) return l;
        try {}
        catch (SQLException sQLException) {}
        stmt.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getBranchName(Connection conn, long branchID) throws SQLException {
        String string;
        Statement stmt;
        block8: {
            String string2;
            block7: {
                stmt = null;
                try {
                    StringBuffer sql = new StringBuffer();
                    sql.append("SELECT BRANCH_NAME FROM SLIDE_BRANCH ").append("WHERE BRANCH_ID = ").append(branchID);
                    stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(sql.toString());
                    if (rs.next()) {
                        string2 = rs.getString("BRANCH_NAME");
                        Object var7_8 = null;
                        if (stmt == null) return string2;
                        break block7;
                    }
                    string = null;
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        throw throwable;
                    }
                }
            }
            try {}
            catch (SQLException sQLException) {}
            stmt.close();
            return string2;
        }
        Object var7_9 = null;
        if (stmt == null) return string;
        try {}
        catch (SQLException sQLException) {}
        stmt.close();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getLabelId(Connection conn, String label) throws SQLException {
        long l;
        Statement stmt;
        block8: {
            long l2;
            block7: {
                stmt = null;
                try {
                    StringBuffer sql = new StringBuffer();
                    sql.append("SELECT LABEL_ID FROM SLIDE_LABEL ").append("WHERE LABEL_NAME = '").append(label).append("'");
                    stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(sql.toString());
                    if (rs.next()) {
                        l2 = rs.getLong("LABEL_ID");
                        Object var7_8 = null;
                        if (stmt == null) return l2;
                        break block7;
                    }
                    l = 0L;
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        throw throwable;
                    }
                }
            }
            try {}
            catch (SQLException sQLException) {}
            stmt.close();
            return l2;
        }
        Object var7_9 = null;
        if (stmt == null) return l;
        try {}
        catch (SQLException sQLException) {}
        stmt.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getLabelName(Connection conn, long labelID) throws SQLException {
        String string;
        Statement stmt;
        block8: {
            String string2;
            block7: {
                stmt = null;
                try {
                    StringBuffer sql = new StringBuffer();
                    sql.append("SELECT LABEL_NAME FROM SLIDE_LABEL ").append("WHERE LABEL_ID = ").append(labelID);
                    stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(sql.toString());
                    if (rs.next()) {
                        string2 = rs.getString("LABEL_NAME");
                        Object var7_8 = null;
                        if (stmt == null) return string2;
                        break block7;
                    }
                    string = null;
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        throw throwable;
                    }
                }
            }
            try {}
            catch (SQLException sQLException) {}
            stmt.close();
            return string2;
        }
        Object var7_9 = null;
        if (stmt == null) return string;
        try {}
        catch (SQLException sQLException) {}
        stmt.close();
        return string;
    }

    protected Enumeration getNewChildren(Connection conn, long parent, Enumeration childlist) throws SQLException {
        Hashtable<String, String> hshtempHash = new Hashtable<String, String>();
        Hashtable<String, String> hshnewChild = new Hashtable<String, String>();
        Statement getStatement = conn.createStatement();
        StringBuffer sql = new StringBuffer().append("SELECT A.URI_STRING FROM SLIDE_URI A, SLIDE_CHILD B ").append("WHERE A.URI_ID = B.CHILD_URI_ID ").append("AND B.URI_ID = ").append(parent);
        ResultSet rslt = getStatement.executeQuery(sql.toString());
        String s_child = null;
        while (rslt.next()) {
            s_child = rslt.getString("URI_STRING");
            hshtempHash.put(s_child, s_child);
        }
        rslt.close();
        while (childlist.hasMoreElements()) {
            String temp_child = (String)childlist.nextElement();
            if (hshtempHash.containsKey(temp_child)) continue;
            hshnewChild.put(temp_child, temp_child);
        }
        hshtempHash.clear();
        return hshnewChild.elements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected QName getQName(Connection conn, long qnId) throws SQLException {
        QName qName;
        Statement stmt = null;
        try {
            Long qnIdLong = new Long(qnId);
            QName qn = (QName)qnLookup.get(qnIdLong);
            if (qn == null) {
                StringBuffer sql = new StringBuffer().append("SELECT NAMESPACE_URI, LOCAL_NAME ").append("FROM SLIDE_QNAME WHERE QNAME_ID = ").append(qnId);
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(sql.toString());
                if (rs.next()) {
                    qn = new QName(rs.getString("NAMESPACE_URI"), rs.getString("LOCAL_NAME"));
                    if (qnLookup.size() == 200) {
                        qnLookup.clear();
                        qnIdLookup.clear();
                    }
                    qnLookup.put(qnIdLong, qn);
                    qnIdLookup.put(qn, qnIdLong);
                }
            }
            qName = qn;
            Object var7_9 = null;
            if (stmt == null) return qName;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            stmt.close();
            return qName;
        }
        catch (SQLException sQLException) {}
        return qName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long getQNameId(Connection conn, QName qn, boolean create) throws SQLException {
        long l;
        Statement stmt = null;
        try {
            Long qnIdLong = (Long)qnIdLookup.get(qn);
            if (qnIdLong == null) {
                StringBuffer sql = new StringBuffer().append("SELECT QNAME_ID FROM SLIDE_QNAME ").append("WHERE NAMESPACE_URI = '").append(JDBCUtils.encode(qn.getNamespaceURI())).append("' AND LOCAL_NAME = '").append(JDBCUtils.encode(qn.getLocalName())).append("'");
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(sql.toString());
                if (rs.next()) {
                    qnIdLong = new Long(rs.getLong("QNAME_ID"));
                } else if (create) {
                    sql.setLength(0);
                    sql.append("INSERT INTO SLIDE_QNAME ").append("(NAMESPACE_URI, LOCAL_NAME) VALUES ('").append(JDBCUtils.encode(qn.getNamespaceURI())).append("', '").append(JDBCUtils.encode(qn.getLocalName())).append("')");
                    stmt = conn.createStatement();
                    stmt.executeUpdate(sql.toString());
                    qnIdLong = new Long(this.getQNameId(conn, qn, false));
                }
                if (qnIdLong != null) {
                    if (qnIdLookup.size() == 200) {
                        qnIdLookup.clear();
                        qnLookup.clear();
                    }
                    qnIdLookup.put(qn, qnIdLong);
                    qnLookup.put(qnIdLong, qn);
                }
            }
            l = qnIdLong != null ? qnIdLong : 0L;
            Object var8_9 = null;
            if (stmt == null) return l;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            stmt.close();
            return l;
        }
        catch (SQLException sQLException) {}
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getRevisionId(Connection conn, long uriId, String branch, NodeRevisionNumber nrn) throws SQLException {
        long l;
        Statement stmt;
        block8: {
            long l2;
            block7: {
                stmt = null;
                try {
                    StringBuffer sql = new StringBuffer();
                    stmt = conn.createStatement();
                    sql.setLength(0);
                    sql.append("SELECT A.REVISION_ID ").append("FROM SLIDE_REVISION A, SLIDE_BRANCH B ").append("WHERE A.URI_ID = ").append(uriId).append(" AND A.BRANCH_ID = B.BRANCH_ID ").append(" AND B.BRANCH_NAME = '").append(branch).append("' AND A.REVISION_NUMBER ").append(nrn != null ? "= '" + nrn + "'" : "IS NULL");
                    ResultSet rs = stmt.executeQuery(sql.toString());
                    if (rs.next()) {
                        l2 = rs.getLong("REVISION_ID");
                        Object var10_10 = null;
                        if (stmt == null) return l2;
                        break block7;
                    }
                    l = 0L;
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        throw throwable;
                    }
                }
            }
            try {}
            catch (SQLException sQLException) {}
            stmt.close();
            return l2;
        }
        Object var10_11 = null;
        if (stmt == null) return l;
        try {}
        catch (SQLException sQLException) {}
        stmt.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getRevisionNumber(Connection conn, long versionId) throws SQLException {
        String string;
        Statement stmt;
        block8: {
            String string2;
            block7: {
                stmt = null;
                try {
                    StringBuffer sql = new StringBuffer();
                    stmt = conn.createStatement();
                    sql.append("SELECT REVISION_NUMBER FROM SLIDE_REVISION ").append("WHERE REVISION_ID = ").append(versionId);
                    ResultSet rs = stmt.executeQuery(sql.toString());
                    if (rs.next()) {
                        string2 = rs.getString("REVISION_NUMBER");
                        Object var7_8 = null;
                        if (stmt == null) return string2;
                        break block7;
                    }
                    string = null;
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        throw throwable;
                    }
                }
            }
            try {}
            catch (SQLException sQLException) {}
            stmt.close();
            return string2;
        }
        Object var7_9 = null;
        if (stmt == null) return string;
        try {}
        catch (SQLException sQLException) {}
        stmt.close();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getUri(Connection conn, long uriId) throws SQLException {
        String string;
        Statement stmt = null;
        try {
            Long uriIdLong = new Long(uriId);
            String uri = (String)uriLookup.get(uriIdLong);
            if (uri == null) {
                StringBuffer sql = new StringBuffer().append("SELECT URI_STRING FROM SLIDE_URI WHERE URI_ID = ").append(uriId);
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(sql.toString());
                if (rs.next()) {
                    uri = rs.getString("URI_STRING");
                    if (uriLookup.size() == 200) {
                        uriLookup.clear();
                        uriIdLookup.clear();
                    }
                    uriLookup.put(uriIdLong, uri);
                    uriIdLookup.put(uri, uriIdLong);
                }
            }
            string = uri;
            Object var7_9 = null;
            if (stmt == null) return string;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            stmt.close();
            return string;
        }
        catch (SQLException sQLException) {}
        return string;
    }

    protected long getUriId(Connection conn, String uri) throws SQLException {
        return this.getUriId(conn, uri, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long getUriId(Connection conn, String uri, boolean create) throws SQLException {
        long l;
        Statement stmt = null;
        try {
            Long uriIdLong = (Long)uriIdLookup.get(uri);
            if (uriIdLong == null) {
                StringBuffer sql = new StringBuffer().append("SELECT URI_ID FROM SLIDE_URI WHERE URI_STRING = '").append(JDBCUtils.encode(uri)).append("'");
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(sql.toString());
                if (rs.next()) {
                    uriIdLong = new Long(rs.getLong("URI_ID"));
                } else if (create) {
                    sql.setLength(0);
                    sql.append("INSERT INTO SLIDE_URI (URI_STRING) VALUES ('").append(JDBCUtils.encode(uri)).append("')");
                    stmt = conn.createStatement();
                    stmt.executeUpdate(sql.toString());
                    uriIdLong = new Long(this.getUriId(conn, uri, false));
                }
                if (uriIdLong != null) {
                    if (uriIdLookup.size() == 200) {
                        uriIdLookup.clear();
                        uriLookup.clear();
                    }
                    uriIdLookup.put(uri, uriIdLong);
                    uriLookup.put(uriIdLong, uri);
                }
            }
            l = uriIdLong != null ? uriIdLong : 0L;
            Object var8_9 = null;
            if (stmt == null) return l;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            stmt.close();
            return l;
        }
        catch (SQLException sQLException) {}
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void grantPermission(Connection conn, Uri uri, NodePermission permission) throws ServiceAccessException {
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                long objectId = this.getUriId(conn, permission.getObjectUri(), true);
                long subjectId = this.getUriId(conn, permission.getSubjectUri(), true);
                long actionId = this.getUriId(conn, permission.getActionUri(), true);
                sql.setLength(0);
                sql.append("SELECT 1 FROM SLIDE_PERMISSION ").append("WHERE OBJECT_ID = ").append(objectId).append(" AND SUBJECT_ID = ").append(subjectId).append(" AND ACTION_ID = ").append(actionId);
                ResultSet rs = stmt.executeQuery(sql.toString());
                if (!rs.next()) {
                    NodeRevisionNumber nrn = permission.getRevisionNumber();
                    sql.setLength(0);
                    sql.append("INSERT INTO SLIDE_PERMISSION ").append("(OBJECT_ID, SUBJECT_ID, ACTION_ID, ").append("REVISION_NUMBER, INHERITABLE, NEGATIVE) VALUES (").append(objectId).append(", ").append(subjectId).append(", ").append(actionId).append(", ").append(nrn == null ? "NULL" : nrn.toString()).append(", ").append(permission.isInheritable()).append(", ").append(permission.isNegative()).append(")");
                    stmt.executeUpdate(sql.toString());
                }
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_13 = null;
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return;
            stmt.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    protected boolean isLinkExist(Connection conn, long parent, long child) throws SQLException {
        Statement getStatement = conn.createStatement();
        StringBuffer sql = new StringBuffer("select 1 from SLIDE_LINK where URI_ID = ");
        sql.append(parent).append(" and TARGET_URI_ID = ").append(child);
        ResultSet rslt = getStatement.executeQuery(sql.toString());
        return rslt.next();
    }

    protected boolean isLockExist(Connection conn, long parent) throws SQLException {
        Statement getStatement = conn.createStatement();
        StringBuffer sql = new StringBuffer("select 1 from SLIDE_LOCK where LOCK_ID = ");
        sql.append(parent);
        ResultSet rslt = getStatement.executeQuery(sql.toString());
        return rslt.next();
    }

    public void killLock(Connection conn, Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.removeLock(conn, uri, lock);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putLock(Connection conn, Uri uri, NodeLock lock) throws ServiceAccessException {
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                long lockId = this.getUriId(conn, lock.getLockId());
                if (lockId == 0L) {
                    lockId = this.getUriId(conn, lock.getLockId(), true);
                }
                sql.setLength(0);
                sql.append("INSERT INTO SLIDE_LOCK (LOCK_ID, OBJECT_ID, ").append("SUBJECT_ID, ACTION_ID, EXPIRATION_DATE, INHERITABLE, ").append("EXCLUSIVE) VALUES (").append(lockId).append(", ").append(this.getUriId(conn, lock.getObjectUri())).append(", ").append(this.getUriId(conn, lock.getSubjectUri())).append(", ").append(this.getUriId(conn, lock.getTypeUri())).append(", ").append(lock.getExpirationDate().getTime()).append(", ").append(lock.isInheritable()).append(", ").append(lock.isExclusive()).append(")");
                stmt.executeUpdate(sql.toString());
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return;
            stmt.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeLock(Connection conn, Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                long lockId = this.getUriId(conn, lock.getLockId());
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_LOCK WHERE LOCK_ID = ").append(lockId);
                stmt.executeUpdate(sql.toString());
                this.removeUri(conn, lock.getLockId());
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return;
            stmt.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeObject(Connection conn, Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                long uriId = this.getUriId(conn, object.getUri());
                if (uriId == 0L) {
                    throw new ObjectNotFoundException(uri);
                }
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_CHILD WHERE URI_ID = ").append(uriId).append(" OR CHILD_URI_ID = ").append(uriId);
                stmt.executeUpdate(sql.toString());
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_LINK WHERE URI_ID = ").append(uriId);
                stmt.executeUpdate(sql.toString());
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_OBJECT WHERE URI_ID = ").append(uriId);
                stmt.executeUpdate(sql.toString());
                this.removeUri(conn, object.getUri());
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return;
            stmt.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    protected void removeQName(Connection conn, QName qn) throws SQLException {
        Statement stmt;
        block7: {
            stmt = null;
            try {
                long qnId = this.getQNameId(conn, qn, false);
                if (qnId == 0L) break block7;
                StringBuffer sql = new StringBuffer().append("DELETE FROM SLIDE_QNAME WHERE QNAME_ID = ").append(qnId);
                stmt = conn.createStatement();
                stmt.executeUpdate(sql.toString());
                qnIdLookup.remove(qn);
                qnLookup.remove(new Long(qnId));
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
        }
        Object var5_6 = null;
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void removeRevisionContent(Connection conn, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        Statement stmt = null;
        try {
            try {
                stmt = conn.createStatement();
                long versionId = this.getRevisionId(conn, this.getUriId(conn, uri.toString()), revisionDescriptor.getBranchName(), revisionDescriptor.getRevisionNumber());
                StringBuffer sql = new StringBuffer();
                sql.append("DELETE FROM SLIDE_REVISION_CONTENT ").append("WHERE REVISION_ID = ").append(versionId);
                stmt = conn.createStatement();
                stmt.executeUpdate(sql.toString());
            }
            catch (Exception e) {
                throw new ServiceAccessException(this.service, e.getMessage());
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeRevisionDescriptor(Connection conn, Uri uri, NodeRevisionNumber nrn) throws ServiceAccessException {
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                long uriId = this.getUriId(conn, uri.toString());
                String branchStr = null;
                branchStr = this.myRevisionDescriptor != null ? this.myRevisionDescriptor.getBranchName() : "main";
                long versionId = this.getRevisionId(conn, uriId, branchStr, nrn);
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_REVISION_LABEL WHERE REVISION_ID = ");
                sql.append(versionId);
                stmt.executeUpdate(sql.toString());
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_REVISION_PROPERTY ").append("WHERE REVISION_ID = ");
                sql.append(versionId);
                stmt.executeUpdate(sql.toString());
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_REVISION ").append("WHERE REVISION_ID = ").append(versionId);
                stmt.executeUpdate(sql.toString());
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_11 = null;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return;
            stmt.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeRevisionDescriptors(Connection conn, Uri uri) throws ServiceAccessException {
        Statement stmt = null;
        Statement stmt2 = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                ResultSet rs = null;
                stmt = conn.createStatement();
                long uriId = this.getUriId(conn, uri.toString());
                sql.setLength(0);
                sql.append("SELECT REVISION_ID FROM SLIDE_REVISION ").append("WHERE URI_ID = ").append(uriId);
                rs = stmt.executeQuery(sql.toString());
                stmt2 = conn.createStatement();
                if (rs.next()) {
                    long revisionId = rs.getLong("REVISION_ID");
                    sql.setLength(0);
                    sql.append("DELETE FROM SLIDE_REVISION_PREDECESSOR ").append("WHERE REVISION_ID = ").append(revisionId);
                    stmt2.executeUpdate(sql.toString());
                    sql.setLength(0);
                    sql.append("DELETE FROM SLIDE_REVISION_LATEST ").append("WHERE REVISION_ID = ").append(revisionId);
                    stmt2.executeUpdate(sql.toString());
                }
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_REVISION_HISTORY ").append("WHERE URI_ID = ").append(uriId);
                stmt.executeUpdate(sql.toString());
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_11 = null;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (stmt2 == null) throw throwable;
                stmt2.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (stmt2 == null) return;
            stmt2.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    protected void removeUri(Connection conn, String uri) throws SQLException {
        Statement stmt;
        block7: {
            stmt = null;
            try {
                long uriId = this.getUriId(conn, uri);
                if (uriId == 0L) break block7;
                StringBuffer sql = new StringBuffer().append("DELETE FROM SLIDE_URI WHERE URI_ID = ").append(uriId);
                stmt = conn.createStatement();
                stmt.executeUpdate(sql.toString());
                uriIdLookup.remove(uri);
                uriLookup.remove(new Long(uriId));
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
        }
        Object var5_6 = null;
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void renewLock(Connection conn, Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        try {
            if (!this.isLockExist(conn, this.getUriId(conn, lock.getLockId()))) {
                this.putLock(conn, uri, lock);
            }
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectNode retrieveObject(Connection conn, Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        Object var3_3 = null;
        Statement stmt = null;
        try {
            block15: {
                try {
                    StringBuffer sql = new StringBuffer();
                    stmt = conn.createStatement();
                    long uriId = this.getUriId(conn, uri.toString());
                    if (uriId == 0L) {
                        throw new ObjectNotFoundException(uri);
                    }
                    sql.setLength(0);
                    sql.append("SELECT CLASS_NAME FROM SLIDE_OBJECT WHERE URI_ID = ").append(uriId);
                    ResultSet rs = stmt.executeQuery(sql.toString());
                    if (!rs.next()) {
                        throw new ObjectNotFoundException(uri);
                    }
                    String className = rs.getString("CLASS_NAME");
                    Vector<String> children = new Vector<String>();
                    sql.setLength(0);
                    sql.append("SELECT A.URI_STRING FROM SLIDE_URI A, SLIDE_CHILD B ").append("WHERE A.URI_ID = B.CHILD_URI_ID ").append("AND B.URI_ID = ").append(uriId);
                    rs = stmt.executeQuery(sql.toString());
                    while (rs.next()) {
                        children.addElement(rs.getString("URI_STRING"));
                    }
                    Vector<String> links = new Vector<String>();
                    sql.setLength(0);
                    sql.append("SELECT A.URI_STRING FROM SLIDE_URI A, SLIDE_LINK B ").append("WHERE A.URI_ID = B.URI_ID ").append("AND B.TARGET_URI_ID = ").append(uriId);
                    rs = stmt.executeQuery(sql.toString());
                    while (rs.next()) {
                        links.addElement(rs.getString("URI_STRING"));
                    }
                    if (className.equals("org.apache.slide.structure.LinkNode")) {
                        String linkTarget = null;
                        sql.setLength(0);
                        sql.append("SELECT A.URI_STRING ").append("FROM SLIDE_URI A, SLIDE_LINK B ").append("WHERE A.URI_ID = B.TARGET_URI_ID ").append("AND B.URI_ID = ").append(uriId);
                        rs = stmt.executeQuery(sql.toString());
                        if (rs.next()) {
                            linkTarget = rs.getString("URI_STRING");
                        }
                        LinkNode linkNode = new LinkNode(uri.toString(), children, links, linkTarget);
                        break block15;
                    }
                    try {
                        Class<?> objClass = Class.forName(className);
                        Class[] argClasses = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = StandardRDBMSAdapter.class$("java.lang.String")), class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = StandardRDBMSAdapter.class$("java.util.Vector")), class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = StandardRDBMSAdapter.class$("java.util.Vector"))};
                        Object[] arguments = new Object[]{uri.toString(), children, links};
                        Constructor<?> constructor = objClass.getConstructor(argClasses);
                        ObjectNode objectNode = (ObjectNode)constructor.newInstance(arguments);
                    }
                    catch (Exception e) {
                        throw new ServiceAccessException(this.service, (Throwable)e);
                    }
                }
                catch (SQLException e) {
                    throw new ServiceAccessException(this.service, (Throwable)e);
                }
            }
            Object var6_22 = null;
        }
        catch (Throwable throwable) {
            Object var6_23 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            void var3_6;
            if (stmt == null) return var3_6;
            stmt.close();
            return var3_6;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NodeRevisionContent retrieveRevisionContent(Connection conn, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        NodeRevisionContent result = null;
        NodeRevisionNumber nrn = revisionDescriptor.getRevisionNumber();
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                long versionId = this.getRevisionId(conn, this.getUriId(conn, uri.toString()), revisionDescriptor.getBranchName(), nrn);
                sql.setLength(0);
                sql.append("SELECT CONTENT FROM SLIDE_REVISION_CONTENT ").append("WHERE REVISION_ID = ").append(versionId);
                ResultSet rs = stmt.executeQuery(sql.toString());
                if (!rs.next()) {
                    throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
                }
                InputStream in = rs.getBinaryStream("CONTENT");
                if (in == null) {
                    throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
                }
                result = new NodeRevisionContent();
                StoreContentZip zip = new StoreContentZip();
                zip.UnZip(in);
                revisionDescriptor.setContentLength(zip.getContentLength());
                in = zip.getInputStream();
                result.setContent(in);
                result.setContent(new JDBCAwareInputStream(in, stmt));
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, e.getMessage());
            }
            catch (RevisionNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServiceAccessException(this.service, e.getMessage());
            }
            Object var8_16 = null;
        }
        catch (Throwable throwable) {
            Object var8_17 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return result;
            stmt.close();
            return result;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NodeRevisionDescriptor retrieveRevisionDescriptor(Connection conn, Uri uri, NodeRevisionNumber nrn) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (nrn == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        NodeRevisionDescriptor result = null;
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                ResultSet rs = null;
                stmt = conn.createStatement();
                long uriId = this.getUriId(conn, uri.toString());
                String branchName = null;
                long versionId = 0L;
                sql.setLength(0);
                sql.append("SELECT A.REVISION_ID, B.BRANCH_NAME ").append("FROM SLIDE_REVISION A, SLIDE_BRANCH B ").append("WHERE A.URI_ID = ").append(uriId).append(" AND A.REVISION_NUMBER = '").append(nrn.toString());
                sql.append("' AND B.BRANCH_ID = A.BRANCH_ID");
                rs = stmt.executeQuery(sql.toString());
                if (!rs.next()) {
                    throw new RevisionDescriptorNotFoundException(uri.toString());
                }
                branchName = rs.getString("BRANCH_NAME");
                versionId = rs.getLong("REVISION_ID");
                Vector<String> labels = new Vector<String>();
                sql.setLength(0);
                sql.append("SELECT LABEL_ID FROM SLIDE_REVISION_LABEL ").append("WHERE REVISION_ID = ").append(versionId);
                rs = stmt.executeQuery(sql.toString());
                while (rs.next()) {
                    labels.addElement(this.getLabelName(conn, rs.getLong("LABEL_ID")));
                }
                Hashtable<String, NodeProperty> properties = new Hashtable<String, NodeProperty>();
                sql.setLength(0);
                sql.append("SELECT * FROM SLIDE_REVISION_PROPERTY ").append("WHERE REVISION_ID = ").append(versionId);
                rs = stmt.executeQuery(sql.toString());
                while (rs.next()) {
                    QName qn = this.getQName(conn, rs.getLong("QNAME_ID"));
                    NodeProperty property = new NodeProperty(qn.getLocalName(), rs.getString("PROPERTY_VALUE"), qn.getNamespaceURI(), null, rs.getBoolean("PROTECTED"));
                    properties.put(String.valueOf(qn.getNamespaceURI()) + qn.getLocalName(), property);
                }
                result = new NodeRevisionDescriptor(nrn, branchName, labels, properties);
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var7_17 = null;
        }
        catch (Throwable throwable) {
            Object var7_18 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return result;
            stmt.close();
            return result;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NodeRevisionDescriptors retrieveRevisionDescriptors(Connection conn, Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptors result = null;
        Statement stmt = null;
        Statement stmt2 = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                ResultSet rs = null;
                stmt = conn.createStatement();
                stmt2 = conn.createStatement();
                long uriId = this.getUriId(conn, uri.toString());
                boolean isVersioned = false;
                sql.setLength(0);
                sql.append("SELECT VERSIONED FROM SLIDE_REVISION_HISTORY ").append("WHERE URI_ID = ").append(uriId);
                rs = stmt.executeQuery(sql.toString());
                if (!rs.next()) {
                    throw new RevisionDescriptorNotFoundException(uri.toString());
                }
                isVersioned = rs.getBoolean("VERSIONED");
                Hashtable<String, NodeRevisionNumber> latestRevisionNumbers = new Hashtable<String, NodeRevisionNumber>();
                sql.setLength(0);
                sql.append("SELECT BRANCH_ID, REVISION_ID ").append("FROM SLIDE_REVISION_LATEST ").append("WHERE URI_ID = ").append(uriId);
                rs = stmt.executeQuery(sql.toString());
                while (rs.next()) {
                    String branch = this.getBranchName(conn, rs.getLong("BRANCH_ID"));
                    NodeRevisionNumber nrn = new NodeRevisionNumber(this.getRevisionNumber(conn, rs.getLong("REVISION_ID")));
                    latestRevisionNumbers.put(branch, nrn);
                }
                Hashtable branches = new Hashtable();
                sql.setLength(0);
                sql.append("SELECT A.REVISION_ID, A.REVISION_NUMBER, ").append("B.BRANCH_NAME FROM SLIDE_REVISION A, SLIDE_BRANCH B ").append("WHERE A.URI_ID = ").append(uriId).append(" AND A.BRANCH_ID = B.BRANCH_ID");
                rs = stmt.executeQuery(sql.toString());
                while (rs.next()) {
                    String branch = rs.getString("BRANCH_NAME");
                    long versionId = rs.getLong("REVISION_ID");
                    NodeRevisionNumber nrn = new NodeRevisionNumber(rs.getString("REVISION_NUMBER"));
                    sql.setLength(0);
                    sql.append("SELECT PREDECESSOR_ID ").append("FROM SLIDE_REVISION_PREDECESSOR ").append("WHERE REVISION_ID = ").append(versionId);
                    ResultSet rs2 = stmt2.executeQuery(sql.toString());
                    Vector<NodeRevisionNumber> predecessors = new Vector<NodeRevisionNumber>();
                    while (rs2.next()) {
                        predecessors.addElement(new NodeRevisionNumber(this.getRevisionNumber(conn, rs2.getLong("PREDECESSOR_ID"))));
                    }
                    branches.put(nrn, predecessors);
                    rs2.close();
                }
                Hashtable workingRevisions = new Hashtable();
                result = new NodeRevisionDescriptors(uri.toString(), new NodeRevisionNumber(), workingRevisions, latestRevisionNumbers, branches, isVersioned);
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var7_19 = null;
        }
        catch (Throwable throwable) {
            Object var7_20 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (stmt2 == null) throw throwable;
                stmt2.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (stmt2 == null) return result;
            stmt2.close();
            return result;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void revokePermission(Connection conn, Uri uri, NodePermission permission) throws ServiceAccessException {
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                NodeRevisionNumber nrn = permission.getRevisionNumber();
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_PERMISSION ").append("WHERE OBJECT_ID = ").append(this.getUriId(conn, permission.getObjectUri())).append(" AND SUBJECT_ID = ").append(this.getUriId(conn, permission.getSubjectUri())).append(" AND ACTION_ID = ").append(this.getUriId(conn, permission.getActionUri())).append(" AND REVISION_NUMBER ").append(nrn != null ? "= '" + nrn + "'" : "IS NULL");
                stmt.executeUpdate(sql.toString());
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return;
            stmt.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void revokePermissions(Connection conn, Uri uri) throws ServiceAccessException {
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                sql.setLength(0);
                sql.append("DELETE FROM SLIDE_PERMISSION WHERE OBJECT_ID = ").append(this.getUriId(conn, uri.toString()));
                stmt.executeUpdate(sql.toString());
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return;
            stmt.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    protected void setBranchId(Connection conn, String branchName) throws SQLException {
        Statement stmt;
        block7: {
            stmt = null;
            try {
                if (this.getBranchId(conn, branchName) != 0L) break block7;
                StringBuffer sql = new StringBuffer();
                sql.append("INSERT INTO SLIDE_BRANCH (BRANCH_NAME) ").append("VALUES ('").append(branchName).append("')");
                stmt = conn.createStatement();
                stmt.execute(sql.toString());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
        }
        Object var5_5 = null;
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void setLabelId(Connection conn, String labelName) throws SQLException {
        Statement stmt;
        block7: {
            stmt = null;
            try {
                if (this.getBranchId(conn, labelName) != 0L) break block7;
                StringBuffer sql = new StringBuffer();
                sql.append("INSERT INTO SLIDE_LABEL (LABEL_NAME) ").append("VALUES ('").append(labelName).append("')");
                stmt = conn.createStatement();
                stmt.executeUpdate(sql.toString());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
        }
        Object var5_5 = null;
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void setRevisionId(Connection conn, long uriId, long branchId, String sXNumber) throws SQLException {
        Statement stmt = null;
        try {
            StringBuffer sql = new StringBuffer();
            stmt = conn.createStatement();
            sql.setLength(0);
            sql.append("SELECT 1 FROM SLIDE_REVISION_HISTORY WHERE URI_ID = ").append(uriId);
            ResultSet rs = stmt.executeQuery(sql.toString());
            if (!rs.next()) {
                sql.setLength(0);
                sql.append("INSERT INTO SLIDE_REVISION_HISTORY ").append("(URI_ID, VERSIONED) ").append("VALUES (").append(uriId).append(", ").append(0).append(")");
                stmt.execute(sql.toString());
            }
            sql.setLength(0);
            sql.append("INSERT INTO SLIDE_REVISION ").append("(URI_ID, BRANCH_ID, REVISION_NUMBER) ").append("VALUES (").append(uriId).append(", ").append(branchId).append(", '").append(sXNumber).append("')");
            stmt.execute(sql.toString());
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            throw throwable;
        }
        Object var9_8 = null;
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void storeContent(Connection conn, String revisionUri, String revisionNumber, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IOException, SQLException {
        Statement pstmt;
        block11: {
            pstmt = null;
            try {
                StringBuffer sql = new StringBuffer();
                long versionId = this.getRevisionId(conn, this.getUriId(conn, revisionUri), revisionDescriptor.getBranchName(), revisionDescriptor.getRevisionNumber());
                if (versionId == 0L) {
                    this.setRevisionId(conn, this.getUriId(conn, revisionUri), this.getBranchId(conn, revisionDescriptor.getBranchName()), revisionNumber);
                    versionId = this.getRevisionId(conn, this.getUriId(conn, revisionUri), revisionDescriptor.getBranchName(), revisionDescriptor.getRevisionNumber());
                }
                sql.append("INSERT INTO SLIDE_REVISION_CONTENT VALUES (?, ?)");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setLong(1, versionId);
                InputStream in = revisionContent.streamContent();
                if (in == null) break block11;
                long contentLength = 0L;
                StoreContentZip zip = new StoreContentZip();
                zip.Zip(in);
                in = zip.getInputStream();
                contentLength = zip.getContentLength();
                Object os = null;
                byte[] buffer = new byte[2048];
                long position = 0L;
                File tempFile = null;
                String tempFileName = null;
                if (contentLength == -1L) {
                    int nChar;
                    tempFileName = String.valueOf(revisionUri) + "-" + revisionNumber;
                    int tempFileNameLength = (tempFileName = tempFileName.replace('/', '.')).length();
                    if (tempFileNameLength > 200) {
                        tempFileName = tempFileName.substring(tempFileNameLength - 200, tempFileNameLength);
                    }
                    tempFile = File.createTempFile(tempFileName, null);
                    FileOutputStream fos = new FileOutputStream(tempFile);
                    while ((nChar = in.read(buffer)) != -1) {
                        fos.write(buffer, 0, nChar);
                        position += (long)nChar;
                    }
                    fos.close();
                    in = new FileInputStream(tempFile);
                    contentLength = tempFile.length();
                }
                pstmt.setBinaryStream(2, in, (int)contentLength - 1);
                pstmt.executeUpdate();
                revisionDescriptor.setContentLength(contentLength);
                if (tempFile == null) break block11;
                in.close();
                tempFile.delete();
            }
            catch (Throwable throwable) {
                Object var8_21 = null;
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
        }
        Object var8_20 = null;
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeObject(Connection conn, Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        Statement stmt = null;
        try {
            try {
                long linkTargetId;
                StringBuffer sql = new StringBuffer();
                stmt = conn.createStatement();
                long uriId = this.getUriId(conn, uri.toString());
                sql.setLength(0);
                sql.append("SELECT CLASS_NAME FROM SLIDE_OBJECT WHERE URI_ID = ");
                sql.append(uriId);
                ResultSet rs = stmt.executeQuery(sql.toString());
                if (!rs.next()) {
                    throw new ObjectNotFoundException(uri);
                }
                long parent = this.getUriId(conn, object.getUri());
                Enumeration children = this.getNewChildren(conn, parent, object.enumerateChildren());
                if (children != null) {
                    while (children.hasMoreElements()) {
                        sql.setLength(0);
                        sql.append("INSERT INTO SLIDE_CHILD (URI_ID,CHILD_URI_ID) ").append("VALUES (").append(parent).append(", ").append(this.getUriId(conn, (String)children.nextElement())).append(")");
                        stmt.executeUpdate(sql.toString());
                    }
                }
                if (object instanceof LinkNode && !this.isLinkExist(conn, parent, linkTargetId = this.getUriId(conn, ((LinkNode)object).getLinkedUri()))) {
                    sql.setLength(0);
                    sql.append("INSERT INTO SLIDE_LINK ").append("(URI_ID, TARGET_URI_ID) ").append("VALUES (").append(parent).append(", ").append(linkTargetId).append(")");
                    stmt.executeUpdate(sql.toString());
                }
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_13 = null;
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        try {
            if (stmt == null) return;
            stmt.close();
            return;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    public void storeRevisionContent(Connection conn, Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        String revisionUri = uri.toString();
        NodeRevisionNumber nrn = revisionDescriptor.getRevisionNumber();
        Statement stmt = null;
        try {
            try {
                StringBuffer sql = new StringBuffer();
                long versionId = this.getRevisionId(conn, this.getUriId(conn, revisionUri), revisionDescriptor.getBranchName(), nrn);
                stmt = conn.createStatement();
                sql.setLength(0);
                sql.append("SELECT 1 FROM SLIDE_REVISION_CONTENT ").append("WHERE REVISION_ID = ").append(versionId);
                ResultSet rs = stmt.executeQuery(sql.toString());
                if (!rs.next()) {
                    throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
                }
                this.removeRevisionContent(conn, uri, revisionDescriptor);
                this.storeContent(conn, revisionUri, nrn.toString(), revisionDescriptor, revisionContent);
            }
            catch (SQLException e) {
                throw new ServiceAccessException(this.service, e.getMessage());
            }
            catch (IOException e) {
                throw new ServiceAccessException(this.service, e.getMessage());
            }
            catch (RevisionNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServiceAccessException(this.service, e.getMessage());
            }
            Object var9_15 = null;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {}
    }

    public void storeRevisionDescriptor(Connection conn, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.myRevisionDescriptor = revisionDescriptor;
        this.removeRevisionDescriptor(conn, uri, revisionDescriptor.getRevisionNumber());
        this.createRevisionDescriptor(conn, uri, revisionDescriptor);
    }

    public void storeRevisionDescriptors(Connection conn, Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.removeRevisionDescriptors(conn, uri);
        this.createRevisionDescriptors(conn, uri, revisionDescriptors);
    }
}

