/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.slide.common.AbstractSimpleService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.impl.rdbms.RDBMSAdapter;
import org.apache.slide.store.impl.rdbms.StandardRDBMSAdapter;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;

public class JDBCStore
extends AbstractSimpleService
implements LockStore,
NodeStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore,
ContentStore {
    private Connection connection;
    private String driver;
    private String url;
    private String user = "";
    private String password = "";
    private boolean alreadyEnlisted = false;
    private RDBMSAdapter adapter;
    static /* synthetic */ Class class$org$apache$slide$common$Service;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        super.commit(xid, onePhase);
        try {
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            throw new XAException(101);
        }
        this.alreadyEnlisted = false;
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
        this.getLogger().log("Connecting to '" + this.url + "' as user '" + this.user + "'", this.LOG_CHANNEL, 6);
        try {
            this.connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException e) {
            this.getLogger().log("Connecting to '" + this.url + "' as user '" + this.user + "' failed (" + e.getMessage() + ")", this.LOG_CHANNEL, 2);
            throw new ServiceConnectionFailedException((Service)this, e);
        }
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {}
        this.alreadyEnlisted = false;
    }

    private synchronized void connectIfNeededAndPossible() {
        try {
            this.connectIfNeeded();
        }
        catch (Throwable throwable) {}
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        this.adapter.createObject(this.connection, uri, object);
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        this.adapter.createRevisionContent(this.connection, uri, revisionDescriptor, revisionContent);
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        this.adapter.createRevisionDescriptor(this.connection, uri, revisionDescriptor);
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        this.adapter.createRevisionDescriptors(this.connection, uri, revisionDescriptors);
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        this.getLogger().log("Disconnecting from '" + this.url + "' as user '" + this.user + "'", this.LOG_CHANNEL, 6);
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException e) {
            this.getLogger().log("Disconnecting from '" + this.url + "' as user '" + this.user + "' failed (" + e.getMessage() + ")", this.LOG_CHANNEL, 2);
            throw new ServiceDisconnectionFailedException((Service)this, e);
        }
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        return this.adapter.enumerateLocks(this.connection, uri);
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        return this.adapter.enumeratePermissions(this.connection, uri);
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        this.adapter.grantPermission(this.connection, uri, permission);
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        try {
            token.getLogger().log("Loading and registering driver '" + this.driver + "'", this.LOG_CHANNEL, 6);
            Class<?> driverClass = Class.forName(this.driver);
            Driver driverInstance = (Driver)driverClass.newInstance();
            DriverManager.registerDriver(driverInstance);
        }
        catch (Exception e) {
            token.getLogger().log("Loading and registering driver '" + this.driver + "' failed (" + e.getMessage() + ")", this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e);
        }
    }

    public boolean isConnected() throws ServiceAccessException {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                return false;
            }
            Statement stmt = this.connection.createStatement();
            stmt.executeQuery("SELECT * FROM SLIDE_URI WHERE URI_ID IS NULL");
            return true;
        }
        catch (SQLException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.adapter.killLock(this.connection, uri, lock);
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        this.adapter.putLock(this.connection, uri, lock);
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.adapter.removeLock(this.connection, uri, lock);
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        this.adapter.removeObject(this.connection, uri, object);
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        this.adapter.removeRevisionContent(this.connection, uri, revisionDescriptor);
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber nrn) throws ServiceAccessException {
        this.adapter.removeRevisionDescriptor(this.connection, uri, nrn);
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        this.adapter.removeRevisionDescriptors(this.connection, uri);
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.adapter.renewLock(this.connection, uri, lock);
    }

    public synchronized void reset() throws ServiceResetFailedException {
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        return this.adapter.retrieveObject(this.connection, uri);
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        return this.adapter.retrieveRevisionContent(this.connection, uri, revisionDescriptor);
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber nrn) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        return this.adapter.retrieveRevisionDescriptor(this.connection, uri, nrn);
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        return this.adapter.retrieveRevisionDescriptors(this.connection, uri);
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        this.adapter.revokePermission(this.connection, uri, permission);
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        this.adapter.revokePermissions(this.connection, uri);
    }

    public void rollback(Xid xid) throws XAException {
        super.rollback(xid);
        try {
            this.connection.rollback();
        }
        catch (SQLException sQLException) {
            throw new XAException(7);
        }
        this.alreadyEnlisted = false;
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        String value = (String)parameters.get("driver");
        if (value == null) {
            throw new ServiceParameterMissingException(this, "driver");
        }
        this.driver = value;
        value = (String)parameters.get("url");
        if (value == null) {
            throw new ServiceParameterMissingException(this, "url");
        }
        this.url = value;
        value = (String)parameters.get("user");
        if (value != null) {
            this.user = value;
        }
        if ((value = (String)parameters.get("password")) != null) {
            this.password = value;
        }
        if ((value = (String)parameters.get("adapter")) == null) {
            this.adapter = new StandardRDBMSAdapter(this);
        } else {
            try {
                Class<?> adapterClass = Class.forName(value);
                Constructor<?> ctor = adapterClass.getConstructor(class$org$apache$slide$common$Service != null ? class$org$apache$slide$common$Service : (class$org$apache$slide$common$Service = JDBCStore.class$("org.apache.slide.common.Service")));
                this.adapter = (RDBMSAdapter)ctor.newInstance(this);
            }
            catch (Exception e) {
                this.getLogger().log("Error instantiating Adapter '" + value + "' (" + e.getMessage() + ")", this.LOG_CHANNEL, 2);
            }
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        super.start(xid, flags);
        if (!this.alreadyEnlisted) {
            try {
                this.connectIfNeeded();
                this.connection.rollback();
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
            this.alreadyEnlisted = true;
        }
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        this.adapter.storeObject(this.connection, uri, object);
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        this.adapter.storeRevisionContent(this.connection, uri, revisionDescriptor, revisionContent);
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.adapter.storeRevisionDescriptor(this.connection, uri, revisionDescriptor);
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.adapter.storeRevisionDescriptors(this.connection, uri, revisionDescriptors);
    }
}

