/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.slide.common.AbstractXAService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.impl.rdbms.RDBMSAdapter;
import org.apache.slide.store.impl.rdbms.StandardRDBMSAdapter;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;

public class J2EEStore
extends AbstractXAService
implements LockStore,
NodeStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore,
ContentStore {
    private static final int TX_IDLE = 0;
    private static final int TX_PREPARED = 1;
    private static final int TX_SUSPENDED = 1;
    private static final int CACHE_SIZE = 200;
    protected DataSource ds;
    protected String datasource;
    private Hashtable connectionMap = new Hashtable();
    private static Connection globalConnection;
    private RDBMSAdapter adapter;
    static /* synthetic */ Class class$org$apache$slide$common$Service;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.getLogger().log("commit() for thread " + Thread.currentThread() + ", removing from map", this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.remove(Thread.currentThread());
        if (id == null) {
            this.getLogger().log("Error committing: no transaction associated with current thread", this.LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (!onePhase && id.status != 1) {
            throw new XAException(-6);
        }
        if (onePhase && id.status != 0 && id.status != 1) {
            throw new XAException(-6);
        }
        Connection conn = id.connection;
        if (conn == null) {
            this.getLogger().log("commit(): No connection in connectionMap for id \"" + id + "\"", this.LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
        }
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
        this.getLogger().log("Trying connect to data source", this.LOG_CHANNEL, 7);
        try {
            globalConnection = this.ds.getConnection();
        }
        catch (SQLException sQLException) {
            throw new ServiceConnectionFailedException((Service)this, "Couldn't get global connection");
        }
        this.getLogger().log("Done connecting to database. The global connection is " + globalConnection, this.LOG_CHANNEL, 7);
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        this.adapter.createObject(this.getCurrentConnection(), uri, object);
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        this.adapter.createRevisionContent(this.getCurrentConnection(), uri, revisionDescriptor, revisionContent);
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        this.adapter.createRevisionDescriptor(this.getCurrentConnection(), uri, revisionDescriptor);
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        this.adapter.createRevisionDescriptors(this.getCurrentConnection(), uri, revisionDescriptors);
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        try {
            globalConnection.close();
        }
        catch (SQLException e) {
            this.getLogger().log("Failed to close special global connection: " + e.getMessage(), this.LOG_CHANNEL, 2);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        this.getLogger().log("end() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null || id.xid == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (flags == 0x2000000) {
            id.status = 1;
        }
        if (flags == 0x20000000) {
            id.rollbackOnly = true;
        }
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        return this.adapter.enumerateLocks(this.getCurrentConnection(), uri);
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        return this.adapter.enumeratePermissions(this.getCurrentConnection(), uri);
    }

    public void forget(Xid xid) throws XAException {
        this.getLogger().log("forget() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null || id.xid == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            id.connection.close();
        }
        catch (SQLException sQLException) {
            this.getLogger().log("Couldn't close connection.", this.LOG_CHANNEL, 2);
        }
        this.getLogger().log("forget(): removing from map: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        this.connectionMap.remove(Thread.currentThread());
    }

    protected Connection getCurrentConnection() {
        this.getLogger().log("Getting current connection for thread " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null) {
            this.getLogger().log("No id for current thread - called outside transaction?", this.LOG_CHANNEL, 7);
            return globalConnection;
        }
        Connection conn = id.connection;
        if (conn == null) {
            this.getLogger().log("No connection for current id - shouldn't be possible", this.LOG_CHANNEL, 2);
            return globalConnection;
        }
        this.getLogger().log("Returning current valid connection from map", this.LOG_CHANNEL, 7);
        return conn;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        this.adapter.grantPermission(this.getCurrentConnection(), uri, permission);
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        try {
            token.getLogger().log("Retrieving datasource '" + this.datasource + "'", this.LOG_CHANNEL, 6);
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            this.ds = (DataSource)envCtx.lookup(this.datasource);
        }
        catch (Exception e) {
            token.getLogger().log("Retrieving data source instance '" + this.datasource + "' failed: " + e.getMessage(), this.LOG_CHANNEL, 2);
            token.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        if (this.ds == null) {
            throw new ServiceInitializationFailedException((Service)this, "Data source not found");
        }
    }

    public boolean isConnected() {
        try {
            return this.ds != null && globalConnection != null && !globalConnection.isClosed();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares == null) {
            return false;
        }
        return this == xares;
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.adapter.killLock(this.getCurrentConnection(), uri, lock);
    }

    public int prepare(Xid xid) throws XAException {
        this.getLogger().log("prepare() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (id.status != 0 && id.status != 1) {
            throw new XAException(-6);
        }
        if (id.rollbackOnly) {
            throw new XAException(100);
        }
        id.status = 1;
        return 0;
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        this.adapter.putLock(this.getCurrentConnection(), uri, lock);
    }

    public Xid[] recover(int flag) throws XAException {
        this.getLogger().log("recover() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id != null && id.status == 1) {
            Xid[] xids = new Xid[]{id.xid};
            return xids;
        }
        return new Xid[0];
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.adapter.removeLock(this.getCurrentConnection(), uri, lock);
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        this.adapter.removeObject(this.getCurrentConnection(), uri, object);
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        this.adapter.removeRevisionContent(this.getCurrentConnection(), uri, revisionDescriptor);
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException {
        this.adapter.removeRevisionDescriptor(this.getCurrentConnection(), uri, revisionNumber);
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        this.adapter.removeRevisionDescriptors(this.getCurrentConnection(), uri);
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.adapter.renewLock(this.getCurrentConnection(), uri, lock);
    }

    public synchronized void reset() throws ServiceResetFailedException {
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        return this.adapter.retrieveObject(this.getCurrentConnection(), uri);
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        return this.adapter.retrieveRevisionContent(this.getCurrentConnection(), uri, revisionDescriptor);
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        return this.adapter.retrieveRevisionDescriptor(this.getCurrentConnection(), uri, revisionNumber);
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        return this.adapter.retrieveRevisionDescriptors(this.getCurrentConnection(), uri);
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        this.adapter.revokePermission(this.getCurrentConnection(), uri, permission);
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        this.adapter.revokePermissions(this.getCurrentConnection(), uri);
    }

    public void rollback(Xid xid) throws XAException {
        this.getLogger().log("rollback() for thread " + Thread.currentThread() + ", removing from map", this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.remove(Thread.currentThread());
        if (id == null) {
            this.getLogger().log("No transaction associated with current thread, can't rollback", this.LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        Connection conn = id.connection;
        if (conn == null) {
            this.getLogger().log("rollback(): No connection in connectionMap for id \"" + id + "\"", this.LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
        }
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        String value = (String)parameters.get("datasource");
        if (value == null) {
            throw new ServiceParameterMissingException(this, "datasource");
        }
        this.datasource = value;
        value = (String)parameters.get("adapter");
        if (value == null) {
            this.adapter = new StandardRDBMSAdapter(this);
        } else {
            try {
                Class<?> adapterClass = Class.forName(value);
                Constructor<?> ctor = adapterClass.getConstructor(class$org$apache$slide$common$Service != null ? class$org$apache$slide$common$Service : (class$org$apache$slide$common$Service = J2EEStore.class$("org.apache.slide.common.Service")));
                this.adapter = (RDBMSAdapter)ctor.newInstance(this);
            }
            catch (Exception e) {
                this.getLogger().log("Error instantiating Adapter '" + value + "' (" + e.getMessage() + ")", this.LOG_CHANNEL, 2);
            }
        }
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        this.getLogger().log("start(): beginning transaction with xid " + xid, this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        switch (flags) {
            case 0: {
                if (id != null) {
                    throw new XAException(-5);
                }
                id = new TransactionId(xid, 0);
                this.getLogger().log("start(): adding to map for " + Thread.currentThread(), this.LOG_CHANNEL, 7);
                this.connectionMap.put(Thread.currentThread(), id);
                break;
            }
            case 0x200000: {
                this.getLogger().log("TMJOIN for transaction in thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
                if (id != null) break;
                throw new XAException(-4);
            }
            case 0x8000000: {
                this.getLogger().log("TMRESUME for transaction in thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
                if (id == null) {
                    throw new XAException(-4);
                }
                if (id.status != 1) {
                    throw new XAException(-5);
                }
                id.status = 0;
                break;
            }
        }
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        this.adapter.storeObject(this.getCurrentConnection(), uri, object);
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        this.adapter.storeRevisionContent(this.getCurrentConnection(), uri, revisionDescriptor, revisionContent);
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.adapter.storeRevisionDescriptor(this.getCurrentConnection(), uri, revisionDescriptor);
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.adapter.storeRevisionDescriptors(this.getCurrentConnection(), uri, revisionDescriptors);
    }

    private class TransactionId {
        Xid xid;
        int status;
        boolean rollbackOnly;
        Connection connection;

        TransactionId(Xid xid, int status) {
            this.xid = xid;
            this.status = status;
            this.rollbackOnly = false;
            try {
                this.connection = J2EEStore.this.ds.getConnection();
                if (this.connection == null) {
                    this.connection = globalConnection;
                    return;
                }
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(false);
                }
            }
            catch (SQLException sQLException) {
                this.connection = globalConnection;
            }
        }
    }
}

