/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.security;

import java.util.Enumeration;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.security.NodePermission;
import org.apache.slide.security.Security;
import org.apache.slide.security.SecurityImpl;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.GroupNode;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;

public final class SecurityImplAllGrant
extends SecurityImpl
implements Security {
    public SecurityImplAllGrant(Namespace namespace, NamespaceConfig namespaceConfig) {
        super(namespace, namespaceConfig);
    }

    public boolean hasPermission(ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException {
        boolean granted = false;
        boolean denied = false;
        boolean rootObjectReached = false;
        ObjectNode courObject = object;
        Uri subjectUri = this.namespace.getUri(subject.getUri());
        Uri actionUri = this.namespace.getUri(action.getUri());
        while (!(granted || denied || rootObjectReached)) {
            Uri courUri = this.namespace.getUri(courObject.getUri());
            Enumeration permissions = courUri.getStore().enumeratePermissions(courUri);
            while (!granted && !denied && permissions.hasMoreElements()) {
                boolean oldGranted = granted;
                boolean oldDenied = denied;
                NodePermission permission = (NodePermission)permissions.nextElement();
                String permissionSubject = permission.getSubjectUri();
                if (permissionSubject.equals("~")) {
                    boolean check = object.getUri().equals(subjectUri.toString());
                    if (permission.isInheritable()) {
                        String subjectUriString = subjectUri.toString();
                        if (!subjectUriString.endsWith("/")) {
                            subjectUriString = String.valueOf(subjectUriString) + "/";
                        }
                        check |= object.getUri().startsWith(subjectUriString);
                    }
                    granted = !permission.isNegative() && check && actionUri.toString().startsWith(permission.getActionUri());
                    denied = permission.isNegative() && check && actionUri.toString().startsWith(permission.getActionUri());
                } else if (permission.isInheritable() || permission.getObjectUri().equals(object.getUri())) {
                    if (permissionSubject.startsWith("/")) {
                        String permSubj = permission.getSubjectUri();
                        if (!permSubj.endsWith("/")) {
                            permSubj = String.valueOf(permSubj) + "/";
                        }
                        boolean match = subjectUri.toString().equals(permission.getSubjectUri()) || subjectUri.toString().startsWith(permSubj);
                        granted = !permission.isNegative() && (match &= actionUri.toString().startsWith(permission.getActionUri()));
                        denied = permission.isNegative() && match;
                    } else if (permissionSubject.startsWith("+")) {
                        Uri permissionSubjectUri = this.namespace.getUri(permissionSubject.substring(1));
                        ObjectNode group = permissionSubjectUri.getStore().retrieveObject(permissionSubjectUri);
                        if (group instanceof GroupNode && group.hasChildren()) {
                            Enumeration groupMembers = group.enumerateChildren();
                            while (groupMembers.hasMoreElements()) {
                                oldGranted = granted;
                                oldDenied = denied;
                                Uri childUri = this.namespace.getUri((String)groupMembers.nextElement());
                                ObjectNode childNode = childUri.getStore().retrieveObject(childUri);
                                String childSubjectUri = childNode instanceof LinkNode ? ((LinkNode)childNode).getLinkedUri() : childNode.getUri();
                                String testUri = !childSubjectUri.endsWith("/") ? String.valueOf(childSubjectUri) + "/" : childSubjectUri;
                                boolean match = subjectUri.toString().equals(childSubjectUri) || subjectUri.toString().startsWith(testUri);
                                granted = !permission.isNegative() && (match &= actionUri.toString().startsWith(permission.getActionUri()));
                                denied = permission.isNegative() && match;
                                granted |= oldGranted;
                                denied |= oldDenied;
                            }
                        }
                    } else {
                        granted = !permission.isNegative() && this.hasRole(subject, permissionSubject) && actionUri.toString().startsWith(permission.getActionUri());
                        denied = permission.isNegative() && this.hasRole(subject, permissionSubject) && actionUri.toString().startsWith(permission.getActionUri());
                    }
                }
                granted |= oldGranted;
                denied |= oldDenied;
            }
            Uri parentUri = courUri.getParentUri();
            if (parentUri != null) {
                courObject = parentUri.getStore().retrieveObject(parentUri);
                continue;
            }
            rootObjectReached = true;
        }
        if (denied) {
            return false;
        }
        return granted;
    }
}

