/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.slide.common.PropertyName;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.search.InvalidQueryException;
import org.jdom.Element;

public class ComparedProperty {
    private static final List NUMERIC_PROPERTIES = new ArrayList();
    protected String literal;
    protected String property;
    protected String propNamespace;
    protected boolean casesensitive = true;

    static {
        NUMERIC_PROPERTIES.add(new PropertyName("getcontentlength", "DAV:"));
    }

    public ComparedProperty() {
    }

    public ComparedProperty(String property, String propNamespace) {
        this.setProperty(property);
        this.setPropNamespace(propNamespace);
    }

    public ComparedProperty(Element e) throws InvalidQueryException {
        this(e, true);
    }

    public ComparedProperty(Element e, boolean withLiteral) throws InvalidQueryException {
        this.setProperty(e);
        if (withLiteral) {
            this.literal = this.getLiteral(e);
        }
    }

    public boolean getCasesensitive() {
        return this.casesensitive;
    }

    public String getLiteral() {
        return this.literal;
    }

    private String getLiteral(Element e) throws InvalidQueryException {
        Element lit = e.getChild("literal", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        if (lit == null) {
            throw new InvalidQueryException("No literal element supplied");
        }
        return lit.getText();
    }

    public String getPropNamespace() {
        return this.propNamespace;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isNumeric() {
        return NUMERIC_PROPERTIES.contains(new PropertyName(this.property, this.propNamespace));
    }

    public void setLiteral(String literal) {
        this.literal = literal;
    }

    public void setPropNamespace(String p) {
        this.propNamespace = p;
    }

    public void setProperty(String p) {
        this.property = p;
    }

    private void setProperty(Element e) throws InvalidQueryException {
        Element propListElement;
        String casesensAttr = e.getAttributeValue("casesensitive", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        if (casesensAttr != null) {
            if (casesensAttr.equals("1")) {
                this.casesensitive = true;
            } else if (casesensAttr.equals("0")) {
                this.casesensitive = false;
            } else {
                throw new InvalidQueryException("casesensitive must be either \"0\" or \"1\"");
            }
        }
        if ((propListElement = e.getChild("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE)) == null) {
            throw new InvalidQueryException("No property element supplied");
        }
        List propList = propListElement.getChildren();
        if (propList.size() != 1) {
            throw new InvalidQueryException("Expected exactly 1 prop element, found " + propList.size());
        }
        Element propElement = (Element)propList.get(0);
        this.property = propElement.getName();
        this.propNamespace = propElement.getNamespace().getURI();
    }
}

