/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.util.List;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.InvalidScopeException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.QueryScope;
import org.apache.slide.search.SearchException;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.search.SearchToken;
import org.apache.slide.search.basic.BasicExpressionFactory;
import org.apache.slide.search.basic.BasicQuery;
import org.apache.slide.search.basic.BasicQueryScope;
import org.apache.slide.search.basic.IBasicExpressionCompiler;
import org.apache.slide.search.basic.IBasicExpressionCompilerProvider;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.search.basic.IBasicResultSet;
import org.apache.slide.search.basic.NotNormalizer;
import org.apache.slide.search.basic.OrderBy;
import org.apache.slide.store.AbstractStore;
import org.jdom.Element;
import org.jdom.Namespace;

public class BasicQueryImpl
extends BasicQuery
implements IBasicQuery {
    public static final String NO_QUERY_ELEMENT = "No query element";
    public static final String FROM_ELEMENT_MISSING = "Required element <from> not supplied";
    public static final String SELECT_ELEMENT_MISSING = "Required element <select> not supplied";
    public static final String PROP_OR_ALLPROP_ELEMENT_MISSING = "Required element <prop> or <allprop> not supplied";
    protected NotNormalizer notNormalizer;
    IBasicExpressionFactory expressionFactory = new BasicExpressionFactory();

    public BasicQueryImpl() {
        this.notNormalizer = new NotNormalizer();
    }

    public BasicQueryImpl(SearchToken searchToken) {
        super.init(searchToken);
        this.notNormalizer = new NotNormalizer();
    }

    public BasicQueryImpl(SearchToken searchToken, IBasicExpressionCompilerProvider expressionCompilerProvider) {
        this.init(searchToken);
        this.expressionCompilerProvider = expressionCompilerProvider;
    }

    protected RequestedProperties createRequestedProperties(Element propElement) throws BadQueryException {
        try {
            return new RequestedPropertiesImpl(propElement);
        }
        catch (PropertyParseException e) {
            throw new BadQueryException(e.getMessage(), e);
        }
    }

    public SearchQueryResult execute() throws ServiceAccessException {
        SearchQueryResult result = null;
        try {
            IBasicResultSet resultSet = this.getExpression().execute();
            result = this.orderBy != null ? new SearchQueryResult(resultSet, this.orderBy.getComparator()) : new SearchQueryResult(resultSet);
            if (resultSet.isPartialResultSet()) {
                result.setStatus(3);
                result.setDescription("The server truncated the result set");
            }
        }
        catch (InvalidScopeException invalidScopeException) {
            result = new SearchQueryResult();
            result.setStatus(2);
            result.setHref(this.queryScope.getHref());
        }
        catch (BadQueryException e) {
            result = new SearchQueryResult();
            result.setStatus(1);
            result.setDescription(e.getMessage());
            result.setHref(this.queryScope.getHref());
        }
        catch (SearchException e) {
            result = new SearchQueryResult();
            result.setStatus(1);
            result.setDescription(e.getMessage());
            result.setHref(this.queryScope.getHref());
        }
        return result;
    }

    public IBasicExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public static QueryScope getScope(Element basicSearchElementJDOM) throws BadQueryException {
        if (basicSearchElementJDOM == null) {
            throw new BadQueryException(NO_QUERY_ELEMENT);
        }
        Namespace namespace = basicSearchElementJDOM.getNamespace();
        Element fromElement = basicSearchElementJDOM.getChild("from", namespace);
        if (fromElement == null) {
            throw new BadQueryException(FROM_ELEMENT_MISSING);
        }
        return new BasicQueryScope(fromElement);
    }

    public void parseQuery(Element expressionElement, PropertyProvider propertyProvider) throws BadQueryException {
        this.parseQueryWithoutExpression(expressionElement);
        IBasicExpressionCompiler expressionCompiler = this.expressionCompilerProvider.getCompiler(this, propertyProvider);
        if (this.whereElement != null) {
            List expressionList = this.whereElement.getChildren();
            if (expressionList.size() != 1) {
                throw new BadQueryException("where must have exactly one nested element");
            }
            Element whereWithoutNot = this.notNormalizer.getQueryWithoutNotExpression((Element)expressionList.get(0));
            this.rootExpression = expressionCompiler.compile(whereWithoutNot);
        } else {
            this.rootExpression = expressionCompiler.compile(null);
        }
    }

    public void parseQueryElement(Element basicSearchElement, PropertyProvider propertyProvider) throws BadQueryException {
        this.parseQueryElement(basicSearchElement, propertyProvider, BasicQueryImpl.getScope(basicSearchElement));
    }

    public void parseQueryElement(Element basicSearchElement, PropertyProvider propertyProvider, QueryScope queryScope) throws BadQueryException {
        this.queryScope = queryScope;
        this.propertyProvider = propertyProvider;
        if (this.searchToken.getNamespace() != null) {
            Uri uri = this.searchToken.getNamespace().getUri(this.getSearchToken().getSlideToken(), this.slideUri.getSlidePath(queryScope.getHref()));
            this.store = (AbstractStore)uri.getStore();
        }
        this.parseQuery(basicSearchElement, propertyProvider);
    }

    protected void parseQueryWithoutExpression(Element basicSearchElement) throws BadQueryException {
        if (basicSearchElement == null) {
            throw new BadQueryException(NO_QUERY_ELEMENT);
        }
        this.namespace = basicSearchElement.getNamespace();
        Element selectElement = basicSearchElement.getChild("select", this.namespace);
        if (selectElement == null) {
            throw new BadQueryException(SELECT_ELEMENT_MISSING);
        }
        Element fromElement = basicSearchElement.getChild("from", this.namespace);
        if (fromElement == null) {
            throw new BadQueryException(FROM_ELEMENT_MISSING);
        }
        this.whereElement = basicSearchElement.getChild("where", this.namespace);
        Element orderByElement = basicSearchElement.getChild("orderby", this.namespace);
        Element limitElement = basicSearchElement.getChild("limit", this.namespace);
        Element propElement = selectElement.getChild("prop", this.namespace);
        if (propElement == null) {
            propElement = selectElement.getChild("allprop", this.namespace);
        }
        if (propElement == null) {
            throw new BadQueryException(PROP_OR_ALLPROP_ELEMENT_MISSING);
        }
        this.requestedProperties = this.createRequestedProperties(propElement);
        if (orderByElement != null) {
            this.orderBy = new OrderBy(orderByElement);
        }
        if (limitElement != null) {
            this.limit = new Integer(limitElement.getTextTrim());
            this.limitDefined = true;
        }
    }

    public RequestedProperties requestedProperties() {
        return this.requestedProperties;
    }
}

