/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.SlideRuntimeException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.basic.BasicExpressionFactory;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicExpressionCompiler;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.store.AbstractStore;
import org.jdom.Element;

public class BasicExpressionCompiler
implements IBasicExpressionCompiler {
    protected IBasicQuery query = null;
    protected PropertyProvider propertyProvider = null;
    protected IBasicExpressionFactory defaultExpressionFactory = null;
    protected IBasicExpressionFactory storeSpecificExpressionFactory = null;
    protected boolean alreadyTriedToInstantiate = false;

    public BasicExpressionCompiler(IBasicQuery query, PropertyProvider propertyProvider) throws BadQueryException {
        this(query, propertyProvider, null);
    }

    public BasicExpressionCompiler(IBasicQuery query, PropertyProvider propertyProvider, IBasicExpressionFactory defaultExpressionFactory) throws BadQueryException {
        this.query = query;
        this.propertyProvider = propertyProvider;
        this.defaultExpressionFactory = defaultExpressionFactory;
        this.storeSpecificExpressionFactory = query.getExpressionFactory();
        this.storeSpecificExpressionFactory.init(query, propertyProvider);
    }

    public IBasicExpression compile(Element expressionElement) throws BadQueryException {
        if (BasicExpressionCompiler.isMergeExpression(expressionElement)) {
            ArrayList<IBasicExpression> expressionsToMerge = new ArrayList<IBasicExpression>();
            Iterator iterator = expressionElement.getChildren().iterator();
            while (iterator.hasNext()) {
                expressionsToMerge.add(this.compile((Element)iterator.next()));
            }
            return this.createMergeExpression(expressionElement.getName(), expressionElement.getNamespaceURI(), expressionsToMerge);
        }
        return this.createExpression(expressionElement);
    }

    public IBasicExpression createExpression(Element expressionElement) throws BadQueryException {
        IBasicExpression expression = null;
        if (this.getStoreSpecificExpressionFactory() != null) {
            expression = this.getStoreSpecificExpressionFactory().createExpression(expressionElement);
        }
        if (expression == null) {
            expression = this.getDefaultExpressionFactory().createExpression(expressionElement);
        }
        return expression;
    }

    public IBasicExpression createMergeExpression(String name, String namespace, List expressionsToMerge) throws BadQueryException {
        IBasicExpression mergeExpression = null;
        if (this.getStoreSpecificExpressionFactory() != null) {
            mergeExpression = this.getStoreSpecificExpressionFactory().createMergeExpression(name, namespace, expressionsToMerge);
        }
        if (mergeExpression == null) {
            mergeExpression = this.getDefaultExpressionFactory().createMergeExpression(name, namespace, expressionsToMerge);
        }
        return mergeExpression;
    }

    public IBasicExpressionFactory getDefaultExpressionFactory() throws BadQueryException {
        if (this.defaultExpressionFactory == null) {
            this.defaultExpressionFactory = new BasicExpressionFactory();
            this.defaultExpressionFactory.init(this.query, this.propertyProvider);
        }
        return this.defaultExpressionFactory;
    }

    public IBasicExpressionFactory getStoreSpecificExpressionFactory() throws BadQueryException {
        AbstractStore store;
        String className;
        if (!this.alreadyTriedToInstantiate && this.storeSpecificExpressionFactory == null && (className = (String)(store = this.query.getStore()).getParameter("basicExpressionFactoryClass")) != null) {
            try {
                Class<?> factoryClass = Class.forName(className);
                this.storeSpecificExpressionFactory = (IBasicExpressionFactory)factoryClass.newInstance();
                this.storeSpecificExpressionFactory.init(this.query, this.propertyProvider);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SlideRuntimeException(e.getMessage());
            }
        }
        return this.storeSpecificExpressionFactory;
    }

    public static boolean isMergeExpression(Element expressionElement) {
        boolean isMerge = false;
        if (expressionElement != null && "DAV:".equals(expressionElement.getNamespaceURI())) {
            isMerge = "and".equals(expressionElement.getName()) || "or".equals(expressionElement.getName());
        }
        return isMerge;
    }
}

