/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class SearchQueryResult {
    public static final int STATUS_OK = 0;
    public static final int STATUS_BAD_QUERY = 1;
    public static final int STATUS_INVALID_SCOPE = 2;
    public static final int STATUS_PARTIAL_RESULT = 3;
    public static final int STATUS_UNPROCESSABLE_ENTITY = 4;
    public static final int STATUS_BAD_GATEWAY = 5;
    public static final int STATUS_FORBIDDEN = 6;
    private int status;
    private String description;
    private String href;
    private Set result;

    public SearchQueryResult() {
        this(null, null);
    }

    public SearchQueryResult(Comparator comparator) {
        this(null, comparator);
    }

    public SearchQueryResult(Set result) {
        this(result, null);
    }

    public SearchQueryResult(Set result, Comparator comparator) {
        if (comparator == null) {
            this.result = result == null ? new HashSet() : result;
        } else {
            this.result = new TreeSet(comparator);
            if (result != null) {
                this.result.addAll(result);
            }
        }
        this.status = 0;
        this.description = "";
    }

    public void add(SearchQueryResult subResultSet) {
        this.result.addAll(subResultSet.getResultSet());
    }

    public String getDescription() {
        return this.description;
    }

    public String getHref() {
        return this.href;
    }

    Set getResultSet() {
        return this.result;
    }

    public int getStatus() {
        return this.status;
    }

    public Iterator iterator() {
        return this.result.iterator();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

