/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.lock;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Messages;
import org.apache.util.MD5Encoder;

public final class NodeLock
implements Cloneable,
Serializable {
    protected String objectUri;
    protected String subjectUri;
    protected String typeUri;
    protected Date expirationDate;
    protected boolean inheritance;
    protected boolean exclusive;
    protected String lockId;
    protected String ownerInfo;
    protected static MessageDigest md5Helper;
    protected static final MD5Encoder md5Encoder;
    static /* synthetic */ Class class$org$apache$slide$lock$NodeLock;

    static {
        md5Encoder = new MD5Encoder();
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public NodeLock() {
    }

    public NodeLock(String lockId, String objectUri, String subjectUri, String typeUri, Date expirationDate, boolean inheritance, boolean exclusive) {
        this(lockId, objectUri, subjectUri, typeUri, expirationDate, inheritance, exclusive, null);
    }

    public NodeLock(String lockId, String objectUri, String subjectUri, String typeUri, Date expirationDate, boolean inheritance, boolean exclusive, String ownerInfo) {
        this.objectUri = objectUri;
        this.subjectUri = subjectUri;
        this.typeUri = typeUri;
        this.expirationDate = expirationDate;
        this.inheritance = inheritance;
        this.lockId = lockId;
        this.exclusive = exclusive;
        this.ownerInfo = ownerInfo;
    }

    public NodeLock(String objectUri, String subjectUri, String typeUri, Date expirationDate, boolean inheritance) {
        this(objectUri, subjectUri, typeUri, expirationDate, inheritance, true);
    }

    public NodeLock(String objectUri, String subjectUri, String typeUri, Date expirationDate, boolean inheritance, boolean exclusive) {
        this(objectUri, subjectUri, typeUri, expirationDate, inheritance, exclusive, null);
    }

    public NodeLock(String objectUri, String subjectUri, String typeUri, Date expirationDate, boolean inheritance, boolean exclusive, String ownerInfo) {
        this.objectUri = objectUri;
        this.subjectUri = subjectUri;
        this.typeUri = typeUri;
        this.expirationDate = expirationDate;
        this.inheritance = inheritance;
        this.lockId = NodeLock.generateLockID(objectUri.hashCode(), subjectUri.hashCode(), typeUri.hashCode(), expirationDate == null ? 0L : expirationDate.getTime());
        this.exclusive = exclusive;
        this.ownerInfo = ownerInfo;
    }

    public NodeLock(NodeLock lock, String typeUri) {
        this(lock.getLockId(), lock.getObjectUri(), lock.getSubjectUri(), typeUri, lock.getExpirationDate(), lock.isInheritable(), lock.isExclusive(), lock.getOwnerInfo());
    }

    public NodeLock(ObjectNode locked, SubjectNode user, ActionNode lockType, Date expirationDate, boolean inheritance) {
        this(locked.getUri(), user.getUri(), lockType.getUri(), expirationDate, inheritance);
    }

    public NodeLock(ObjectNode locked, SubjectNode user, ActionNode lockType, Date expirationDate, boolean inheritance, boolean exclusive) {
        this(locked.getUri(), user.getUri(), lockType.getUri(), expirationDate, inheritance, exclusive);
    }

    public NodeLock(ObjectNode locked, SubjectNode user, ActionNode lockType, Date expirationDate, boolean inheritance, boolean exclusive, String ownerInfo) {
        this(locked.getUri(), user.getUri(), lockType.getUri(), expirationDate, inheritance, exclusive, ownerInfo);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public NodeLock cloneObject() {
        NodeLock result = null;
        try {
            result = (NodeLock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static final void encode(byte[] buf, int offset, int number) {
        buf[offset] = (byte)(number & 0xFF);
        buf[offset + 1] = (byte)(number >> 8 & 0xFF);
        buf[offset + 2] = (byte)(number >> 16 & 0xFF);
        buf[offset + 3] = (byte)(number >> 24 & 0xFF);
    }

    private static final void encode(byte[] buf, int offset, long number) {
        buf[offset] = (byte)(number & 0xFFL);
        buf[offset + 1] = (byte)(number >> 8 & 0xFFL);
        buf[offset + 2] = (byte)(number >> 16 & 0xFFL);
        buf[offset + 3] = (byte)(number >> 24 & 0xFFL);
        buf[offset + 4] = (byte)(number >> 32 & 0xFFL);
        buf[offset + 5] = (byte)(number >> 40 & 0xFFL);
        buf[offset + 6] = (byte)(number >> 48 & 0xFFL);
        buf[offset + 7] = (byte)(number >> 56 & 0xFFL);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof NodeLock) {
            NodeLock lock = (NodeLock)obj;
            result = this.getLockId().equals(lock.getLockId());
        }
        return result;
    }

    private static final String generateLockID(int object, int subject, int type, long expires) {
        long current = System.currentTimeMillis();
        byte[] input = new byte[28];
        NodeLock.encode(input, 0, object);
        NodeLock.encode(input, 4, subject);
        NodeLock.encode(input, 8, type);
        if (expires != 0L) {
            NodeLock.encode(input, 12, expires);
        }
        NodeLock.encode(input, 20, current);
        return md5Encoder.encode(md5Helper.digest(input));
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getLockId() {
        return this.lockId;
    }

    public String getObjectUri() {
        return this.objectUri;
    }

    public String getOwnerInfo() {
        return this.ownerInfo;
    }

    public String getSubjectUri() {
        return this.subjectUri;
    }

    public String getTypeUri() {
        return this.typeUri;
    }

    public boolean hasExpired() {
        return this.expirationDate.before(new Date());
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isInheritable() {
        return this.inheritance;
    }

    public boolean isShared() {
        return this.exclusive ^ true;
    }

    void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    void setInheritable(boolean inheritance) {
        this.inheritance = inheritance;
    }

    void setObjectUri(String objectUri) {
        this.objectUri = objectUri;
    }

    public void setOwnerInfo(String ownerInfo) {
        this.ownerInfo = ownerInfo;
    }

    void setSubjectUri(String subjectUri) {
        this.subjectUri = subjectUri;
    }

    void setTypeUri(String typeUri) {
        this.typeUri = typeUri;
    }

    public void validate(String expectedUri) {
        if (this.objectUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".nullObjectUri"));
        }
        if (!this.objectUri.equals(expectedUri)) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".incorrectObjectUri"));
        }
        if (this.subjectUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".nullSubjectUri"));
        }
        if (this.typeUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".nullTypeUri"));
        }
        if (this.expirationDate == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".nullExpirationDate"));
        }
        if (this.lockId == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".nullLockId"));
        }
    }
}

