/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.content;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.slide.common.Domain;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.util.Messages;
import org.jdom.Namespace;

public final class NodeProperty
implements Serializable,
Cloneable {
    public static final String DEFAULT_NAMESPACE = "DAV:";
    public static final String SLIDE_NAMESPACE = "http://jakarta.apache.org/slide/";
    protected static final String I_STANDARDLIVEPROPERTIESCLASS = "standardLivePropertiesClass";
    protected static final String I_STANDARDLIVEPROPERTIESCLASS_DEFAULT = "org.apache.slide.webdav.util.resourcekind.AbstractResourceKind";
    public static Set allLiveProperties;
    public static Set allProtectedProperties;
    public static Set allComputedProperties;
    private String name;
    private String namespace;
    private Object value;
    private String type;
    private Kind kind = Kind.DEAD;
    private Vector permissions;
    static /* synthetic */ Class class$org$apache$slide$content$NodeProperty;

    static {
        try {
            if (Domain.isInitialized()) {
                Class<?> slpc = Class.forName(Domain.getParameter(I_STANDARDLIVEPROPERTIESCLASS, I_STANDARDLIVEPROPERTIESCLASS_DEFAULT));
                Method lp = slpc.getMethod("getAllLiveProperties", new Class[0]);
                allLiveProperties = (Set)lp.invoke(null, new Object[0]);
                Method pp = slpc.getMethod("getAllProtectedProperties", new Class[0]);
                allProtectedProperties = (Set)pp.invoke(null, new Object[0]);
                Method cp = slpc.getMethod("getAllComputedProperties", new Class[0]);
                allComputedProperties = (Set)cp.invoke(null, new Object[0]);
            }
        }
        catch (Exception x) {
            Domain.warn("Loading of standard live properties class failed: " + x.getMessage());
        }
        if (allLiveProperties == null) {
            allLiveProperties = Collections.EMPTY_SET;
        }
        if (allProtectedProperties == null) {
            allProtectedProperties = Collections.EMPTY_SET;
        }
        if (allComputedProperties == null) {
            allComputedProperties = Collections.EMPTY_SET;
        }
    }

    public NodeProperty(String name, Object value) {
        this.setName(name);
        this.setValue(value);
        this.namespace = DEFAULT_NAMESPACE;
        this.type = new String();
        this.permissions = new Vector();
        this.kind = NodeProperty.determineKind(this.namespace, name);
    }

    public NodeProperty(String name, Object value, String namespace) {
        this(name, value);
        this.setNamespace(namespace);
        this.kind = NodeProperty.determineKind(namespace, name);
    }

    public NodeProperty(String name, Object value, String namespace, String type) {
        this(name, value);
        this.setNamespace(namespace);
        this.type = type;
        this.kind = NodeProperty.determineKind(namespace, name);
    }

    public NodeProperty(String name, Object value, String namespace, String type, boolean protectedProperty) {
        this(name, value, namespace);
        this.setType(type);
        if (protectedProperty) {
            this.setKind(Kind.PROTECTED);
        } else {
            this.kind = NodeProperty.determineKind(namespace, name);
        }
    }

    public NodeProperty(String name, Object value, boolean protectedProperty) {
        this(name, value);
        this.kind = protectedProperty ? Kind.PROTECTED : NodeProperty.determineKind(DEFAULT_NAMESPACE, name);
    }

    public void addPermission(NodePermission permission) {
        this.permissions.addElement(permission);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    NodeProperty cloneObject() {
        NodeProperty result = null;
        try {
            result = (NodeProperty)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return result;
    }

    private static Kind determineKind(String namespace, String name) {
        Kind result = Kind.DEAD;
        if (DEFAULT_NAMESPACE.equals(namespace)) {
            if (allComputedProperties.contains(name)) {
                result = Kind.COMPUTED;
            } else if (allProtectedProperties.contains(name)) {
                result = Kind.PROTECTED;
            } else if (allLiveProperties.contains(name)) {
                result = Kind.LIVE;
            }
        }
        return result;
    }

    public Enumeration enumeratePermissions() {
        return this.permissions.elements();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof NodeProperty) {
            NodeProperty property = (NodeProperty)obj;
            result = this.name.equals(property.getName());
        }
        return result;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isComputed() {
        return this.kind == Kind.COMPUTED;
    }

    public boolean isDeadProperty() {
        return this.kind == Kind.DEAD;
    }

    public boolean isLiveProperty() {
        return this.kind == Kind.LIVE || this.kind == Kind.PROTECTED || this.kind == Kind.COMPUTED;
    }

    public boolean isProtected() {
        return this.kind == Kind.PROTECTED || this.kind == Kind.COMPUTED;
    }

    public void removePermission(NodePermission permission) {
        this.permissions.removeElement(permission);
    }

    public void setKind(Kind kind) {
        this.kind = kind == null ? Kind.DEAD : kind;
    }

    void setName(String name) {
        this.name = name == null ? new String() : name;
    }

    void setNamespace(String namespace) {
        this.namespace = namespace == null ? "" : namespace;
    }

    void setType(String type) {
        this.type = type == null ? new String() : type;
    }

    void setValue(Object value) {
        this.value = value == null ? new String() : value;
    }

    public String toString() {
        return this.getName();
    }

    public void validate() {
        if (this.name == null) {
            throw new ObjectValidationFailedException(Messages.message(String.valueOf((class$org$apache$slide$content$NodeProperty != null ? class$org$apache$slide$content$NodeProperty : (class$org$apache$slide$content$NodeProperty = NodeProperty.class$("org.apache.slide.content.NodeProperty"))).getName()) + ".nullName"));
        }
        if (this.namespace == null) {
            throw new ObjectValidationFailedException(Messages.message(String.valueOf((class$org$apache$slide$content$NodeProperty != null ? class$org$apache$slide$content$NodeProperty : (class$org$apache$slide$content$NodeProperty = NodeProperty.class$("org.apache.slide.content.NodeProperty"))).getName()) + ".nullNamespace"));
        }
        if (this.value == null) {
            throw new ObjectValidationFailedException(Messages.message(String.valueOf((class$org$apache$slide$content$NodeProperty != null ? class$org$apache$slide$content$NodeProperty : (class$org$apache$slide$content$NodeProperty = NodeProperty.class$("org.apache.slide.content.NodeProperty"))).getName()) + ".nullValue"));
        }
    }

    public static class Kind
    implements Serializable {
        private static int DEAD_ID = 0;
        private static int LIVE_ID = 1;
        private static int PROTECTED_ID = 2;
        private static int COMPUTED_ID = 3;
        public static Kind DEAD = new Kind(DEAD_ID);
        public static Kind LIVE = new Kind(LIVE_ID);
        public static Kind PROTECTED = new Kind(PROTECTED_ID);
        public static Kind COMPUTED = new Kind(COMPUTED_ID);
        private int id = 0;

        private Kind(int id) {
            this.id = id;
        }
    }

    public static class NamespaceCache {
        public static final String SLIDE_PREFIX = "S";
        public static final String SLIDE_URI = "http://jakarta.apache.org/slide/";
        public static final Namespace SLIDE_NAMESPACE = NamespaceCache.getNamespace("S", "http://jakarta.apache.org/slide/");
        public static final String DEFAULT_PREFIX = "D";
        public static final String DEFAULT_URI = "DAV:";
        public static final Namespace DEFAULT_NAMESPACE = NamespaceCache.getNamespace("D", "DAV:");
        protected static Map namespaceMap;

        public static Namespace getNamespace(String uri) {
            return NamespaceCache.getNamespace("", uri);
        }

        public static Namespace getNamespace(String prefix, String uri) {
            Namespace namespace = (Namespace)NamespaceCache.getNamespaceMap().get(uri);
            if (namespace == null) {
                namespace = Namespace.getNamespace((String)prefix, (String)uri);
                NamespaceCache.getNamespaceMap().put(namespace.getURI(), namespace);
            }
            return namespace;
        }

        protected static Map getNamespaceMap() {
            if (namespaceMap == null) {
                namespaceMap = new HashMap();
            }
            return namespaceMap;
        }
    }
}

