/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.content;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.slide.common.Domain;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.content.BranchNotFoundException;
import org.apache.slide.content.Content;
import org.apache.slide.content.ContentInterceptor;
import org.apache.slide.content.NodeNotVersionedException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionContentNotFoundException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.Security;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;

public final class ContentImpl
implements Content {
    protected static final String I_URIREDIRECTORCLASS = "uriRedirectorClass";
    protected static final String I_URIREDIRECTORCLASS_DEFAULT = "org.apache.slide.webdav.util.DeltavUriRedirector";
    protected static final int PRE_STORE = 0;
    protected static final int POST_STORE = 1;
    protected static final int POST_RETRIEVE = 2;
    protected static final int PRE_REMOVE = 3;
    protected static final int POST_REMOVE = 4;
    protected static Class uriRedirectorClass;
    private Namespace namespace;
    private NamespaceConfig namespaceConfig;
    private Security securityHelper;
    private Structure structureHelper;
    private Lock lockHelper;
    static /* synthetic */ Class class$java$lang$String;

    static {
        try {
            String uriRedirectorClassName = Domain.getParameter(I_URIREDIRECTORCLASS, I_URIREDIRECTORCLASS_DEFAULT);
            uriRedirectorClass = Class.forName(uriRedirectorClassName);
        }
        catch (Exception x) {
            Domain.warn("Loading of redirector class failed: " + x.getMessage());
        }
    }

    public ContentImpl(Namespace namespace, NamespaceConfig namespaceConfig, Security securityHelper, Structure structureHelper, Lock lockHelper) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.securityHelper = securityHelper;
        this.structureHelper = structureHelper;
        this.lockHelper = lockHelper;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void create(SlideToken token, String strUri, String branch, NodeRevisionDescriptor newRevisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, RevisionAlreadyExistException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException, BranchNotFoundException {
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        if (branch != null) {
            NodeRevisionNumber branchLatestRevisionNumber = revisionDescriptors.getLatestRevision(branch);
            if (branchLatestRevisionNumber == null) {
                throw new BranchNotFoundException(strUri, branch);
            }
            this.create(token, strUri, branchLatestRevisionNumber, newRevisionDescriptor, revisionContent);
        } else {
            this.create(token, strUri, newRevisionDescriptor);
        }
    }

    protected void create(SlideToken token, String strUri, NodeRevisionDescriptor revisionDescriptor) throws ObjectNotFoundException, AccessDeniedException, RevisionAlreadyExistException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.setDefaultProperties(associatedObject, revisionDescriptor);
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        revisionDescriptor.setCreationDate(new Date());
        String branchName = "backup";
        NodeProperty rootVersionProperty = revisionDescriptor.getProperty("version-set");
        if (rootVersionProperty != null) {
            branchName = "version-history";
        }
        revisionDescriptor.setBranchName(branchName);
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, null, 0);
        objectUri.getStore().createRevisionDescriptor(objectUri, revisionDescriptor);
        try {
            objectUri.getStore().storeRevisionDescriptors(objectUri, revisionDescriptors);
        }
        catch (RevisionDescriptorNotFoundException e) {
            e.printStackTrace();
        }
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, null, 1);
    }

    public void create(SlideToken token, String strUri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, RevisionAlreadyExistException, LinkedObjectNotFoundException, ServiceAccessException, ObjectLockedException {
        String resourceName;
        int lastSlash;
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        if (this.namespaceConfig.getCreateRevisionMetadataAction() != this.namespaceConfig.getCreateRevisionContentAction()) {
            this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
            this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        }
        this.setDefaultProperties(associatedObject, revisionDescriptor);
        if (revisionDescriptor.getCreationDate() == null) {
            revisionDescriptor.setCreationDate(new Date());
        }
        if ((lastSlash = (resourceName = strUri).lastIndexOf(47)) != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        revisionDescriptor.setName(resourceName);
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = null;
        try {
            revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        }
        catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
            revisionDescriptors = new NodeRevisionDescriptors();
            revisionDescriptors.setUri(objectUri.toString());
            objectUri.getStore().createRevisionDescriptors(objectUri, revisionDescriptors);
        }
        NodeRevisionNumber newRevisionNumber = null;
        if (revisionDescriptors.isVersioned()) {
            if (revisionDescriptors.hasRevisions()) {
                newRevisionNumber = new NodeRevisionNumber(revisionDescriptors.getLatestRevision());
                revisionDescriptors.addSuccessor(revisionDescriptors.getLatestRevision(), newRevisionNumber);
                revisionDescriptors.setSuccessors(newRevisionNumber, new Vector());
            } else {
                newRevisionNumber = new NodeRevisionNumber();
                revisionDescriptors.setSuccessors(newRevisionNumber, new Vector());
            }
            revisionDescriptors.setLatestRevision(newRevisionNumber);
            revisionDescriptor.setRevisionNumber(newRevisionNumber);
            this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 0);
            if (revisionContent != null) {
                objectUri.getStore().createRevisionContent(objectUri, revisionDescriptor, revisionContent);
            }
            objectUri.getStore().createRevisionDescriptor(objectUri, revisionDescriptor);
        } else {
            newRevisionNumber = new NodeRevisionNumber();
            revisionDescriptor.setRevisionNumber(newRevisionNumber);
            if (!revisionDescriptors.hasRevisions()) {
                this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 0);
                if (revisionContent != null) {
                    objectUri.getStore().createRevisionContent(objectUri, revisionDescriptor, revisionContent);
                }
                objectUri.getStore().createRevisionDescriptor(objectUri, revisionDescriptor);
            } else {
                try {
                    NodeRevisionDescriptor oldRevisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, newRevisionNumber);
                    Enumeration newPropertiesList = revisionDescriptor.enumerateProperties();
                    while (newPropertiesList.hasMoreElements()) {
                        oldRevisionDescriptor.setProperty((NodeProperty)newPropertiesList.nextElement());
                    }
                    revisionDescriptor = oldRevisionDescriptor;
                    this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 0);
                    if (revisionContent != null) {
                        try {
                            objectUri.getStore().storeRevisionContent(objectUri, revisionDescriptor, revisionContent);
                        }
                        catch (RevisionNotFoundException revisionNotFoundException) {
                            objectUri.getStore().createRevisionContent(objectUri, revisionDescriptor, revisionContent);
                        }
                    }
                    objectUri.getStore().storeRevisionDescriptor(objectUri, revisionDescriptor);
                }
                catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
                    this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 0);
                    objectUri.getStore().createRevisionDescriptor(objectUri, revisionDescriptor);
                }
            }
            revisionDescriptors.setSuccessors(newRevisionNumber, new Vector());
            revisionDescriptors.setLatestRevision(newRevisionNumber);
        }
        try {
            objectUri.getStore().storeRevisionDescriptors(objectUri, revisionDescriptors);
        }
        catch (RevisionDescriptorNotFoundException e) {
            e.printStackTrace();
        }
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 1);
    }

    protected void create(SlideToken token, String strUri, NodeRevisionNumber basedOnRevisionNumber, NodeRevisionDescriptor newRevisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, RevisionAlreadyExistException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.setDefaultProperties(associatedObject, newRevisionDescriptor);
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        if (!revisionDescriptors.isVersioned()) {
            throw new NodeNotVersionedException(strUri);
        }
        NodeRevisionDescriptor realOldRevisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, basedOnRevisionNumber);
        NodeRevisionNumber latestNumberInBranch = revisionDescriptors.getLatestRevision(realOldRevisionDescriptor.getBranchName());
        if (!realOldRevisionDescriptor.getRevisionNumber().equals(latestNumberInBranch)) {
            throw new RevisionAlreadyExistException(objectUri.toString(), new NodeRevisionNumber(basedOnRevisionNumber));
        }
        newRevisionDescriptor.setRevisionNumber(new NodeRevisionNumber(basedOnRevisionNumber));
        newRevisionDescriptor.setCreationDate(new Date());
        newRevisionDescriptor.setBranchName(realOldRevisionDescriptor.getBranchName());
        this.invokeInterceptors(token, revisionDescriptors, newRevisionDescriptor, revisionContent, 0);
        revisionDescriptors.addSuccessor(revisionDescriptors.getLatestRevision(newRevisionDescriptor.getBranchName()), newRevisionDescriptor.getRevisionNumber());
        revisionDescriptors.setSuccessors(newRevisionDescriptor.getRevisionNumber(), new Vector());
        revisionDescriptors.setLatestRevision(newRevisionDescriptor.getBranchName(), newRevisionDescriptor.getRevisionNumber());
        if (revisionContent != null) {
            objectUri.getStore().createRevisionContent(objectUri, newRevisionDescriptor, revisionContent);
        }
        objectUri.getStore().createRevisionDescriptor(objectUri, newRevisionDescriptor);
        try {
            objectUri.getStore().storeRevisionDescriptors(objectUri, revisionDescriptors);
        }
        catch (RevisionDescriptorNotFoundException e) {
            e.printStackTrace();
        }
        this.invokeInterceptors(token, revisionDescriptors, newRevisionDescriptor, revisionContent, 1);
    }

    public void create(SlideToken token, String strUri, boolean isVersioned) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, ObjectLockedException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        if (this.namespaceConfig.getCreateRevisionMetadataAction() != this.namespaceConfig.getCreateRevisionContentAction()) {
            this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
            this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        }
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = new NodeRevisionDescriptors(isVersioned);
        revisionDescriptors.setUri(strUri);
        objectUri.getStore().createRevisionDescriptors(objectUri, revisionDescriptors);
    }

    public NodeRevisionNumber fork(SlideToken token, String strUri, String branchName, NodeRevisionDescriptor basedOnRevisionDescriptor) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException, RevisionAlreadyExistException {
        return this.fork(token, strUri, branchName, basedOnRevisionDescriptor.getRevisionNumber());
    }

    public NodeRevisionNumber fork(SlideToken token, String strUri, String branchName, NodeRevisionNumber basedOnRevisionNumber) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException, RevisionAlreadyExistException {
        if (branchName.equals("main")) {
            return null;
        }
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        if (!revisionDescriptors.isVersioned()) {
            throw new NodeNotVersionedException(strUri);
        }
        NodeRevisionDescriptor basedOnRevisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, basedOnRevisionNumber);
        NodeRevisionContent basedOnRevisionContent = null;
        try {
            basedOnRevisionContent = objectUri.getStore().retrieveRevisionContent(objectUri, basedOnRevisionDescriptor);
        }
        catch (RevisionNotFoundException revisionNotFoundException) {}
        NodeRevisionNumber branchedRevisionNumber = new NodeRevisionNumber(basedOnRevisionNumber, true);
        basedOnRevisionDescriptor.setRevisionNumber(branchedRevisionNumber);
        basedOnRevisionDescriptor.setBranchName(branchName);
        revisionDescriptors.setUri(strUri);
        revisionDescriptors.setLatestRevision(branchName, branchedRevisionNumber);
        revisionDescriptors.addSuccessor(basedOnRevisionNumber, branchedRevisionNumber);
        this.invokeInterceptors(token, revisionDescriptors, basedOnRevisionDescriptor, basedOnRevisionContent, 0);
        if (basedOnRevisionContent != null) {
            objectUri.getStore().createRevisionContent(objectUri, basedOnRevisionDescriptor, basedOnRevisionContent);
        }
        objectUri.getStore().createRevisionDescriptor(objectUri, basedOnRevisionDescriptor);
        objectUri.getStore().storeRevisionDescriptors(objectUri, revisionDescriptors);
        this.invokeInterceptors(token, revisionDescriptors, basedOnRevisionDescriptor, basedOnRevisionContent, 1);
        return branchedRevisionNumber;
    }

    protected void invokeInterceptors(SlideToken token, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent, int type) throws AccessDeniedException, ObjectNotFoundException, LinkedObjectNotFoundException, ObjectLockedException, ServiceAccessException {
        ContentInterceptor[] contentInterceptors = this.namespace.getContentInterceptors();
        int i = 0;
        while (i < contentInterceptors.length) {
            switch (type) {
                case 0: {
                    contentInterceptors[i].preStoreContent(token, revisionDescriptors, revisionDescriptor, revisionContent);
                    break;
                }
                case 1: {
                    contentInterceptors[i].postStoreContent(token, revisionDescriptors, revisionDescriptor, revisionContent);
                    break;
                }
                case 2: {
                    contentInterceptors[i].postRetrieveContent(token, revisionDescriptors, revisionDescriptor, revisionContent);
                    break;
                }
                case 3: {
                    contentInterceptors[i].preRemoveContent(token, revisionDescriptors, revisionDescriptor);
                    break;
                }
                case 4: {
                    contentInterceptors[i].postRemoveContent(token, revisionDescriptors, revisionDescriptor);
                    break;
                }
            }
            ++i;
        }
    }

    public void merge(SlideToken token, String strUri, String mainBranch, String branch, NodeRevisionDescriptor newRevisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException, BranchNotFoundException, RevisionAlreadyExistException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.setDefaultProperties(associatedObject, newRevisionDescriptor);
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        if (!revisionDescriptors.isVersioned()) {
            throw new NodeNotVersionedException(strUri);
        }
        NodeRevisionNumber mainBranchLatestRevisionNumber = revisionDescriptors.getLatestRevision(mainBranch);
        NodeRevisionNumber branchLatestRevisionNumber = revisionDescriptors.getLatestRevision(branch);
        if (mainBranchLatestRevisionNumber == null) {
            throw new BranchNotFoundException(strUri, mainBranch);
        }
        if (branchLatestRevisionNumber == null) {
            throw new BranchNotFoundException(strUri, branch);
        }
        NodeRevisionNumber newRevisionNumber = new NodeRevisionNumber(mainBranchLatestRevisionNumber);
        newRevisionDescriptor.setRevisionNumber(newRevisionNumber);
        newRevisionDescriptor.setBranchName(branch);
        revisionDescriptors.addSuccessor(mainBranchLatestRevisionNumber, newRevisionNumber);
        revisionDescriptors.addSuccessor(branchLatestRevisionNumber, newRevisionNumber);
        revisionDescriptors.setLatestRevision(mainBranch, newRevisionNumber);
        this.invokeInterceptors(token, revisionDescriptors, newRevisionDescriptor, revisionContent, 0);
        if (revisionContent != null) {
            objectUri.getStore().createRevisionContent(objectUri, newRevisionDescriptor, revisionContent);
        }
        objectUri.getStore().createRevisionDescriptor(objectUri, newRevisionDescriptor);
        objectUri.getStore().storeRevisionDescriptors(objectUri, revisionDescriptors);
        this.invokeInterceptors(token, revisionDescriptors, newRevisionDescriptor, revisionContent, 1);
    }

    public void merge(SlideToken token, String strUri, NodeRevisionDescriptor mainBranch, NodeRevisionDescriptor branch, NodeRevisionDescriptor newRevisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException, BranchNotFoundException, RevisionAlreadyExistException {
        this.merge(token, strUri, mainBranch.getBranchName(), branch.getBranchName(), newRevisionDescriptor, revisionContent);
    }

    protected NodeRevisionNumber redirectLatestRevisionNumber(String uri) {
        NodeRevisionNumber result;
        block2: {
            result = null;
            if (uriRedirectorClass == null) break block2;
            try {
                Method ru = uriRedirectorClass.getMethod("redirectLatestRevisionNumber", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ContentImpl.class$("java.lang.String")));
                result = (NodeRevisionNumber)ru.invoke(null, uri);
            }
            catch (Exception x) {
                Domain.warn("Redirecting of latest revision number for " + uri + " failed: " + x.getMessage());
            }
        }
        return result;
    }

    protected String redirectUri(String uri) {
        String result;
        block2: {
            result = uri;
            if (uriRedirectorClass == null) break block2;
            try {
                Method ru = uriRedirectorClass.getMethod("redirectUri", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ContentImpl.class$("java.lang.String")));
                result = (String)ru.invoke(null, uri);
            }
            catch (Exception x) {
                Domain.warn("Redirecting of URI " + uri + " failed: " + x.getMessage());
            }
        }
        return result;
    }

    public void remove(SlideToken token, String strUri, NodeRevisionDescriptor revisionDescriptor) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException {
        this.remove(token, strUri, revisionDescriptor.getRevisionNumber());
    }

    public void remove(SlideToken token, String strUri, NodeRevisionNumber revisionNumber) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getRemoveRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getRemoveRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getRemoveRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getRemoveRevisionContentAction());
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptor revisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, revisionNumber);
        this.invokeInterceptors(token, null, revisionDescriptor, null, 3);
        objectUri.getStore().removeRevisionContent(objectUri, revisionDescriptor);
        objectUri.getStore().removeRevisionDescriptor(objectUri, revisionNumber);
        this.invokeInterceptors(token, null, revisionDescriptor, null, 4);
    }

    public void remove(SlideToken token, NodeRevisionDescriptors revisionDescriptors) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException {
        this.invokeInterceptors(token, revisionDescriptors, null, null, 3);
        ObjectNode associatedObject = this.structureHelper.retrieve(token, revisionDescriptors.getUri(), false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getRemoveRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getRemoveRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getRemoveRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getRemoveRevisionContentAction());
        Uri objectUri = this.namespace.getUri(token, revisionDescriptors.getUri());
        objectUri.getStore().removeRevisionDescriptors(objectUri);
        this.invokeInterceptors(token, revisionDescriptors, null, null, 4);
    }

    public NodeRevisionDescriptors retrieve(SlideToken token, String strUri) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, ObjectLockedException {
        String originalUri = strUri;
        strUri = this.redirectUri(originalUri);
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getReadRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getReadRevisionMetadataAction());
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = null;
        try {
            revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        }
        catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
            revisionDescriptors = new NodeRevisionDescriptors();
            revisionDescriptors.setUri(objectUri.toString());
            objectUri.getStore().createRevisionDescriptors(objectUri, revisionDescriptors);
        }
        revisionDescriptors.setOriginalUri(originalUri);
        return revisionDescriptors;
    }

    public NodeRevisionContent retrieve(SlideToken token, String strUri, NodeRevisionDescriptor revisionDescriptor) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionNotFoundException, RevisionContentNotFoundException, ObjectLockedException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getReadRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getReadRevisionContentAction());
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionContent revisionContent = objectUri.getStore().retrieveRevisionContent(objectUri, revisionDescriptor);
        this.invokeInterceptors(token, null, revisionDescriptor, revisionContent, 2);
        return revisionContent;
    }

    public NodeRevisionDescriptor retrieve(SlideToken token, NodeRevisionDescriptors revisionDescriptors) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException {
        Uri objectUri = this.namespace.getUri(token, revisionDescriptors.getUri());
        NodeRevisionNumber latestNrn = this.redirectLatestRevisionNumber(revisionDescriptors.getOriginalUri());
        NodeRevisionDescriptors realRevisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        NodeRevisionDescriptor result = latestNrn == null ? this.retrieve(token, revisionDescriptors, realRevisionDescriptors.getLatestRevision()) : this.retrieve(token, revisionDescriptors, latestNrn);
        return result;
    }

    public NodeRevisionDescriptor retrieve(SlideToken token, NodeRevisionDescriptors revisionDescriptors, String branch) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, BranchNotFoundException, NodeNotVersionedException {
        NodeRevisionDescriptor result;
        Uri objectUri = this.namespace.getUri(token, revisionDescriptors.getUri());
        NodeRevisionNumber latestNrn = this.redirectLatestRevisionNumber(revisionDescriptors.getOriginalUri());
        NodeRevisionDescriptors realRevisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        if (!realRevisionDescriptors.isVersioned()) {
            throw new NodeNotVersionedException(realRevisionDescriptors.getUri().toString());
        }
        if (latestNrn == null) {
            NodeRevisionNumber branchLatestRevisionNumber = realRevisionDescriptors.getLatestRevision(branch);
            if (branchLatestRevisionNumber == null) {
                throw new BranchNotFoundException(realRevisionDescriptors.getUri().toString(), branch);
            }
            result = this.retrieve(token, realRevisionDescriptors, branchLatestRevisionNumber);
        } else {
            result = this.retrieve(token, revisionDescriptors, latestNrn);
        }
        return result;
    }

    public NodeRevisionContent retrieve(SlideToken token, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionNotFoundException, RevisionContentNotFoundException, ObjectLockedException {
        return this.retrieve(token, revisionDescriptors.getUri(), revisionDescriptor);
    }

    public NodeRevisionDescriptor retrieve(SlideToken token, NodeRevisionDescriptors revisionDescriptors, NodeRevisionNumber revisionNumber) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, revisionDescriptors.getUri(), false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getReadRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getReadRevisionMetadataAction());
        Uri objectUri = this.namespace.getUri(token, revisionDescriptors.getUri());
        NodeRevisionDescriptor revisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, revisionNumber);
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, null, 2);
        return revisionDescriptor;
    }

    protected void setDefaultProperties(ObjectNode associatedObject, NodeRevisionDescriptor revisionDescriptor) {
        Enumeration roles = this.securityHelper.getRoles(associatedObject);
        while (roles.hasMoreElements()) {
            String role = (String)roles.nextElement();
            Enumeration defaultProperties = this.namespaceConfig.getDefaultProperties(role);
            revisionDescriptor.setDefaultProperties(defaultProperties);
        }
    }

    public void store(SlideToken token, String strUri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, RevisionNotFoundException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getModifyRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getModifyRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getModifyRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getModifyRevisionContentAction());
        this.setDefaultProperties(associatedObject, revisionDescriptor);
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        NodeRevisionDescriptor oldRevisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, revisionDescriptor.getRevisionNumber());
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 0);
        if (revisionContent != null) {
            try {
                objectUri.getStore().retrieveRevisionContent(objectUri, revisionDescriptor);
                objectUri.getStore().storeRevisionContent(objectUri, revisionDescriptor, revisionContent);
            }
            catch (RevisionNotFoundException revisionNotFoundException) {
                try {
                    objectUri.getStore().createRevisionContent(objectUri, revisionDescriptor, revisionContent);
                }
                catch (RevisionAlreadyExistException ex) {
                    ex.printStackTrace();
                }
            }
        }
        objectUri.getStore().storeRevisionDescriptor(objectUri, revisionDescriptor);
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 1);
    }
}

