/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.io.FileInputStream;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.slide.authenticate.SecurityToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.DomainAccessToken;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideMBean;
import org.apache.slide.util.conf.ConfigurationElement;
import org.apache.slide.util.conf.Populate;
import org.xml.sax.InputSource;

public final class Slide
extends NotificationBroadcasterSupport
implements SlideMBean,
MBeanRegistration {
    private Domain domain = new Domain();
    private int state = 0;
    private String configFile = null;
    private long sequenceNumber = 0L;

    public DomainAccessToken accessDomain(SecurityToken token) {
        return Domain.accessDomain(token);
    }

    public NamespaceAccessToken accessNamespace(SecurityToken token, String namespaceName) {
        return Domain.accessNamespace(token, namespaceName);
    }

    public void closeNamespace(SecurityToken token, String namespaceName) {
        Domain.closeNamespace(token, namespaceName);
    }

    public void closeNamespace(NamespaceAccessToken token) {
        Domain.closeNamespace(token);
    }

    public void destroy() {
        if (this.getState() != 0) {
            this.stop();
        }
    }

    public String getName() {
        return "Slide content management server";
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return SlideMBean.states[this.state];
    }

    public void init() throws Exception {
    }

    public void init(String configFile) throws Exception {
        this.configFile = configFile;
    }

    public void postDeregister() {
        this.destroy();
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.destroy();
        }
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return new ObjectName(":service=Slide");
    }

    public void start() throws Exception {
        AttributeChangeNotification notification = null;
        if (this.state != 0) {
            return;
        }
        this.state = 2;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Starting Slide content management server", "State", "java.lang.Integer", new Integer(0), new Integer(2));
        this.sendNotification(notification);
        try {
            if (this.configFile == null) {
                Domain.selfInit();
            } else {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(false);
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                FileInputStream is = new FileInputStream(this.configFile);
                Populate pop = new Populate();
                ConfigurationElement slideConfiguration = new ConfigurationElement(pop.load(new InputSource(is), parser.getXMLReader()));
                Domain.init(slideConfiguration);
                Domain.start();
            }
        }
        catch (Throwable throwable) {
            this.state = 0;
            notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Slide content management server", "State", "java.lang.Integer", new Integer(2), new Integer(0));
            this.sendNotification(notification);
        }
        this.state = 3;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Started Slide content management server", "State", "java.lang.Integer", new Integer(2), new Integer(3));
        this.sendNotification(notification);
    }

    public void stop() {
        AttributeChangeNotification notification = null;
        if (this.state != 3) {
            return;
        }
        this.state = 1;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopping Slide content management server", "State", "java.lang.Integer", new Integer(3), new Integer(1));
        this.sendNotification(notification);
        try {
            Domain.stop();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.state = 0;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Slide content management server", "State", "java.lang.Integer", new Integer(1), new Integer(0));
        this.sendNotification(notification);
    }
}

