/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.InvalidNamespaceConfigurationException;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceAccessTokenImpl;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.ContentInterceptor;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.util.Messages;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;

public final class NamespaceConfig {
    public static final String NOBODY = "nobody";
    public static final String NOBODY_ROLE = (class$org$apache$slide$structure$ObjectNode != null ? class$org$apache$slide$structure$ObjectNode : (class$org$apache$slide$structure$ObjectNode = NamespaceConfig.class$("org.apache.slide.structure.ObjectNode"))).getName();
    public static final String BASE_ROLE = (class$org$apache$slide$structure$SubjectNode != null ? class$org$apache$slide$structure$SubjectNode : (class$org$apache$slide$structure$SubjectNode = NamespaceConfig.class$("org.apache.slide.structure.SubjectNode"))).getName();
    public static final String ACTION_ROLE = (class$org$apache$slide$structure$ActionNode != null ? class$org$apache$slide$structure$ActionNode : (class$org$apache$slide$structure$ActionNode = NamespaceConfig.class$("org.apache.slide.structure.ActionNode"))).getName();
    public static final String LINK_ROLE = (class$org$apache$slide$structure$LinkNode != null ? class$org$apache$slide$structure$LinkNode : (class$org$apache$slide$structure$LinkNode = NamespaceConfig.class$("org.apache.slide.structure.LinkNode"))).getName();
    protected String name;
    protected ActionNode defaultAction;
    protected ActionNode readObjectAction;
    protected ActionNode createObjectAction;
    protected ActionNode removeObjectAction;
    protected ActionNode grantPermissionAction;
    protected ActionNode revokePermissionAction;
    protected ActionNode readPermissionsAction;
    protected ActionNode lockObjectAction;
    protected ActionNode killLockAction;
    protected ActionNode readLocksAction;
    protected ActionNode createRevisionMetadataAction;
    protected ActionNode modifyRevisionMetadataAction;
    protected ActionNode removeRevisionMetadataAction;
    protected ActionNode readRevisionMetadataAction;
    protected ActionNode readRevisionContentAction;
    protected ActionNode createRevisionContentAction;
    protected ActionNode modifyRevisionContentAction;
    protected ActionNode removeRevisionContentAction;
    protected String usersPath;
    protected String guestPath;
    protected String filesPath;
    protected Hashtable parameters;
    protected Hashtable roleMappings = new Hashtable();
    protected Hashtable roleClassMappings = new Hashtable();
    protected Hashtable defaultProperties;
    protected static Vector emptyVector = new Vector();
    protected ContentInterceptor[] contentInterceptors = new ContentInterceptor[0];
    protected boolean autoCreateUsers = false;
    protected String autoCreateUsersRole = "slideroles.basic.UserRoleImpl";
    static /* synthetic */ Class class$org$apache$slide$structure$ObjectNode;
    static /* synthetic */ Class class$org$apache$slide$structure$SubjectNode;
    static /* synthetic */ Class class$org$apache$slide$structure$ActionNode;
    static /* synthetic */ Class class$org$apache$slide$structure$LinkNode;

    protected void addDefaultProperty(String role, String name, String value, String namespace) {
        if (role != null && name != null && value != null) {
            Vector<NodeProperty> currentDefaultProperties = (Vector<NodeProperty>)this.defaultProperties.get(role);
            if (currentDefaultProperties == null) {
                currentDefaultProperties = new Vector<NodeProperty>();
                this.defaultProperties.put(role, currentDefaultProperties);
            }
            currentDefaultProperties.addElement(new NodeProperty(name, (Object)value, namespace));
        }
    }

    protected void addParameter(String name, String value) {
        if (name != null && value != null) {
            this.parameters.put(name, value);
        }
    }

    protected void addRoleMapping(String name, String value) {
        if (name != null && value != null) {
            this.roleMappings.put(name, value);
            this.roleClassMappings.put(value, name);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected ActionNode getActionNode(Namespace namespace, String actionPath) throws InvalidNamespaceConfigurationException, SlideException {
        ActionNode result = null;
        if (actionPath != null) {
            Uri actionUri = namespace.getUri(actionPath);
            result = (ActionNode)actionUri.getStore().retrieveObject(actionUri);
        } else if (this.defaultAction != null) {
            result = this.defaultAction;
        } else {
            throw new InvalidNamespaceConfigurationException(namespace, "Needed default action is not defined");
        }
        return result;
    }

    public String getAutoCreateUsersRole() {
        return this.autoCreateUsersRole;
    }

    ContentInterceptor[] getContentInterceptors() {
        return this.contentInterceptors;
    }

    public ActionNode getCreateObjectAction() {
        return this.createObjectAction;
    }

    public ActionNode getCreateRevisionContentAction() {
        return this.createRevisionContentAction;
    }

    public ActionNode getCreateRevisionMetadataAction() {
        return this.createRevisionMetadataAction;
    }

    public ActionNode getDefaultAction() {
        return this.defaultAction;
    }

    public Enumeration getDefaultProperties(String role) {
        Vector result = (Vector)this.defaultProperties.get(role);
        if (result == null) {
            return emptyVector.elements();
        }
        return result.elements();
    }

    public String getFilesPath() {
        return this.filesPath;
    }

    public ActionNode getGrantPermissionAction() {
        return this.grantPermissionAction;
    }

    public String getGuestPath() {
        return this.guestPath;
    }

    public ActionNode getKillLockAction() {
        return this.killLockAction;
    }

    public ActionNode getLockObjectAction() {
        return this.lockObjectAction;
    }

    public ActionNode getModifyRevisionContentAction() {
        return this.modifyRevisionContentAction;
    }

    public ActionNode getModifyRevisionMetadataAction() {
        return this.modifyRevisionMetadataAction;
    }

    public String getParameter(String name) {
        Object result = this.parameters.get(name);
        if (result == null) {
            return null;
        }
        return (String)result;
    }

    public ActionNode getReadLocksAction() {
        return this.readLocksAction;
    }

    public ActionNode getReadObjectAction() {
        return this.readObjectAction;
    }

    public ActionNode getReadPermissionsAction() {
        return this.readPermissionsAction;
    }

    public ActionNode getReadRevisionContentAction() {
        return this.readRevisionContentAction;
    }

    public ActionNode getReadRevisionMetadataAction() {
        return this.readRevisionMetadataAction;
    }

    public ActionNode getRemoveObjectAction() {
        return this.removeObjectAction;
    }

    public ActionNode getRemoveRevisionContentAction() {
        return this.removeRevisionContentAction;
    }

    public ActionNode getRemoveRevisionMetadataAction() {
        return this.removeRevisionMetadataAction;
    }

    public ActionNode getRevokePermissionAction() {
        return this.revokePermissionAction;
    }

    public String getRoleMapping(String name) {
        Object result = this.roleMappings.get(name);
        if (result == null) {
            return (String)this.roleClassMappings.get(name);
        }
        return (String)result;
    }

    public String getUsersPath() {
        return this.usersPath;
    }

    void initializeAsDummyConfig(Namespace namespace) throws InvalidNamespaceConfigurationException {
        this.name = namespace.getName();
        try {
            Uri tempActionUri = namespace.getUri("/tempaction");
            this.readObjectAction = this.defaultAction = (ActionNode)tempActionUri.getStore().retrieveObject(tempActionUri);
            this.createObjectAction = this.defaultAction;
            this.removeObjectAction = this.defaultAction;
            this.grantPermissionAction = this.defaultAction;
            this.revokePermissionAction = this.defaultAction;
            this.readPermissionsAction = this.defaultAction;
            this.lockObjectAction = this.defaultAction;
            this.killLockAction = this.defaultAction;
            this.readLocksAction = this.defaultAction;
            this.readRevisionMetadataAction = this.defaultAction;
            this.createRevisionMetadataAction = this.defaultAction;
            this.modifyRevisionMetadataAction = this.defaultAction;
            this.removeRevisionMetadataAction = this.defaultAction;
            this.readRevisionContentAction = this.defaultAction;
            this.createRevisionContentAction = this.defaultAction;
            this.modifyRevisionContentAction = this.defaultAction;
            this.removeRevisionContentAction = this.defaultAction;
            this.usersPath = "";
            this.filesPath = "";
        }
        catch (Exception e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
    }

    public void initializeForTestPurposesOnly() throws InvalidNamespaceConfigurationException {
        this.name = "slide";
        try {
            this.readObjectAction = this.defaultAction;
            this.createObjectAction = this.defaultAction;
            this.removeObjectAction = this.defaultAction;
            this.grantPermissionAction = this.defaultAction;
            this.revokePermissionAction = this.defaultAction;
            this.readPermissionsAction = this.defaultAction;
            this.lockObjectAction = this.defaultAction;
            this.killLockAction = this.defaultAction;
            this.readLocksAction = this.defaultAction;
            this.readRevisionMetadataAction = this.defaultAction;
            this.createRevisionMetadataAction = this.defaultAction;
            this.modifyRevisionMetadataAction = this.defaultAction;
            this.removeRevisionMetadataAction = this.defaultAction;
            this.readRevisionContentAction = this.defaultAction;
            this.createRevisionContentAction = this.defaultAction;
            this.modifyRevisionContentAction = this.defaultAction;
            this.removeRevisionContentAction = this.defaultAction;
            this.usersPath = "";
            this.filesPath = "";
        }
        catch (Exception e) {
            throw new InvalidNamespaceConfigurationException(null, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void initializeNamespaceConfig(Namespace namespace, Configuration config) throws InvalidNamespaceConfigurationException, SlideException {
        this.name = namespace.getName();
        try {
            this.defaultAction = this.getActionNode(namespace, config.getConfiguration("default-action").getValue());
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
        try {
            this.readObjectAction = this.getActionNode(namespace, config.getConfiguration("read-object").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.readObjectAction = this.defaultAction;
        }
        try {
            this.createObjectAction = this.getActionNode(namespace, config.getConfiguration("create-object").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.createObjectAction = this.defaultAction;
        }
        try {
            this.removeObjectAction = this.getActionNode(namespace, config.getConfiguration("remove-object").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.removeObjectAction = this.defaultAction;
        }
        try {
            this.grantPermissionAction = this.getActionNode(namespace, config.getConfiguration("grant-permission").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.grantPermissionAction = this.defaultAction;
        }
        try {
            this.revokePermissionAction = this.getActionNode(namespace, config.getConfiguration("revoke-permission").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.revokePermissionAction = this.defaultAction;
        }
        try {
            this.readPermissionsAction = this.getActionNode(namespace, config.getConfiguration("read-permissions").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.readPermissionsAction = this.defaultAction;
        }
        try {
            this.lockObjectAction = this.getActionNode(namespace, config.getConfiguration("lock-object").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.lockObjectAction = this.defaultAction;
        }
        try {
            this.killLockAction = this.getActionNode(namespace, config.getConfiguration("kill-lock").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.killLockAction = this.defaultAction;
        }
        try {
            this.readLocksAction = this.getActionNode(namespace, config.getConfiguration("read-locks").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.readLocksAction = this.defaultAction;
        }
        try {
            this.readRevisionMetadataAction = this.getActionNode(namespace, config.getConfiguration("read-revision-metadata").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.readRevisionMetadataAction = this.defaultAction;
        }
        try {
            this.createRevisionMetadataAction = this.getActionNode(namespace, config.getConfiguration("create-revision-metadata").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.createRevisionMetadataAction = this.defaultAction;
        }
        try {
            this.modifyRevisionMetadataAction = this.getActionNode(namespace, config.getConfiguration("modify-revision-metadata").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.modifyRevisionMetadataAction = this.defaultAction;
        }
        try {
            this.removeRevisionMetadataAction = this.getActionNode(namespace, config.getConfiguration("remove-revision-metadata").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.removeRevisionMetadataAction = this.defaultAction;
        }
        try {
            this.readRevisionContentAction = this.getActionNode(namespace, config.getConfiguration("read-revision-content").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.readRevisionContentAction = this.defaultAction;
        }
        try {
            this.createRevisionContentAction = this.getActionNode(namespace, config.getConfiguration("create-revision-content").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.createRevisionContentAction = this.defaultAction;
        }
        try {
            this.modifyRevisionContentAction = this.getActionNode(namespace, config.getConfiguration("modify-revision-content").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.modifyRevisionContentAction = this.defaultAction;
        }
        try {
            this.removeRevisionContentAction = this.getActionNode(namespace, config.getConfiguration("remove-revision-content").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.removeRevisionContentAction = this.defaultAction;
        }
        try {
            this.usersPath = config.getConfiguration("userspath").getValue();
        }
        catch (ConfigurationException configurationException) {
            this.usersPath = "";
        }
        try {
            this.guestPath = config.getConfiguration("guestpath").getValue();
        }
        catch (ConfigurationException configurationException) {
            this.guestPath = "";
        }
        try {
            this.filesPath = config.getConfiguration("filespath").getValue();
        }
        catch (ConfigurationException configurationException) {
            this.filesPath = "";
        }
        try {
            this.autoCreateUsers = Boolean.valueOf(config.getConfiguration("auto-create-users").getValue());
        }
        catch (ConfigurationException configurationException) {
            this.autoCreateUsers = false;
        }
        try {
            this.autoCreateUsersRole = config.getConfiguration("auto-create-users-role").getValue();
        }
        catch (ConfigurationException configurationException) {}
        this.parameters = new Hashtable();
        Enumeration parametersDef = config.getConfigurations("parameter");
        try {
            while (parametersDef.hasMoreElements()) {
                Configuration parameter = (Configuration)parametersDef.nextElement();
                this.addParameter(parameter.getAttribute("name"), parameter.getValue());
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
        this.addRoleMapping(NOBODY, NOBODY_ROLE);
        this.addRoleMapping(NOBODY, LINK_ROLE);
        this.addRoleMapping(NOBODY, ACTION_ROLE);
        this.addRoleMapping(NOBODY, BASE_ROLE);
        Enumeration roleMappingsDef = config.getConfigurations("role");
        try {
            while (roleMappingsDef.hasMoreElements()) {
                Configuration roleMappingDef = (Configuration)roleMappingsDef.nextElement();
                this.addRoleMapping(roleMappingDef.getAttribute("name"), roleMappingDef.getValue());
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
        this.defaultProperties = new Hashtable();
        Enumeration defaultPropertiesDef = config.getConfigurations("default-property");
        try {
            while (defaultPropertiesDef.hasMoreElements()) {
                Configuration defaultProperty = (Configuration)defaultPropertiesDef.nextElement();
                String name = defaultProperty.getAttribute("name");
                String value = defaultProperty.getAttribute("value", "");
                String propertyNamespace = defaultProperty.getAttribute("namespace", "DAV:");
                String role = defaultProperty.getAttribute("role");
                this.addDefaultProperty(role, name, value, propertyNamespace);
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
        Enumeration contentInteceptorsDef = config.getConfigurations("content-interceptor");
        try {
            block59: while (true) {
                if (!contentInteceptorsDef.hasMoreElements()) break;
                Configuration contentInterceptorDef = (Configuration)contentInteceptorsDef.nextElement();
                String classname = contentInterceptorDef.getAttribute("class");
                Enumeration contentInterceptorParametersDef = contentInterceptorDef.getConfigurations("parameter");
                Hashtable<String, String> contentInterceptorParameters = new Hashtable<String, String>();
                while (true) {
                    if (!contentInterceptorParametersDef.hasMoreElements()) {
                        try {
                            Class<?> contentInterceptorClass = Class.forName(classname);
                            ContentInterceptor contentInterceptor = (ContentInterceptor)contentInterceptorClass.newInstance();
                            contentInterceptor.setParameters(contentInterceptorParameters);
                            ContentInterceptor[] tempArray = new ContentInterceptor[this.contentInterceptors.length + 1];
                            int i = 0;
                            while (true) {
                                if (i >= this.contentInterceptors.length) {
                                    tempArray[this.contentInterceptors.length] = contentInterceptor;
                                    this.contentInterceptors = tempArray;
                                    continue block59;
                                }
                                tempArray[i] = this.contentInterceptors[i];
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            namespace.getLogger().log(Messages.format("org.apache.slide.common.InvalidContentInterceptor", classname, e.getMessage()), 4);
                            continue block59;
                        }
                    }
                    Configuration parameterDefinition = (Configuration)contentInterceptorParametersDef.nextElement();
                    String parameterName = parameterDefinition.getAttribute("name");
                    String parameterValue = parameterDefinition.getValue();
                    contentInterceptorParameters.put(parameterName, parameterValue);
                }
                break;
            }
            NamespaceAccessTokenImpl nat = new NamespaceAccessTokenImpl(namespace);
            ContentInterceptor[] contentInterceptors = namespace.getContentInterceptors();
            int i = 0;
            while (true) {
                if (i >= contentInterceptors.length) {
                    return;
                }
                contentInterceptors[i].setNamespace(nat);
                ++i;
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
    }

    void initializeNamespaceParameters(Namespace namespace, Configuration config) throws InvalidNamespaceConfigurationException, SlideException {
        this.parameters = new Hashtable();
        Enumeration parametersDef = config.getConfigurations("parameter");
        try {
            while (parametersDef.hasMoreElements()) {
                Configuration parameter = (Configuration)parametersDef.nextElement();
                this.addParameter(parameter.getAttribute("name"), parameter.getValue());
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
        this.addRoleMapping(NOBODY, NOBODY_ROLE);
        this.addRoleMapping(NOBODY, LINK_ROLE);
        this.addRoleMapping(NOBODY, ACTION_ROLE);
        this.addRoleMapping(NOBODY, BASE_ROLE);
        Enumeration roleMappingsDef = config.getConfigurations("role");
        try {
            while (roleMappingsDef.hasMoreElements()) {
                Configuration roleMappingDef = (Configuration)roleMappingsDef.nextElement();
                this.addRoleMapping(roleMappingDef.getAttribute("name"), roleMappingDef.getValue());
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
        this.defaultProperties = new Hashtable();
        Enumeration defaultPropertiesDef = config.getConfigurations("default-property");
        try {
            while (defaultPropertiesDef.hasMoreElements()) {
                Configuration defaultProperty = (Configuration)defaultPropertiesDef.nextElement();
                String name = defaultProperty.getAttribute("name");
                String value = defaultProperty.getAttribute("value", "");
                String propertyNamespace = defaultProperty.getAttribute("namespace", "DAV:");
                String role = defaultProperty.getAttribute("role");
                this.addDefaultProperty(role, name, value, propertyNamespace);
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
    }

    public boolean isAutoCreateUsers() {
        return this.autoCreateUsers;
    }

    public String toString() {
        return this.name;
    }
}

