/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideRuntimeException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.UnknownObjectClassException;
import org.apache.slide.common.XMLMarshaller;
import org.apache.slide.common.XMLUnmarshaller;
import org.apache.slide.content.Content;
import org.apache.slide.content.ContentImpl;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.LockImpl;
import org.apache.slide.macro.Macro;
import org.apache.slide.macro.MacroImpl;
import org.apache.slide.search.Search;
import org.apache.slide.search.SearchImpl;
import org.apache.slide.security.Security;
import org.apache.slide.security.SecurityImpl;
import org.apache.slide.security.SecurityImplAllGrant;
import org.apache.slide.structure.Structure;
import org.apache.slide.structure.StructureImpl;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationElement;
import org.apache.slide.util.conf.ConfigurationException;
import org.apache.slide.util.conf.Populate;
import org.apache.slide.util.logger.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class NamespaceAccessTokenImpl
implements NamespaceAccessToken {
    private static String ACL_SEMANTICS = "acl_semantics";
    private static String ALL_GRANT_BEFORE_DENY = "all-grant-before-any-deny";
    private static String LEGACY_ALL_GRANT_BEFORE_DENY = "legacy-all-grant-before-any-deny";
    Namespace namespace;
    private Structure structureHelper;
    private Content contentHelper;
    private Lock lockHelper;
    private Search searchHelper;
    private Security securityHelper;
    private Macro macroHelper;

    NamespaceAccessTokenImpl(Namespace namespace) {
        String acl_syntax;
        this.namespace = namespace;
        NamespaceConfig config = namespace.getConfig();
        this.securityHelper = config != null ? ((acl_syntax = config.getParameter(ACL_SEMANTICS)) != null && acl_syntax.equals(LEGACY_ALL_GRANT_BEFORE_DENY) ? new SecurityImpl(namespace, namespace.getConfig()) : new SecurityImplAllGrant(namespace, namespace.getConfig())) : new SecurityImplAllGrant(namespace, namespace.getConfig());
        this.lockHelper = new LockImpl(namespace, namespace.getConfig(), this.securityHelper);
        this.structureHelper = new StructureImpl(namespace, namespace.getConfig(), this.securityHelper, this.lockHelper);
        this.contentHelper = new ContentImpl(namespace, namespace.getConfig(), this.securityHelper, this.structureHelper, this.lockHelper);
        this.searchHelper = new SearchImpl(namespace, namespace.getConfig(), this.structureHelper, this.contentHelper);
        this.macroHelper = new MacroImpl(namespace, namespace.getConfig(), this.securityHelper, this.contentHelper, this.structureHelper, this.lockHelper);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.namespace.getTransactionManager().begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.namespace.getTransactionManager().commit();
    }

    public void disconnect() {
        try {
            this.namespace.disconnectServices();
        }
        catch (SlideException e) {
            e.printStackTrace();
        }
    }

    public void exportData(SlideToken token, Writer writer) throws SlideException {
        this.exportData(token, writer, "/");
    }

    public void exportData(SlideToken token, Writer writer, String startNode) throws SlideException {
        XMLMarshaller.marshal(this, token, writer, startNode);
    }

    public Content getContentHelper() {
        return this.contentHelper;
    }

    public Lock getLockHelper() {
        return this.lockHelper;
    }

    public Logger getLogger() {
        return this.namespace.getApplicationLogger();
    }

    public Macro getMacroHelper() {
        return this.macroHelper;
    }

    public String getName() {
        return this.namespace.getName();
    }

    public NamespaceConfig getNamespaceConfig() {
        return this.namespace.getConfig();
    }

    public Search getSearchHelper() {
        return this.searchHelper;
    }

    public Security getSecurityHelper() {
        return this.securityHelper;
    }

    public int getStatus() throws SystemException {
        return this.namespace.getTransactionManager().getStatus();
    }

    public Structure getStructureHelper() {
        return this.structureHelper;
    }

    public void importData(SlideToken token, Reader reader) throws ConfigurationException, UnknownObjectClassException, ServiceAccessException, SAXException, IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            Populate pop = new Populate();
            ConfigurationElement configuration = new ConfigurationElement(pop.load(new InputSource(reader), parser.getXMLReader()));
            this.importData(token, configuration);
        }
        catch (FactoryConfigurationError e) {
            throw new SlideRuntimeException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new SlideRuntimeException(e.getMessage());
        }
    }

    public void importData(SlideToken token, Configuration dataConfiguration) throws ConfigurationException, UnknownObjectClassException, ServiceAccessException {
        XMLUnmarshaller.unmarshal(this, token, dataConfiguration);
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        this.namespace.getTransactionManager().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.namespace.getTransactionManager().setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.namespace.getTransactionManager().setTransactionTimeout(seconds);
    }
}

