/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Scope;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.util.logger.Logger;

public abstract class AbstractServiceBase
implements Service {
    protected String LOG_CHANNEL = this.getClass().getName();
    protected Namespace namespace;
    protected Scope scope;

    public boolean cacheResults() {
        return true;
    }

    public abstract void commit(Xid var1, boolean var2) throws XAException;

    public abstract void connect() throws ServiceConnectionFailedException;

    public void connect(CredentialsToken crdtoken) throws ServiceConnectionFailedException {
        this.connect();
    }

    public boolean connectIfNeeded() throws ServiceConnectionFailedException, ServiceAccessException {
        boolean result = true;
        try {
            result = this.isConnected() ^ true;
        }
        catch (ServiceAccessException serviceAccessException) {}
        if (result) {
            this.connect();
        }
        return result;
    }

    public boolean connectIfNeeded(CredentialsToken token) throws ServiceConnectionFailedException, ServiceAccessException {
        boolean result = true;
        try {
            result = this.isConnected() ^ true;
        }
        catch (ServiceAccessException serviceAccessException) {}
        if (result) {
            this.connect(token);
        }
        return result;
    }

    public abstract void disconnect() throws ServiceDisconnectionFailedException;

    public abstract void end(Xid var1, int var2) throws XAException;

    public abstract void forget(Xid var1) throws XAException;

    public Logger getLogger() {
        Logger logger = this.namespace.getLogger();
        if (logger == null) {
            logger = Domain.getLogger();
        }
        return logger;
    }

    public abstract int getTransactionTimeout() throws XAException;

    public void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
    }

    public abstract boolean isConnected() throws ServiceAccessException;

    public abstract boolean isSameRM(XAResource var1) throws XAException;

    public abstract int prepare(Xid var1) throws XAException;

    public abstract Xid[] recover(int var1) throws XAException;

    public abstract void reset() throws ServiceResetFailedException;

    public abstract void rollback(Xid var1) throws XAException;

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public abstract void setParameters(Hashtable var1) throws ServiceParameterErrorException, ServiceParameterMissingException;

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public abstract boolean setTransactionTimeout(int var1) throws XAException;

    public abstract void start(Xid var1, int var2) throws XAException;
}

