/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DocletTag
implements Serializable {
    private String name;
    private String value;
    private String[] parameters;
    private Map namedParameters;
    private String[] quotes = new String[]{"\"", "'"};

    public DocletTag(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String[] getParameters() {
        if (this.parameters == null) {
            ArrayList<String> paramsList = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(this.value);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                int i = 0;
                while (i < this.quotes.length) {
                    String quote = this.quotes[i];
                    if (token.indexOf(quote) != -1) {
                        while (!token.endsWith(quote)) {
                            if (!tokens.hasMoreTokens()) continue;
                            token = token + " " + tokens.nextToken();
                        }
                        break;
                    }
                    ++i;
                }
                paramsList.add(token);
            }
            this.parameters = new String[paramsList.size()];
            paramsList.toArray(this.parameters);
        }
        return this.parameters;
    }

    public String getNamedParameter(String key) {
        if (this.namedParameters == null) {
            this.namedParameters = new HashMap();
            String[] params = this.getParameters();
            int i = 0;
            while (i < params.length) {
                String param = params[i];
                int eq = param.indexOf(61);
                if (eq > -1) {
                    String k = param.substring(0, eq);
                    String v = param.substring(eq + 1);
                    v = this.trim(v, this.quotes);
                    if (k.length() > 0) {
                        this.namedParameters.put(k, v);
                    }
                }
                ++i;
            }
        }
        return (String)this.namedParameters.get(key);
    }

    private String trim(String value, String[] strings) {
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            while (value.startsWith(string)) {
                value = value.substring(string.length(), value.length());
            }
            while (value.endsWith(string)) {
                value = value.substring(0, value.length() - string.length());
            }
            ++i;
        }
        return value;
    }
}

