/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox;

import com.thoughtworks.qdox.Searcher;
import com.thoughtworks.qdox.directorywalker.DirectoryScanner;
import com.thoughtworks.qdox.directorywalker.FileVisitor;
import com.thoughtworks.qdox.directorywalker.SuffixFilter;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassCache;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.ModelBuilder;
import com.thoughtworks.qdox.parser.impl.JFlexLexer;
import com.thoughtworks.qdox.parser.impl.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JavaDocBuilder
implements Serializable,
JavaClassCache {
    private Map classes = new HashMap();
    private ClassLibrary classLibrary;
    private List sources = new ArrayList();

    public JavaDocBuilder() {
        this.classLibrary = new ClassLibrary(this);
        this.classLibrary.addDefaultLoader();
    }

    private void addClasses(JavaSource source) {
        JavaClass[] javaClasses = source.getClasses();
        int classIndex = 0;
        while (classIndex < javaClasses.length) {
            JavaClass cls = javaClasses[classIndex];
            this.classes.put(cls.getFullyQualifiedName(), cls);
            cls.setJavaClassCache(this);
            ++classIndex;
        }
    }

    public JavaClass getClassByName(String name) {
        return (JavaClass)this.classes.get(name);
    }

    public JavaSource addSource(Reader reader) {
        ModelBuilder builder = new ModelBuilder(this.classLibrary);
        JFlexLexer lexer = new JFlexLexer(reader);
        Parser parser = new Parser(lexer, builder);
        parser.parse();
        JavaSource source = builder.getSource();
        this.sources.add(source);
        this.addClasses(source);
        return source;
    }

    public void addSource(File file) throws FileNotFoundException {
        JavaSource source = this.addSource(new FileReader(file));
        source.setFile(file);
    }

    public JavaSource[] getSources() {
        return this.sources.toArray(new JavaSource[this.sources.size()]);
    }

    public void addSourceTree(File file) {
        DirectoryScanner scanner = new DirectoryScanner(file);
        scanner.addFilter(new SuffixFilter(".java"));
        scanner.scan(new FileVisitor(){

            public void visitFile(File currentFile) {
                try {
                    JavaDocBuilder.this.addSource(currentFile);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Cannot read file : " + currentFile.getName());
                }
            }
        });
    }

    public List search(Searcher searcher) {
        LinkedList<JavaClass> results = new LinkedList<JavaClass>();
        Iterator iterator = this.classLibrary.all().iterator();
        while (iterator.hasNext()) {
            String clsName = (String)iterator.next();
            JavaClass cls = this.getClassByName(clsName);
            if (!searcher.eval(cls)) continue;
            results.add(cls);
        }
        return results;
    }

    public ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        try {
            out.writeObject(this);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            out.close();
            fos.close();
            throw throwable;
        }
        out.close();
        fos.close();
    }

    public static JavaDocBuilder load(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream in = new ObjectInputStream(fis);
        JavaDocBuilder builder = null;
        try {
            try {
                builder = (JavaDocBuilder)in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new Error("Couldn't load class : " + e.getMessage());
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            in.close();
            fis.close();
            throw throwable;
        }
        in.close();
        fis.close();
        return builder;
    }
}

