/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.IOException;
import java.io.InputStream;
import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.Convert;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.Report;
import net.sf.pizzacompiler.compiler.Switches;
import net.sf.pizzacompiler.pizzadoc.DocCollector;

class Scanner
implements Constants {
    static final int tabinc = 8;
    static final byte LF = 10;
    static final byte FF = 12;
    static final byte CR = 13;
    static final byte SUB = 26;
    private static int maxKey = 0;
    private static byte[] key;
    private static int standardMaxKey;
    private static int extendedMaxKey;
    int token;
    int pos = 0;
    int lastpos = 0;
    Name name;
    long intVal;
    double floatVal;
    boolean deprecatedFlag = false;
    int errPos = -1;
    private byte[] buf;
    private int bp;
    private byte ch;
    private int cline;
    private int ccol;
    private byte[] lit = new byte[64];
    private int litlen;
    private static Name slashS;
    private static Name slashEqualsS;
    private boolean docComment = false;
    private static Name[] tokenName;

    Scanner(InputStream inputStream) {
        try {
            this.buf = new byte[inputStream.available() + 1];
            if (inputStream.read(this.buf) != this.buf.length - 1) {
                throw new IOException("read error");
            }
        }
        catch (IOException iOException) {
            this.lexError(iOException.toString());
            this.buf = new byte[1];
        }
        if (this.buf.length == 0 || this.buf[this.buf.length - 1] > 32) {
            byte[] byArray = new byte[this.buf.length + 1];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
        }
        this.buf[this.buf.length - 1] = 26;
        this.bp = 0;
        this.cline = 1;
        this.ccol = 1;
        this.ch = this.buf[0];
        this.nexttoken();
        maxKey = Switches.pizza ? extendedMaxKey : standardMaxKey;
    }

    private void dch() {
        System.out.print((char)this.ch);
        System.out.flush();
    }

    private void lexError(String string, int n) {
        Report.error(n, string);
        this.token = 113;
        this.errPos = n;
    }

    private void lexError(String string) {
        this.lexError(string, this.pos);
    }

    private void putch(byte by) {
        if (this.litlen == this.lit.length) {
            byte[] byArray = new byte[this.lit.length * 2];
            System.arraycopy(this.lit, 0, byArray, 0, this.lit.length);
            this.lit = byArray;
        }
        this.lit[this.litlen++] = by;
    }

    private boolean isUnicode() {
        return this.bp + 6 < this.buf.length && this.buf[this.bp] == 92 && this.buf[this.bp + 1] == 117 && Convert.digit2int(this.buf[this.bp + 2], 16) >= 0 && Convert.digit2int(this.buf[this.bp + 3], 16) >= 0 && Convert.digit2int(this.buf[this.bp + 4], 16) >= 0 && Convert.digit2int(this.buf[this.bp + 5], 16) >= 0;
    }

    private void getlitch() {
        if (this.ch == 92) {
            if (this.isUnicode()) {
                this.putch(this.ch);
                this.ch = this.buf[++this.bp];
                ++this.ccol;
                this.putch(this.ch);
                this.ch = this.buf[++this.bp];
                ++this.ccol;
                this.putch(this.ch);
                this.ch = this.buf[++this.bp];
                ++this.ccol;
                this.putch(this.ch);
                this.ch = this.buf[++this.bp];
                ++this.ccol;
                this.putch(this.ch);
                this.ch = this.buf[++this.bp];
                ++this.ccol;
                this.putch(this.ch);
                this.ch = this.buf[++this.bp];
                ++this.ccol;
            } else {
                this.ch = this.buf[++this.bp];
                ++this.ccol;
                if (48 <= this.ch && this.ch <= 55) {
                    byte by = this.ch;
                    int n = Convert.digit2int(this.ch, 8);
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    if (48 <= this.ch && this.ch <= 55) {
                        n = n * 8 + Convert.digit2int(this.ch, 8);
                        this.ch = this.buf[++this.bp];
                        ++this.ccol;
                        if (by <= 51 && 48 <= this.ch && this.ch <= 55) {
                            n = n * 8 + Convert.digit2int(this.ch, 8);
                            this.ch = this.buf[++this.bp];
                            ++this.ccol;
                        }
                    }
                    this.putch((byte)n);
                } else if (this.ch != 26) {
                    switch (this.ch) {
                        case 34: 
                        case 39: 
                        case 92: 
                        case 98: 
                        case 102: 
                        case 110: 
                        case 114: 
                        case 116: {
                            this.putch((byte)92);
                            this.putch(this.ch);
                            break;
                        }
                        default: {
                            this.lexError("invalid escape character", (this.cline << 10) + this.ccol - 1);
                            this.putch(this.ch);
                        }
                    }
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                }
            }
        } else if (this.ch != 26) {
            this.putch(this.ch);
            this.ch = this.buf[++this.bp];
            ++this.ccol;
        }
    }

    private void getfraction(int n) {
        while (Convert.digit2int(this.ch, 10) >= 0) {
            this.ch = this.buf[++this.bp];
            ++this.ccol;
        }
        this.token = 7;
        if (this.ch == 101 || this.ch == 69) {
            this.ch = this.buf[++this.bp];
            ++this.ccol;
            if (this.ch == 43 || this.ch == 45) {
                byte by = this.ch;
                this.ch = this.buf[++this.bp];
                ++this.ccol;
                if (48 > this.ch || this.ch > 57) {
                    this.ch = by;
                    --this.bp;
                    --this.ccol;
                }
            }
            while (Convert.digit2int(this.ch, 10) >= 0) {
                this.ch = this.buf[++this.bp];
                ++this.ccol;
            }
        }
        double d = Double.MAX_VALUE;
        int n2 = this.bp - n;
        if (this.ch == 100 || this.ch == 68) {
            this.ch = this.buf[++this.bp];
            ++this.ccol;
        } else if (this.ch == 102 || this.ch == 70) {
            this.token = 6;
            d = 3.4028234663852886E38;
            this.ch = this.buf[++this.bp];
            ++this.ccol;
        }
        try {
            this.floatVal = Double.valueOf(new String(this.buf, 0, n, this.bp - n));
            if (this.floatVal > d) {
                this.lexError("floating point number too large");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.lexError("malformed floating point number");
        }
    }

    private void makeint(int n, int n2, int n3, long l) {
        this.intVal = 0L;
        int n4 = n3 == 10 ? 1 : 2;
        for (int i = 0; i < n2; ++i) {
            int n5 = Convert.digit2int(this.buf[n + i], n3);
            if (n5 < 0) {
                this.lexError("malformed integer number");
                return;
            }
            if (this.intVal < 0L || l / (long)(n3 / n4) < this.intVal || l - (long)(n5 / n4) < this.intVal * (long)(n3 / n4) - (this.token == 107 ? 1L : 0L)) {
                this.lexError("integer number too large");
                return;
            }
            this.intVal = this.intVal * (long)n3 + (long)n5;
        }
    }

    private void getnumber(int n, int n2) {
        while (Convert.digit2int(this.ch, n2 == 8 ? 10 : n2) >= 0) {
            this.ch = this.buf[++this.bp];
            ++this.ccol;
        }
        if (n2 <= 10 && this.ch == 46) {
            this.ch = this.buf[++this.bp];
            ++this.ccol;
            this.getfraction(n);
        } else if (n2 <= 10 && (this.ch == 101 || this.ch == 69 || this.ch == 102 || this.ch == 70 || this.ch == 100 || this.ch == 68)) {
            this.getfraction(n);
        } else if (this.ch == 108 || this.ch == 76) {
            this.makeint(n, this.bp - n, n2, Long.MAX_VALUE);
            this.ch = this.buf[++this.bp];
            ++this.ccol;
            this.token = 5;
        } else {
            this.makeint(n, this.bp - n, n2, Integer.MAX_VALUE);
            this.intVal = (int)this.intVal;
            this.token = 4;
        }
    }

    private boolean isspecial(byte by) {
        switch (by) {
            case 33: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 94: 
            case 124: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    private void getspecials() {
        int n = this.bp;
        this.name = Name.fromAscii(this.buf, n, 1);
        while (true) {
            this.token = key[this.name.index];
            this.ch = this.buf[++this.bp];
            ++this.ccol;
            if (!this.isspecial(this.ch)) break;
            Name name = Name.fromAscii(this.buf, n, this.bp + 1 - n);
            if (name.index > maxKey || key[name.index] == 1) break;
            this.name = name;
        }
    }

    static boolean scan4deprecated(byte[] byArray, int n, int n2) {
        int n3 = n + 1;
        byte by = byArray[n3];
        boolean bl = true;
        while (n3 < n + n2 - 1 && (by == 32 || by == 9 || by == 42)) {
            by = byArray[++n3];
        }
        block6: while (n3 < n + n2 - 1) {
            switch (by) {
                case 10: 
                case 13: {
                    by = byArray[++n3];
                    if (by == 10) {
                        by = byArray[++n3];
                    }
                    while (by == 32 || by == 9) {
                        by = byArray[++n3];
                    }
                    if (by == 42) {
                        while (by == 42) {
                            by = byArray[++n3];
                        }
                        while (by == 32 || by == 9) {
                            by = byArray[++n3];
                        }
                    }
                    bl = true;
                    if (by != 64) break;
                }
                case 64: {
                    by = byArray[++n3];
                    if (!bl) continue block6;
                    bl = false;
                    if (by != 100 || (by = byArray[++n3]) != 101 || (by = byArray[++n3]) != 112 || (by = byArray[++n3]) != 114 || (by = byArray[++n3]) != 101 || (by = byArray[++n3]) != 99 || (by = byArray[++n3]) != 97 || (by = byArray[++n3]) != 116 || (by = byArray[++n3]) != 101 || (by = byArray[++n3]) != 100) break;
                    if ((by = byArray[++n3]) != 32 && by != 9 && by != 13 && by != 10) continue block6;
                    return true;
                }
                case 9: 
                case 32: {
                    by = byArray[++n3];
                    break;
                }
                default: {
                    by = byArray[++n3];
                    bl = false;
                }
            }
        }
        return false;
    }

    void nexttoken() {
        this.lastpos = (this.cline << 10) + this.ccol;
        block27: while (true) {
            boolean bl = false;
            this.pos = (this.cline << 10) + this.ccol;
            int n = this.bp++;
            switch (this.ch) {
                case 32: {
                    this.ch = this.buf[this.bp];
                    ++this.ccol;
                    break;
                }
                case 9: {
                    this.ccol = (this.ccol - 1) / 8 * 8 + 8;
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    break;
                }
                case 13: {
                    ++this.cline;
                    this.ccol = 0;
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    if (this.ch != 10) continue block27;
                    this.ccol = 0;
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    break;
                }
                case 10: 
                case 12: {
                    ++this.cline;
                    this.ccol = 0;
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    break;
                }
                case 92: {
                    if (!this.isUnicode()) {
                        this.ch = this.buf[++this.bp];
                        ++this.ccol;
                        this.lexError("illegal character");
                        return;
                    }
                    bl = true;
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.ch = (byte)65;
                }
                case 36: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    block28: while (true) {
                        this.ch = this.buf[++this.bp];
                        ++this.ccol;
                        switch (this.ch) {
                            case 36: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 95: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: {
                                continue block28;
                            }
                            case 92: {
                                if (!this.isUnicode()) {
                                    this.ch = this.buf[++this.bp];
                                    ++this.ccol;
                                    this.lexError("illegal character");
                                    return;
                                }
                                bl = true;
                                this.ch = this.buf[++this.bp];
                                ++this.ccol;
                                this.ch = this.buf[++this.bp];
                                ++this.ccol;
                                this.ch = this.buf[++this.bp];
                                ++this.ccol;
                                this.ch = this.buf[++this.bp];
                                ++this.ccol;
                                this.ch = this.buf[++this.bp];
                                ++this.ccol;
                                continue block28;
                            }
                        }
                        if (this.ch >= 0) break;
                    }
                    this.name = bl ? Name.fromSource(this.buf, n, this.bp - n) : Name.fromAscii(this.buf, n, this.bp - n);
                    this.token = this.name.index <= maxKey ? key[this.name.index] : 1;
                    return;
                }
                case 48: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    if (this.ch == 120 || this.ch == 88) {
                        this.ch = this.buf[++this.bp];
                        ++this.ccol;
                        this.getnumber(n + 2, 16);
                    } else {
                        this.getnumber(n, 8);
                    }
                    return;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.getnumber(n, 10);
                    return;
                }
                case 46: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    if (48 <= this.ch && this.ch <= 57) {
                        this.getfraction(n);
                    } else {
                        this.token = 10;
                    }
                    return;
                }
                case 44: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.token = 11;
                    return;
                }
                case 59: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.token = 12;
                    return;
                }
                case 40: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.token = 13;
                    return;
                }
                case 41: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.token = 14;
                    return;
                }
                case 91: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.token = 15;
                    return;
                }
                case 93: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.token = 16;
                    return;
                }
                case 123: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.token = 17;
                    return;
                }
                case 125: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.token = 18;
                    return;
                }
                case 47: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    if (this.ch == 47) {
                        do {
                            this.ch = this.buf[++this.bp];
                            ++this.ccol;
                            if (this.ch == 13 || this.ch == 10) continue block27;
                        } while (this.ch != 26);
                        break;
                    }
                    if (this.ch == 42) {
                        this.ch = this.buf[++this.bp];
                        ++this.ccol;
                        if (this.ch == 42) {
                            this.docComment = true;
                        }
                        while (true) {
                            if (this.ch == 13) {
                                ++this.cline;
                                this.ccol = 0;
                                this.ch = this.buf[++this.bp];
                                ++this.ccol;
                                if (this.ch == 10) {
                                    this.ccol = 0;
                                    this.ch = this.buf[++this.bp];
                                    ++this.ccol;
                                }
                            } else if (this.ch == 10) {
                                ++this.cline;
                                this.ccol = 0;
                                this.ch = this.buf[++this.bp];
                                ++this.ccol;
                            } else if (this.ch == 9) {
                                this.ccol = (this.ccol - 1) / 8 * 8 + 8;
                                this.ch = this.buf[++this.bp];
                                ++this.ccol;
                            } else {
                                this.ch = this.buf[++this.bp];
                                ++this.ccol;
                            }
                            if (this.ch != 42 && this.ch != 26) continue;
                            while (this.ch == 42) {
                                this.ch = this.buf[++this.bp];
                                ++this.ccol;
                            }
                            if (this.ch == 47 || this.ch == 26) break;
                        }
                        if (this.ch == 47) {
                            if (this.docComment) {
                                this.deprecatedFlag = Switches.pizzadoc ? DocCollector.comment((this.cline << 10) + this.ccol, this.buf, n, this.bp - n) : Scanner.scan4deprecated(this.buf, n, this.bp - n);
                                this.docComment = false;
                            }
                            this.ch = this.buf[++this.bp];
                            ++this.ccol;
                            break;
                        }
                        this.lexError("unclosed comment");
                        return;
                    }
                    if (this.ch == 61) {
                        this.name = slashEqualsS;
                        this.token = 47;
                        this.ch = this.buf[++this.bp];
                        ++this.ccol;
                    } else {
                        this.name = slashS;
                        this.token = 29;
                    }
                    return;
                }
                case 39: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.litlen = 0;
                    this.getlitch();
                    if (this.ch == 39) {
                        this.ch = this.buf[++this.bp];
                        ++this.ccol;
                        this.token = 2;
                        byte[] byArray = new byte[this.litlen * 2];
                        int n2 = Convert.source2ascii(this.lit, 0, this.litlen, byArray);
                        this.intVal = n2 > 0 ? (long)Convert.ascii2string(byArray, 0, n2).charAt(0) : 0L;
                    } else {
                        this.lexError("unclosed character literal");
                    }
                    return;
                }
                case 34: {
                    this.ch = this.buf[++this.bp];
                    ++this.ccol;
                    this.litlen = 0;
                    while (this.ch != 34 && this.ch != 13 && this.ch != 10 && this.ch != 26) {
                        this.getlitch();
                    }
                    if (this.ch == 34) {
                        this.token = 3;
                        this.name = Name.fromSource(this.lit, 0, this.litlen);
                        this.ch = this.buf[++this.bp];
                        ++this.ccol;
                    } else {
                        this.lexError("unclosed character literal", (this.cline << 10) + this.ccol);
                    }
                    return;
                }
                case 26: {
                    this.token = 114;
                    return;
                }
                default: {
                    if (this.isspecial(this.ch)) {
                        this.getspecials();
                    } else {
                        this.ch = this.buf[++this.bp];
                        ++this.ccol;
                        this.lexError("illegal character");
                    }
                    return;
                }
            }
        }
    }

    static int name2token(Name name) {
        if (name.index <= maxKey) {
            return key[name.index];
        }
        return 1;
    }

    String token2string(int n) {
        switch (n) {
            case 1: {
                return "<identifier>";
            }
            case 2: {
                return "<character>";
            }
            case 3: {
                return "<string>";
            }
            case 4: {
                return "<integer>";
            }
            case 5: {
                return "<long integer>";
            }
            case 6: {
                return "<float>";
            }
            case 7: {
                return "<double>";
            }
            case 10: {
                return "'.'";
            }
            case 11: {
                return "','";
            }
            case 12: {
                return "';'";
            }
            case 13: {
                return "'('";
            }
            case 14: {
                return "')'";
            }
            case 15: {
                return "'['";
            }
            case 16: {
                return "']'";
            }
            case 17: {
                return "'{'";
            }
            case 18: {
                return "'}'";
            }
            case 113: {
                return "<bad symbol>";
            }
            case 114: {
                return "<end of input>";
            }
        }
        return tokenName[n].toString();
    }

    private static void enterKeyword(String string, int n) {
        Name name;
        Scanner.tokenName[n] = name = Name.fromString(string);
        if (name.index > maxKey) {
            maxKey = name.index;
        }
    }

    static {
        slashS = Name.fromString("/");
        slashEqualsS = Name.fromString("/=");
        tokenName = new Name[117];
        for (int i = 0; i < 117; ++i) {
            Scanner.tokenName[i] = null;
        }
        Scanner.enterKeyword("+", 20);
        Scanner.enterKeyword("-", 21);
        Scanner.enterKeyword("!", 22);
        Scanner.enterKeyword("%", 23);
        Scanner.enterKeyword("^", 24);
        Scanner.enterKeyword("&", 25);
        Scanner.enterKeyword("*", 26);
        Scanner.enterKeyword("|", 27);
        Scanner.enterKeyword("~", 28);
        Scanner.enterKeyword("/", 29);
        Scanner.enterKeyword(">", 30);
        Scanner.enterKeyword("<", 31);
        Scanner.enterKeyword("?", 32);
        Scanner.enterKeyword(":", 33);
        Scanner.enterKeyword("=", 34);
        Scanner.enterKeyword("++", 35);
        Scanner.enterKeyword("--", 36);
        Scanner.enterKeyword("==", 37);
        Scanner.enterKeyword("<=", 38);
        Scanner.enterKeyword(">=", 39);
        Scanner.enterKeyword("!=", 40);
        Scanner.enterKeyword("<<", 41);
        Scanner.enterKeyword(">>", 42);
        Scanner.enterKeyword(">>>", 43);
        Scanner.enterKeyword("+=", 44);
        Scanner.enterKeyword("-=", 45);
        Scanner.enterKeyword("*=", 46);
        Scanner.enterKeyword("/=", 47);
        Scanner.enterKeyword("&=", 48);
        Scanner.enterKeyword("|=", 49);
        Scanner.enterKeyword("^=", 50);
        Scanner.enterKeyword("%=", 51);
        Scanner.enterKeyword("<<=", 52);
        Scanner.enterKeyword(">>=", 53);
        Scanner.enterKeyword(">>>=", 54);
        Scanner.enterKeyword("||", 55);
        Scanner.enterKeyword("&&", 56);
        Scanner.enterKeyword("abstract", 60);
        Scanner.enterKeyword("break", 61);
        Scanner.enterKeyword("case", 62);
        Scanner.enterKeyword("catch", 63);
        Scanner.enterKeyword("class", 64);
        Scanner.enterKeyword("const", 65);
        Scanner.enterKeyword("continue", 66);
        Scanner.enterKeyword("default", 67);
        Scanner.enterKeyword("do", 68);
        Scanner.enterKeyword("else", 69);
        Scanner.enterKeyword("extends", 70);
        Scanner.enterKeyword("final", 71);
        Scanner.enterKeyword("finally", 72);
        Scanner.enterKeyword("for", 73);
        Scanner.enterKeyword("goto", 112);
        Scanner.enterKeyword("if", 74);
        Scanner.enterKeyword("implements", 75);
        Scanner.enterKeyword("import", 76);
        Scanner.enterKeyword("interface", 77);
        Scanner.enterKeyword("native", 78);
        Scanner.enterKeyword("new", 79);
        Scanner.enterKeyword("package", 80);
        Scanner.enterKeyword("private", 81);
        Scanner.enterKeyword("protected", 82);
        Scanner.enterKeyword("public", 83);
        Scanner.enterKeyword("return", 84);
        Scanner.enterKeyword("static", 85);
        Scanner.enterKeyword("super", 86);
        Scanner.enterKeyword("switch", 87);
        Scanner.enterKeyword("synchronized", 88);
        Scanner.enterKeyword("this", 89);
        Scanner.enterKeyword("volatile", 90);
        Scanner.enterKeyword("throw", 91);
        Scanner.enterKeyword("throws", 92);
        Scanner.enterKeyword("transient", 93);
        Scanner.enterKeyword("try", 94);
        Scanner.enterKeyword("while", 95);
        Scanner.enterKeyword("instanceof", 96);
        Scanner.enterKeyword("boolean", 97);
        Scanner.enterKeyword("byte", 98);
        Scanner.enterKeyword("char", 99);
        Scanner.enterKeyword("double", 100);
        Scanner.enterKeyword("float", 101);
        Scanner.enterKeyword("int", 102);
        Scanner.enterKeyword("long", 103);
        Scanner.enterKeyword("short", 104);
        Scanner.enterKeyword("void", 105);
        Scanner.enterKeyword("null", 106);
        Scanner.enterKeyword("strictfp", 115);
        if (Switches.source14) {
            Scanner.enterKeyword("assert", 116);
        }
        standardMaxKey = maxKey;
        Scanner.enterKeyword("fun", 108);
        if (Switches.experimental) {
            Scanner.enterKeyword("seq", 109);
        }
        Scanner.enterKeyword("->", 110);
        Scanner.enterKeyword("_", 111);
        extendedMaxKey = maxKey;
        key = new byte[maxKey + 1];
        for (int i = 0; i <= maxKey; ++i) {
            Scanner.key[i] = 1;
        }
        for (int n = 0; n < 117; n = (int)((byte)(n + 1))) {
            if (tokenName[n] == null) continue;
            Scanner.key[Scanner.tokenName[n].index] = n;
        }
    }
}

