/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.pizzacompiler.compiler.Basic;
import net.sf.pizzacompiler.compiler.CompilerOutput;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.Report;
import net.sf.pizzacompiler.compiler.SourceReader;
import net.sf.pizzacompiler.compiler.Switches;

public class FileCompilerOutput
implements CompilerOutput {
    private File _outDir;

    public FileCompilerOutput(File file) {
        this._outDir = file;
    }

    public OutputStream getClassOutputStream(String string, String string2) throws IOException {
        File file = this.getOutputFile(string, string2, ".class");
        if (Switches.verbose) {
            System.out.println(String.valueOf(String.valueOf("[writing ").concat(String.valueOf(file.getPath()))).concat(String.valueOf("]")));
        }
        return new FileOutputStream(file);
    }

    public OutputStream getSourceOutputStream(String string, String string2, SourceReader sourceReader, int n) throws IOException {
        File file = this.getOutputFile(string, string2, ".java");
        if (sourceReader.haveRead(file)) {
            Report.error(n, String.valueOf("error writing source; cannot overwrite input file ").concat(String.valueOf(file)));
            return null;
        }
        if (Switches.verbose) {
            System.out.println(String.valueOf(String.valueOf("[writing ").concat(String.valueOf(file.getPath()))).concat(String.valueOf("]")));
        }
        return new FileOutputStream(file);
    }

    private File getOutputFile(String string, String string2, String string3) throws IOException {
        if (this._outDir == null) {
            return this.getSameDirectoryFile(string, string2, string3);
        }
        return this.getOutputDirFileAndMakeDirectories(string2, string3);
    }

    private File getSameDirectoryFile(String string, String string2, String string3) throws IOException {
        String string4 = String.valueOf(Basic.shortName(Name.fromString(string2))).concat(String.valueOf(string3));
        String string5 = new File(string).getParent();
        if (string5 == null) {
            return new File(string4);
        }
        return new File(string5, string4);
    }

    private File getOutputDirFileAndMakeDirectories(String string, String string2) throws IOException {
        File file = this._outDir;
        int n = 0;
        int n2 = string.indexOf(46);
        while (n2 >= n) {
            if (!(file = new File(file, string.substring(n, n2))).exists()) {
                file.mkdir();
            }
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        return new File(file, String.valueOf(string.substring(n)).concat(String.valueOf(string2)));
    }
}

