/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.altrmi.client.InvocationException;
import org.apache.excalibur.instrument.client.InstrumentClientFrame;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.LargeMenu;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentManagerClient;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentableDescriptor;

public class MenuBar
extends JMenuBar {
    protected InstrumentClientFrame m_frame;
    private JMenu m_menuFile;
    private JMenu m_menuInstrumentManagers;
    private JMenu m_menuOptions;
    private JCheckBoxMenuItem m_menuItemShowUnconfigured;
    private JMenu m_menuWindow;

    MenuBar(InstrumentClientFrame frame) {
        this.m_frame = frame;
        this.add(this.buildFileMenu());
        this.add(this.buildInstrumentManagerMenu());
        this.add(this.buildOptionsMenu());
        this.add(this.buildWindowMenu());
    }

    private JMenu buildFileMenu() {
        this.m_menuFile = new LargeMenu("File");
        this.m_menuFile.setMnemonic('F');
        AbstractAction newAction = new AbstractAction("New"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.fileNew();
            }
        };
        JMenuItem newItem = new JMenuItem(newAction);
        newItem.setMnemonic('N');
        this.m_menuFile.add(newItem);
        AbstractAction openAction = new AbstractAction("Open ..."){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.fileOpen();
            }
        };
        JMenuItem open = new JMenuItem(openAction);
        open.setMnemonic('O');
        this.m_menuFile.add(open);
        this.m_menuFile.addSeparator();
        AbstractAction saveAction = new AbstractAction("Save"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.fileSave();
            }
        };
        JMenuItem save = new JMenuItem(saveAction);
        save.setMnemonic('S');
        this.m_menuFile.add(save);
        AbstractAction saveAsAction = new AbstractAction("Save As ..."){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.fileSaveAs();
            }
        };
        JMenuItem saveAs = new JMenuItem(saveAsAction);
        saveAs.setMnemonic('A');
        this.m_menuFile.add(saveAs);
        this.m_menuFile.addSeparator();
        AbstractAction exitAction = new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.fileExit();
            }
        };
        JMenuItem exit = new JMenuItem(exitAction);
        exit.setMnemonic('X');
        this.m_menuFile.add(exit);
        return this.m_menuFile;
    }

    private JMenu buildInstrumentManagerMenu() {
        this.m_menuInstrumentManagers = new LargeMenu("Instrument Managers");
        this.m_menuInstrumentManagers.setMnemonic('I');
        this.m_menuInstrumentManagers.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent event) {
                MenuBar.this.rebuildInstrumentManagersMenu();
            }

            public void menuDeselected(MenuEvent event) {
            }

            public void menuCanceled(MenuEvent event) {
            }
        });
        return this.m_menuInstrumentManagers;
    }

    protected void rebuildInstrumentManagersMenu() {
        this.m_menuInstrumentManagers.removeAll();
        AbstractAction connectAction = new AbstractAction("Connect to Instrument Manager..."){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.showConnectDialog();
            }
        };
        JMenuItem connectItem = new JMenuItem(connectAction);
        connectItem.setMnemonic('C');
        this.m_menuInstrumentManagers.add(connectItem);
        InstrumentManagerConnection[] connections = this.m_frame.getInstrumentManagerConnections();
        if (connections.length > 0) {
            this.m_menuInstrumentManagers.addSeparator();
            int i = 0;
            while (i < connections.length) {
                InstrumentManagerConnection connection = connections[i];
                AbstractAction action = new AbstractAction(connection.getTitle()){

                    public void actionPerformed(ActionEvent event) {
                    }
                };
                action.putValue("InstrumentManagerConnection", connection);
                LargeMenu menu = new LargeMenu(action);
                menu.addMenuListener(new MenuListener(){

                    public void menuSelected(MenuEvent event) {
                        JMenu menu = (JMenu)event.getSource();
                        Action action = menu.getAction();
                        MenuBar.this.rebuildInstrumentManagerMenu(menu, (InstrumentManagerConnection)action.getValue("InstrumentManagerConnection"));
                    }

                    public void menuDeselected(MenuEvent event) {
                    }

                    public void menuCanceled(MenuEvent event) {
                    }
                });
                this.m_menuInstrumentManagers.add(menu);
                ++i;
            }
        }
    }

    protected void rebuildInstrumentManagerMenu(JMenu managerMenu, InstrumentManagerConnection connection) {
        block4: {
            managerMenu.removeAll();
            boolean showAll = this.m_menuItemShowUnconfigured.getState();
            AbstractAction deleteAction = new AbstractAction("Delete"){

                public void actionPerformed(ActionEvent event) {
                    JMenuItem item = (JMenuItem)event.getSource();
                    Action action = item.getAction();
                    InstrumentManagerConnection connection = (InstrumentManagerConnection)action.getValue("InstrumentManagerConnection");
                    connection.delete();
                }
            };
            deleteAction.putValue("InstrumentManagerConnection", connection);
            JMenuItem deleteItem = new JMenuItem(deleteAction);
            deleteItem.setMnemonic('I');
            managerMenu.add(deleteItem);
            try {
                InstrumentManagerClient manager2 = connection.getInstrumentManagerClient();
                if (manager2 == null) break block4;
                managerMenu.addSeparator();
                InstrumentableDescriptor[] descriptors = manager2.getInstrumentableDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    InstrumentableDescriptor descriptor = descriptors[i];
                    if (showAll || descriptor.isConfigured()) {
                        String description = descriptor.getDescription();
                        AbstractAction action = new AbstractAction(description){

                            public void actionPerformed(ActionEvent event) {
                            }
                        };
                        action.putValue("InstrumentManagerConnection", connection);
                        action.putValue("InstrumentableDescriptor", descriptor);
                        LargeMenu menu = new LargeMenu(action);
                        menu.addMenuListener(new MenuListener(){

                            public void menuSelected(MenuEvent event) {
                                JMenu menu = (JMenu)event.getSource();
                                Action action = menu.getAction();
                                MenuBar.this.rebuildInstrumentableMenu(menu, (InstrumentManagerConnection)action.getValue("InstrumentManagerConnection"), (InstrumentableDescriptor)action.getValue("InstrumentableDescriptor"));
                            }

                            public void menuDeselected(MenuEvent event) {
                            }

                            public void menuCanceled(MenuEvent event) {
                            }
                        });
                        managerMenu.add(menu);
                    }
                    ++i;
                }
            }
            catch (InvocationException e) {
                connection.close();
            }
        }
    }

    protected void rebuildInstrumentableMenu(JMenu instrumentableMenu, InstrumentManagerConnection connection, InstrumentableDescriptor instrumentableDescriptor) {
        instrumentableMenu.removeAll();
        boolean showAll = this.m_menuItemShowUnconfigured.getState();
        try {
            InstrumentDescriptor[] descriptors = instrumentableDescriptor.getInstrumentDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                InstrumentDescriptor descriptor = descriptors[i];
                if (showAll || descriptor.isConfigured()) {
                    String description = descriptor.getDescription();
                    AbstractAction action = new AbstractAction(description){

                        public void actionPerformed(ActionEvent event) {
                        }
                    };
                    action.putValue("InstrumentManagerConnection", connection);
                    action.putValue("InstrumentableDescriptor", instrumentableDescriptor);
                    action.putValue("InstrumentDescriptor", descriptor);
                    LargeMenu menu = new LargeMenu(action);
                    menu.addMenuListener(new MenuListener(){

                        public void menuSelected(MenuEvent event) {
                            JMenu menu = (JMenu)event.getSource();
                            Action action = menu.getAction();
                            MenuBar.this.rebuildInstrumentMenu(menu, (InstrumentManagerConnection)action.getValue("InstrumentManagerConnection"), (InstrumentableDescriptor)action.getValue("InstrumentableDescriptor"), (InstrumentDescriptor)action.getValue("InstrumentDescriptor"));
                        }

                        public void menuDeselected(MenuEvent event) {
                        }

                        public void menuCanceled(MenuEvent event) {
                        }
                    });
                    instrumentableMenu.add(menu);
                }
                ++i;
            }
        }
        catch (InvocationException e) {
            connection.close();
        }
    }

    protected void rebuildInstrumentMenu(JMenu instrumentMenu, InstrumentManagerConnection connection, InstrumentableDescriptor instrumentableDescriptor, InstrumentDescriptor instrumentDescriptor) {
        block4: {
            instrumentMenu.removeAll();
            boolean showAll = this.m_menuItemShowUnconfigured.getState();
            AbstractAction createAction = new AbstractAction("Create Sample..."){

                public void actionPerformed(ActionEvent event) {
                }
            };
            createAction.putValue("InstrumentManagerConnection", connection);
            createAction.putValue("InstrumentableDescriptor", instrumentableDescriptor);
            createAction.putValue("InstrumentDescriptor", instrumentDescriptor);
            JMenuItem createItem = new JMenuItem(createAction);
            createItem.setMnemonic('C');
            instrumentMenu.add(createItem);
            try {
                InstrumentSampleDescriptor[] descriptors = instrumentDescriptor.getInstrumentSampleDescriptors();
                if (descriptors.length <= 0) break block4;
                instrumentMenu.addSeparator();
                int i = 0;
                while (i < descriptors.length) {
                    InstrumentSampleDescriptor descriptor = descriptors[i];
                    if (showAll || descriptor.isConfigured()) {
                        String description = descriptor.getDescription();
                        AbstractAction action = new AbstractAction(description){

                            public void actionPerformed(ActionEvent event) {
                            }
                        };
                        action.putValue("InstrumentManagerConnection", connection);
                        action.putValue("InstrumentSampleDescriptor", descriptor);
                        JMenuItem item = new JMenuItem(action);
                        instrumentMenu.add(item);
                    }
                    ++i;
                }
            }
            catch (InvocationException e) {
                connection.close();
            }
        }
    }

    private JMenu buildOptionsMenu() {
        this.m_menuOptions = new LargeMenu("Options");
        this.m_menuOptions.setMnemonic('O');
        this.m_menuItemShowUnconfigured = new JCheckBoxMenuItem("Show Unconfigured Profilables", false);
        this.m_menuOptions.add(this.m_menuItemShowUnconfigured);
        return this.m_menuOptions;
    }

    private JMenu buildWindowMenu() {
        this.m_menuWindow = new LargeMenu("Window");
        this.m_menuWindow.setMnemonic('W');
        this.m_menuWindow.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent event) {
                MenuBar.this.rebuildWindowMenu();
            }

            public void menuDeselected(MenuEvent event) {
            }

            public void menuCanceled(MenuEvent event) {
            }
        });
        return this.m_menuWindow;
    }

    protected void rebuildWindowMenu() {
        this.m_menuWindow.removeAll();
        AbstractAction tileFramesAction = new AbstractAction("Tile frames"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.tileFrames();
            }
        };
        JMenuItem tileFrames = new JMenuItem(tileFramesAction);
        tileFrames.setMnemonic('t');
        this.m_menuWindow.add(tileFrames);
        AbstractAction tileFramesVAction = new AbstractAction("Tile frames vertically"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.tileFramesV();
            }
        };
        JMenuItem tileFramesV = new JMenuItem(tileFramesVAction);
        tileFramesV.setMnemonic('v');
        this.m_menuWindow.add(tileFramesV);
        AbstractAction tileFramesHAction = new AbstractAction("Tile frames horizontally"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.tileFramesH();
            }
        };
        JMenuItem tileFramesH = new JMenuItem(tileFramesHAction);
        tileFramesH.setMnemonic('h');
        this.m_menuWindow.add(tileFramesH);
        AbstractAction closeAllAction = new AbstractAction("Close All"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.closeAllFrames();
            }
        };
        JMenuItem closeAll = new JMenuItem(closeAllAction);
        closeAll.setMnemonic('o');
        this.m_menuWindow.add(closeAll);
        JInternalFrame[] frames = this.m_frame.getDesktopPane().getAllFrames();
        if (frames.length > 0) {
            this.m_menuWindow.addSeparator();
        }
        int i = 0;
        while (i < frames.length) {
            String label = i + 1 + " " + frames[i].getTitle();
            AbstractAction action = new AbstractAction(label){

                public void actionPerformed(ActionEvent event) {
                    JMenuItem menu = (JMenuItem)event.getSource();
                    Action action = menu.getAction();
                    JInternalFrame frame = (JInternalFrame)action.getValue("frame");
                    try {
                        if (frame.isIcon()) {
                            frame.setIcon(false);
                        }
                        frame.setSelected(true);
                        MenuBar.this.m_frame.getDesktopPane().moveToFront(frame);
                    }
                    catch (PropertyVetoException e) {}
                }
            };
            action.putValue("frame", frames[i]);
            JMenuItem item = new JMenuItem(action);
            this.m_menuWindow.add(item);
            if (i < 10) {
                item.setMnemonic((char)(49 + i));
            }
            ++i;
        }
    }
}

