/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleUtils;

class MaintainedSampleLease {
    private String m_instrumentName;
    private String m_sampleName;
    private int m_type;
    private long m_interval;
    private int m_size;
    private long m_leaseDuration;
    private String m_description;

    MaintainedSampleLease(String instrumentName, int type, long interval, int size, long leaseDuration, String description) {
        this.m_instrumentName = instrumentName;
        this.m_type = type;
        this.m_interval = interval;
        this.m_size = size;
        this.m_leaseDuration = leaseDuration;
        this.m_description = description;
        this.m_sampleName = InstrumentSampleUtils.generateFullInstrumentSampleName((String)this.m_instrumentName, (int)this.m_type, (long)this.m_interval, (int)this.m_size);
    }

    MaintainedSampleLease(Configuration stateConfig) throws ConfigurationException {
        this.m_instrumentName = stateConfig.getAttribute("instrument-name");
        this.m_type = stateConfig.getAttributeAsInteger("type");
        this.m_interval = stateConfig.getAttributeAsLong("interval");
        this.m_size = stateConfig.getAttributeAsInteger("size");
        this.m_leaseDuration = stateConfig.getAttributeAsLong("lease-duration");
        this.m_description = stateConfig.getAttribute("description");
        this.m_sampleName = InstrumentSampleUtils.generateFullInstrumentSampleName((String)this.m_instrumentName, (int)this.m_type, (long)this.m_interval, (int)this.m_size);
    }

    public final Configuration saveState() {
        DefaultConfiguration stateConfig = new DefaultConfiguration("maintained-sample", "-");
        stateConfig.setAttribute("instrument-name", this.m_instrumentName);
        stateConfig.setAttribute("type", InstrumentSampleUtils.getInstrumentSampleTypeName((int)this.m_type));
        stateConfig.setAttribute("interval", Long.toString(this.m_interval));
        stateConfig.setAttribute("size", Integer.toString(this.m_size));
        stateConfig.setAttribute("lease-duration", Long.toString(this.m_leaseDuration));
        stateConfig.setAttribute("description", this.m_description);
        return stateConfig;
    }

    String getInstrumentName() {
        return this.m_instrumentName;
    }

    String getSampleName() {
        return this.m_sampleName;
    }

    int getType() {
        return this.m_type;
    }

    long getInterval() {
        return this.m_interval;
    }

    int getSize() {
        return this.m_size;
    }

    long getLeaseDuration() {
        return this.m_leaseDuration;
    }

    String getDescription() {
        return this.m_description;
    }
}

