/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;

public class LineChart
extends JComponent
implements MouseListener,
MouseMotionListener {
    private Color m_lineColor = Color.red;
    private Color m_lightLineColor = new Color(255, 128, 128);
    private Color m_lightGridColor = new Color(192, 192, 192);
    private Color m_darkGridColor = new Color(128, 128, 128);
    private Color m_frameColor = Color.black;
    private Color m_crossColor = Color.blue;
    private Color m_maskFrameColor = new Color(128, 128, 255, 192);
    private Color m_maskColor = new Color(224, 224, 255, 192);
    private int m_lineSampleInterval;
    private long m_sampleInterval;
    private String m_format;
    private String m_dFormat;
    private int m_averageWindow;
    private long m_time;
    private int[] m_values;
    private float[] m_averageWindowValues;
    private int m_min;
    private int m_max;
    private DecimalFormat m_intFormat = new DecimalFormat("###,###,###,##0");
    private DecimalFormat m_floatFormat = new DecimalFormat("###,###,###,##0.00");
    private boolean m_mouseOver;
    private boolean m_mousePressed;
    private int m_mouseX;
    private int m_mouseY;

    public LineChart(int lineSampleInterval, long sampleInterval, String format, String detailFormat, int averageWindow) {
        this.m_lineSampleInterval = lineSampleInterval;
        this.m_sampleInterval = sampleInterval;
        this.m_format = format;
        this.m_dFormat = detailFormat;
        this.m_averageWindow = averageWindow;
        this.setBackground(Color.white);
        this.setValues(new int[0], System.currentTimeMillis());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int[] values, long time) {
        int max = 0;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            int v = values[i];
            if (v > max) {
                max = v;
            }
            if (v < min) {
                min = v;
            }
            ++i;
        }
        if (max - min < 10) {
            max += (10 - (max - min)) / 2;
            min -= 10 - (max - min);
        }
        if (min < 0) {
            max += -min;
            min = 0;
        }
        float[] averageValues = new float[values.length];
        if (this.m_averageWindow > 1) {
            int total = 0;
            int i2 = 0;
            while (i2 < values.length) {
                total += values[i2];
                if (i2 >= this.m_averageWindow - 1) {
                    if (i2 >= this.m_averageWindow) {
                        total -= values[i2 - this.m_averageWindow];
                    }
                    averageValues[i2] = (float)total / (float)this.m_averageWindow;
                } else {
                    averageValues[i2] = Float.MIN_VALUE;
                }
                ++i2;
            }
        }
        LineChart lineChart = this;
        synchronized (lineChart) {
            this.m_time = time;
            this.m_values = values;
            this.m_averageWindowValues = averageValues;
            this.m_min = min;
            this.m_max = max;
        }
        this.repaint();
    }

    private String getFormattedTime(Date dTime, boolean detailed) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dTime);
        int v = calendar.get(2) - 0 + 1;
        String month = v < 10 ? "0" + Integer.toString(v) : Integer.toString(v);
        v = calendar.get(5);
        String day = v < 10 ? "0" + Integer.toString(v) : Integer.toString(v);
        v = calendar.get(11);
        String hour = v < 10 ? "0" + Integer.toString(v) : Integer.toString(v);
        v = calendar.get(12);
        String minute = v < 10 ? "0" + Integer.toString(v) : Integer.toString(v);
        v = calendar.get(13);
        String second = v < 10 ? "0" + Integer.toString(v) : Integer.toString(v);
        v = calendar.get(14) / 10;
        String hundreths = v < 10 ? "0" + Integer.toString(v) : Integer.toString(v);
        String format = detailed ? MessageFormat.format(this.m_dFormat, month, day, hour, minute, second, hundreths) : MessageFormat.format(this.m_format, month, day, hour, minute, second, hundreths);
        return format;
    }

    private void paintHorizontalGrid(Graphics g, int yLabelInterval, int fontHeight, int chartLeft, int chartTop, int chartWidth, int chartHeight) {
        if (chartHeight > 0) {
            int horizonalLineLabeledInterval = (int)Math.ceil((float)fontHeight / (float)(yLabelInterval * chartHeight / (this.m_max - this.m_min)));
            int horizontalLineNumber = 0;
            int i = (int)Math.ceil((float)this.m_min / (float)yLabelInterval) * yLabelInterval;
            while (i < this.m_max) {
                int y = chartTop + chartHeight - (int)((long)chartHeight * (long)(i - this.m_min) / (long)(this.m_max - this.m_min));
                if (horizontalLineNumber >= horizonalLineLabeledInterval) {
                    horizontalLineNumber = 0;
                }
                if (horizontalLineNumber == 0) {
                    String lbl = this.m_intFormat.format(i);
                    g.setColor(this.m_frameColor);
                    g.drawString(lbl, chartLeft - 5 - g.getFontMetrics().stringWidth(lbl), y + (fontHeight >> 1));
                    g.setColor(this.m_darkGridColor);
                } else {
                    g.setColor(this.m_lightGridColor);
                }
                ++horizontalLineNumber;
                if (chartWidth > 0) {
                    g.drawLine(chartLeft, y, chartLeft + chartWidth, y);
                }
                i += yLabelInterval;
            }
        }
    }

    private void paintVerticalGrid(Graphics g, int fontHeight, int chartLeft, int chartTop, int chartWidth, int chartHeight) {
        if (chartWidth > 0) {
            FontMetrics fontMetrics = g.getFontMetrics();
            String format = MessageFormat.format(this.m_format, "00", "00", "00", "00");
            int fw = fontMetrics.stringWidth(format) + 10;
            int verticalLineLabeledInterval = this.m_values.length > 0 && chartWidth > 0 ? (int)Math.ceil((float)fw / (float)(this.m_lineSampleInterval * chartWidth / this.m_values.length)) : 1;
            long baseTime = (this.m_time - (long)this.m_values.length * this.m_sampleInterval) / (this.m_sampleInterval * (long)this.m_lineSampleInterval) * (this.m_sampleInterval * (long)this.m_lineSampleInterval);
            int verticalLineNumber = 0;
            int i = 0;
            while (i < this.m_values.length) {
                long time = this.m_time - (long)(this.m_values.length - i - 1) * this.m_sampleInterval;
                if ((time - baseTime) / this.m_sampleInterval % (long)this.m_lineSampleInterval == 0L) {
                    int x = chartLeft + i * chartWidth / (this.m_values.length - 1);
                    if (verticalLineNumber >= verticalLineLabeledInterval || verticalLineNumber == 0) {
                        format = this.getFormattedTime(new Date(time), false);
                        if (x - fontMetrics.stringWidth(format) / 2 >= chartLeft) {
                            g.setColor(this.m_frameColor);
                            g.drawString(format, x - fontMetrics.stringWidth(format) / 2, chartTop + chartHeight + fontHeight);
                            g.setColor(this.m_darkGridColor);
                            verticalLineNumber = 1;
                        } else {
                            g.setColor(this.m_lightGridColor);
                        }
                    } else {
                        g.setColor(this.m_lightGridColor);
                        ++verticalLineNumber;
                    }
                    if (chartHeight > 0) {
                        g.drawLine(x, chartTop, x, chartTop + chartHeight);
                    }
                }
                ++i;
            }
        }
    }

    private void paintFrame(Graphics g, int chartLeft, int chartTop, int chartWidth, int chartHeight) {
        if (chartWidth > 0 && chartHeight > 0) {
            g.setColor(this.m_frameColor);
            g.drawLine(chartLeft, chartTop, chartLeft, chartTop + chartHeight);
            g.drawLine(chartLeft, chartTop + chartHeight, chartLeft + chartWidth, chartTop + chartHeight);
        }
    }

    private void paintValues(Graphics g, int chartLeft, int chartTop, int chartWidth, int chartHeight) {
        if (this.m_averageWindow > 0 && this.m_mousePressed) {
            g.setColor(this.m_lightLineColor);
        } else {
            g.setColor(this.m_lineColor);
        }
        int lastX = 0;
        int lastY = 0;
        int i = 0;
        while (i < this.m_values.length) {
            int x = chartLeft + i * chartWidth / (this.m_values.length - 1);
            int y = chartTop + chartHeight - (int)((long)chartHeight * (long)(this.m_values[i] - this.m_min) / (long)(this.m_max - this.m_min));
            if (i > 0) {
                g.drawLine(lastX, lastY, x, y);
            }
            lastX = x;
            lastY = y;
            ++i;
        }
        if (this.m_averageWindow > 0 && this.m_mousePressed) {
            g.setColor(this.m_lineColor);
            lastX = 0;
            lastY = 0;
            int i2 = this.m_averageWindow;
            while (i2 < this.m_averageWindowValues.length) {
                int x = chartLeft + i2 * chartWidth / (this.m_averageWindowValues.length - 1);
                int y = chartTop + chartHeight - (int)((float)chartHeight * (this.m_averageWindowValues[i2] - (float)this.m_min) / (float)(this.m_max - this.m_min));
                if (i2 > this.m_averageWindow) {
                    g.drawLine(lastX, lastY, x, y);
                }
                lastX = x;
                lastY = y;
                ++i2;
            }
        }
    }

    private void paintOverlayAt(Graphics g, int fontHeight, int chartLeft, int chartTop, int chartWidth, int chartHeight, int mouseDataPointX, int mouseDataPointY, String mouseDataPointValue, long mouseDataPointTime) {
        int mouseDataPointLabelTop;
        int mouseDataPointLabelLeft;
        g.setColor(this.m_crossColor);
        g.drawLine(mouseDataPointX, chartTop, mouseDataPointX, chartTop + chartHeight);
        g.drawLine(chartLeft, mouseDataPointY, chartLeft + chartWidth, mouseDataPointY);
        String mouseDataPointLabel = mouseDataPointValue + " : " + this.getFormattedTime(new Date(mouseDataPointTime), true);
        int mouseDataPointLabelWidth = g.getFontMetrics().stringWidth(mouseDataPointLabel);
        if (mouseDataPointX + 5 + mouseDataPointLabelWidth < chartLeft + chartWidth) {
            mouseDataPointLabelLeft = mouseDataPointX + 4;
            mouseDataPointLabelTop = mouseDataPointY + 5 + fontHeight < chartTop + chartHeight ? mouseDataPointY + 4 : mouseDataPointY - 4 - fontHeight;
        } else {
            mouseDataPointLabelLeft = mouseDataPointX - 4 - mouseDataPointLabelWidth;
            mouseDataPointLabelTop = mouseDataPointY + 5 + fontHeight < chartTop + chartHeight ? mouseDataPointY + 4 : mouseDataPointY - 4 - fontHeight;
        }
        g.setColor(this.m_maskFrameColor);
        g.drawRect(mouseDataPointLabelLeft - 1, mouseDataPointLabelTop - 1, mouseDataPointLabelWidth + 2, fontHeight + 2);
        g.setColor(this.m_maskColor);
        g.fillRect(mouseDataPointLabelLeft - 1, mouseDataPointLabelTop - 1, mouseDataPointLabelWidth + 2, fontHeight + 2);
        g.setColor(this.m_crossColor);
        g.drawString(mouseDataPointLabel, mouseDataPointLabelLeft, mouseDataPointLabelTop + fontHeight);
    }

    private void paintOverlay(Graphics g, int fontHeight, int chartLeft, int chartTop, int chartWidth, int chartHeight) {
        if (this.m_mouseOver && this.m_mouseX >= chartLeft && this.m_mouseX <= chartLeft + chartWidth) {
            int index = Math.round((float)(this.m_values.length - 1) * (float)(this.m_mouseX - chartLeft) / (float)chartWidth);
            int mouseDataPointX = 0;
            int mouseDataPointY = 0;
            String mouseDataPointValue = null;
            long mouseDataPointTime = 0L;
            boolean showLabel = false;
            if (this.m_averageWindow > 0 && this.m_mousePressed) {
                if (index >= this.m_averageWindow && index < this.m_averageWindowValues.length) {
                    mouseDataPointX = chartLeft + index * chartWidth / (this.m_averageWindowValues.length - 1);
                    mouseDataPointY = chartTop + chartHeight - (int)((float)chartHeight * (this.m_averageWindowValues[index] - (float)this.m_min) / (float)(this.m_max - this.m_min));
                    mouseDataPointValue = this.m_floatFormat.format(this.m_averageWindowValues[index]);
                    mouseDataPointTime = this.m_time - (long)(this.m_averageWindowValues.length - index - 1) * this.m_sampleInterval;
                    showLabel = true;
                }
            } else if (index >= 0 && index < this.m_values.length) {
                mouseDataPointX = chartLeft + index * chartWidth / (this.m_values.length - 1);
                mouseDataPointY = chartTop + chartHeight - (int)((long)chartHeight * (long)(this.m_values[index] - this.m_min) / (long)(this.m_max - this.m_min));
                mouseDataPointValue = this.m_intFormat.format(this.m_values[index]);
                mouseDataPointTime = this.m_time - (long)(this.m_values.length - index - 1) * this.m_sampleInterval;
                showLabel = true;
            }
            if (showLabel) {
                this.paintOverlayAt(g, fontHeight, chartLeft, chartTop, chartWidth, chartHeight, mouseDataPointX, mouseDataPointY, mouseDataPointValue, mouseDataPointTime);
            }
        }
    }

    public synchronized void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        g.setColor(this.getBackground());
        g.fillRect(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
        int yLabelInterval = 1;
        while ((this.m_max - this.m_min) / yLabelInterval > 20) {
            yLabelInterval *= 10;
        }
        FontMetrics fontMetrics = g.getFontMetrics();
        int maxYLabelWidth = fontMetrics.stringWidth(this.m_intFormat.format(this.m_max));
        int fontHeight = fontMetrics.getAscent();
        int fontHalfHeight = fontHeight / 2;
        int chartLeft = insets.left + maxYLabelWidth + 5;
        int chartTop = insets.top + 5;
        int chartWidth = size.width - chartLeft - insets.right - 1 - 5;
        int chartHeight = size.height - chartTop - insets.bottom - 1 - fontHeight;
        this.paintHorizontalGrid(g, yLabelInterval, fontHeight, chartLeft, chartTop, chartWidth, chartHeight);
        this.paintVerticalGrid(g, fontHeight, chartLeft, chartTop, chartWidth, chartHeight);
        this.paintFrame(g, chartLeft, chartTop, chartWidth, chartHeight);
        if (chartWidth > 0 && chartHeight > 0) {
            this.paintValues(g, chartLeft, chartTop, chartWidth, chartHeight);
            this.paintOverlay(g, fontHeight, chartLeft, chartTop, chartWidth, chartHeight);
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        this.m_mousePressed = true;
    }

    public void mouseReleased(MouseEvent event) {
        this.m_mousePressed = false;
    }

    public void mouseEntered(MouseEvent event) {
        this.m_mouseOver = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent event) {
        this.m_mouseOver = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent event) {
        this.m_mouseX = event.getX();
        this.m_mouseY = event.getY();
        this.repaint();
    }

    public void mouseMoved(MouseEvent event) {
        this.m_mouseX = event.getX();
        this.m_mouseY = event.getY();
        this.repaint();
    }
}

