/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import javax.swing.ImageIcon;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.NodeData;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentableDescriptor;

class InstrumentableNodeData
extends NodeData {
    private static final ImageIcon m_iconInstrumentableConf;
    private static final ImageIcon m_iconInstrumentableReg;
    private static final ImageIcon m_iconInstrumentableRegConf;
    private static final ImageIcon m_iconInstrumentableOld;
    private InstrumentableDescriptor m_descriptor;
    private InstrumentManagerConnection m_connection;
    private boolean m_configured;
    private boolean m_registered;
    static /* synthetic */ Class class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer;

    InstrumentableNodeData(InstrumentableDescriptor descriptor, InstrumentManagerConnection connection) {
        this.m_descriptor = descriptor;
        this.m_connection = connection;
        this.update();
    }

    ImageIcon getIcon() {
        ImageIcon icon = this.isConfigured() && this.isRegistered() ? m_iconInstrumentableRegConf : (this.isConfigured() ? m_iconInstrumentableConf : (this.isRegistered() ? m_iconInstrumentableReg : m_iconInstrumentableOld));
        return icon;
    }

    String getToolTipText() {
        String text = this.isConfigured() && this.isRegistered() ? "Registered and Configured Instrumentable" : (this.isConfigured() ? "Configured but unregistered Instrumentable" : (this.isRegistered() ? "Registered Instrumentable" : "Old Instrumentable loaded from state file"));
        return text;
    }

    InstrumentableDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    boolean isConfigured() {
        return this.m_configured;
    }

    boolean isRegistered() {
        return this.m_registered;
    }

    boolean update() {
        boolean newRegistered;
        boolean changed = false;
        changed |= this.update(this.m_descriptor.getName(), this.m_descriptor.getDescription(), this.m_descriptor.getStateVersion());
        boolean newConfigured = this.m_descriptor.isConfigured();
        if (newConfigured != this.m_configured) {
            changed = true;
            this.m_configured = newConfigured;
        }
        if ((newRegistered = this.m_descriptor.isRegistered()) != this.m_registered) {
            changed = true;
            this.m_registered = newRegistered;
        }
        return changed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassLoader cl = (class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer == null ? (class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer = InstrumentableNodeData.class$("org.apache.excalibur.instrument.client.InstrumentManagerTreeCellRenderer")) : class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer).getClassLoader();
        m_iconInstrumentableConf = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrumentable_conf.gif"));
        m_iconInstrumentableReg = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrumentable_reg.gif"));
        m_iconInstrumentableRegConf = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrumentable_reg_conf.gif"));
        m_iconInstrumentableOld = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrumentable_old.gif"));
    }
}

