/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.NodeData;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleUtils;

class InstrumentSampleNodeData
extends NodeData {
    private static final int ICON_TYPE_CNT = 0;
    private static final int ICON_TYPE_MAX = 1;
    private static final int ICON_TYPE_MEAN = 2;
    private static final int ICON_TYPE_MIN = 3;
    private static final int ICON_SUBTYPE_CONF = 0;
    private static final int ICON_SUBTYPE_LEASE = 1;
    private static final int ICON_SUBTYPE_MAINTAINED_LEASE = 2;
    private static final int ICON_SUBTYPE_OLD = 3;
    private static final ImageIcon[][] m_icons = new ImageIcon[4][4];
    private String m_instrumentName;
    private InstrumentSampleDescriptor m_descriptor;
    private InstrumentManagerConnection m_connection;
    private boolean m_configured;
    private long m_leaseExpireTime;
    private long m_leaseDuration;
    private int m_type;
    private int m_size;
    private long m_interval;
    static /* synthetic */ Class class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer;

    private static void loadTypeIcons(ClassLoader cl, int type, String prefix) {
        InstrumentSampleNodeData.m_icons[type][0] = new ImageIcon(cl.getResource(prefix + "conf.gif"));
        InstrumentSampleNodeData.m_icons[type][1] = new ImageIcon(cl.getResource(prefix + "lease.gif"));
        InstrumentSampleNodeData.m_icons[type][2] = new ImageIcon(cl.getResource(prefix + "mlease.gif"));
        InstrumentSampleNodeData.m_icons[type][3] = new ImageIcon(cl.getResource(prefix + "old.gif"));
    }

    InstrumentSampleNodeData(String instrumentName, InstrumentSampleDescriptor descriptor, InstrumentManagerConnection connection) {
        this.m_instrumentName = instrumentName;
        this.m_descriptor = descriptor;
        this.m_connection = connection;
        this.update();
    }

    ImageIcon getIcon() {
        int iconType;
        switch (this.getType()) {
            case 101: {
                iconType = 0;
                break;
            }
            case 103: {
                iconType = 1;
                break;
            }
            case 104: {
                iconType = 2;
                break;
            }
            case 102: {
                iconType = 3;
                break;
            }
            default: {
                throw new IllegalStateException("Encountered an unknown instrument sample type: " + this.getType());
            }
        }
        int iconSubtype = this.isConfigured() ? 0 : (this.isLeased() ? (this.isLeaseMaintained() ? 2 : 1) : 3);
        return m_icons[iconType][iconSubtype];
    }

    String getToolTipText() {
        String text;
        switch (this.getType()) {
            case 101: {
                if (this.isConfigured()) {
                    text = "Configured Counter Instrument Sample";
                    break;
                }
                if (this.isLeased()) {
                    if (this.isLeaseMaintained()) {
                        text = "Leased Counter Instrument Sample (Maintained " + this.getLeaseDuration() / 1000L + " seconds)";
                        break;
                    }
                    text = "Leased Counter Instrument Sample (Expires in " + this.getRemainingLeaseTime() / 1000L + " seconds)";
                    break;
                }
                text = "Old Counter Instrument Sample loaded from state file";
                break;
            }
            case 103: {
                if (this.isConfigured()) {
                    text = "Configured Maximum Value Instrument Sample";
                    break;
                }
                if (this.isLeased()) {
                    if (this.isLeaseMaintained()) {
                        text = "Leased Maximum Value Instrument Sample (Maintained " + this.getLeaseDuration() / 1000L + " seconds)";
                        break;
                    }
                    text = "Leased Maximum Value Instrument Sample (Expires in " + this.getRemainingLeaseTime() / 1000L + " seconds)";
                    break;
                }
                text = "Old Maximum Value Instrument Sample loaded from state file";
                break;
            }
            case 104: {
                if (this.isConfigured()) {
                    text = "Configured Mean Value Instrument Sample";
                    break;
                }
                if (this.isLeased()) {
                    if (this.isLeaseMaintained()) {
                        text = "Leased Mean Value Instrument Sample (Maintained " + this.getLeaseDuration() / 1000L + " seconds)";
                        break;
                    }
                    text = "Leased Mean Value Instrument Sample (Expires in " + this.getRemainingLeaseTime() / 1000L + " seconds)";
                    break;
                }
                text = "Old Mean Value Instrument Sample loaded from state file";
                break;
            }
            case 102: {
                if (this.isConfigured()) {
                    text = "Configured Minimum Value Instrument Sample";
                    break;
                }
                if (this.isLeased()) {
                    if (this.isLeaseMaintained()) {
                        text = "Leased Minimum Value Instrument Sample (Maintained " + this.getLeaseDuration() / 1000L + " seconds)";
                        break;
                    }
                    text = "Leased Minimum Value Instrument Sample (Expires in " + this.getRemainingLeaseTime() / 1000L + " seconds)";
                    break;
                }
                text = "Old Minimum Value Instrument Sample loaded from state file";
                break;
            }
            default: {
                throw new IllegalStateException("Encountered an unknown instrument sample type: " + this.getType());
            }
        }
        return text;
    }

    public JMenuItem[] getCommonMenuItems() {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        AbstractAction viewAction = new AbstractAction("View"){

            public void actionPerformed(ActionEvent event) {
                InstrumentSampleNodeData.this.m_connection.viewSample(InstrumentSampleNodeData.this);
            }
        };
        JMenuItem viewItem = new JMenuItem(viewAction);
        viewItem.setMnemonic('V');
        menuItems.add(viewItem);
        if (this.isLeased()) {
            if (this.isLeaseMaintained()) {
                AbstractAction stopMaintainingAction = new AbstractAction("Stop Maintaining Lease..."){

                    public void actionPerformed(ActionEvent event) {
                        InstrumentSampleNodeData.this.m_connection.stopMaintainingSample(InstrumentSampleNodeData.this.getName());
                    }
                };
                JMenuItem stopMaintainingItem = new JMenuItem(stopMaintainingAction);
                stopMaintainingItem.setMnemonic('S');
                menuItems.add(stopMaintainingItem);
            } else {
                AbstractAction startMaintainingAction = new AbstractAction("Start Maintaining Lease..."){

                    public void actionPerformed(ActionEvent event) {
                        long leaseDuration = 600000L;
                        String description = "Menu Generated: " + InstrumentSampleUtils.generateInstrumentSampleName((int)InstrumentSampleNodeData.this.m_type, (long)InstrumentSampleNodeData.this.m_interval, (int)InstrumentSampleNodeData.this.m_size);
                        InstrumentSampleNodeData.this.m_connection.startMaintainingSample(InstrumentSampleNodeData.this.m_instrumentName, InstrumentSampleNodeData.this.m_type, InstrumentSampleNodeData.this.m_interval, InstrumentSampleNodeData.this.m_size, leaseDuration, description);
                    }
                };
                JMenuItem startMaintainingItem = new JMenuItem(startMaintainingAction);
                startMaintainingItem.setMnemonic('S');
                menuItems.add(startMaintainingItem);
            }
        }
        JMenuItem[] menuItemArray = new JMenuItem[menuItems.size()];
        menuItems.toArray(menuItemArray);
        return menuItemArray;
    }

    void select() {
        this.m_connection.viewSample(this);
    }

    InstrumentSampleDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    boolean isConfigured() {
        return this.m_configured;
    }

    boolean isLeased() {
        return this.m_leaseExpireTime > 0L;
    }

    boolean isLeaseMaintained() {
        return this.m_leaseDuration > 0L;
    }

    int getType() {
        return this.m_type;
    }

    int getSize() {
        return this.m_size;
    }

    long getInterval() {
        return this.m_interval;
    }

    boolean update() {
        long newInterval;
        int newSize;
        int newType;
        long newLeaseExpireTime;
        boolean changed = false;
        changed |= this.update(this.m_descriptor.getName(), this.m_descriptor.getDescription(), this.m_descriptor.getStateVersion());
        boolean newConfigured = this.m_descriptor.isConfigured();
        if (newConfigured != this.m_configured) {
            changed = true;
            this.m_configured = newConfigured;
        }
        if ((newLeaseExpireTime = this.m_descriptor.getLeaseExpirationTime()) != this.m_leaseExpireTime) {
            changed = true;
            this.m_leaseExpireTime = newLeaseExpireTime;
        }
        if ((newType = this.m_descriptor.getType()) != this.m_type) {
            changed = true;
            this.m_type = newType;
        }
        if ((newSize = this.m_descriptor.getSize()) != this.m_size) {
            changed = true;
            this.m_size = newSize;
        }
        if ((newInterval = this.m_descriptor.getInterval()) != this.m_interval) {
            changed = true;
            this.m_interval = newInterval;
        }
        return changed;
    }

    long getRemainingLeaseTime() {
        long now = System.currentTimeMillis();
        return this.m_leaseExpireTime - now;
    }

    void setLeaseExpireTime(long leaseExpireTime) {
        this.m_leaseExpireTime = leaseExpireTime;
    }

    void setLeaseDuration(long leaseDuration) {
        this.m_leaseDuration = leaseDuration;
    }

    long getLeaseDuration() {
        return this.m_leaseDuration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassLoader cl = (class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer == null ? (class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer = InstrumentSampleNodeData.class$("org.apache.excalibur.instrument.client.InstrumentManagerTreeCellRenderer")) : class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer).getClassLoader();
        InstrumentSampleNodeData.loadTypeIcons(cl, 0, "org/apache/excalibur/instrument/client/media/sample_cnt_");
        InstrumentSampleNodeData.loadTypeIcons(cl, 1, "org/apache/excalibur/instrument/client/media/sample_max_");
        InstrumentSampleNodeData.loadTypeIcons(cl, 2, "org/apache/excalibur/instrument/client/media/sample_mean_");
        InstrumentSampleNodeData.loadTypeIcons(cl, 3, "org/apache/excalibur/instrument/client/media/sample_min_");
    }
}

