/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.altrmi.client.InvocationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.InstrumentManagerConnectionListener;
import org.apache.excalibur.instrument.client.InstrumentNodeData;
import org.apache.excalibur.instrument.client.InstrumentSampleNodeData;
import org.apache.excalibur.instrument.client.InstrumentableNodeData;
import org.apache.excalibur.instrument.client.MaintainedSampleLease;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentManagerClient;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentableDescriptor;

class InstrumentManagerTreeModel
extends AbstractLogEnabled
implements InstrumentManagerConnectionListener,
TreeModel {
    private final InstrumentManagerConnection m_connection;
    private InstrumentManagerClient m_lastClient;
    private int m_lastClientStateVersion;
    private DefaultMutableTreeNode m_root;
    private ArrayList m_listeners = new ArrayList();
    private TreeModelListener[] m_listenerArray;
    private HashMap m_elementMap = new HashMap();
    private HashMap m_leasedSampleMap = new HashMap();
    private DefaultMutableTreeNode[] m_leasedSampleArray;

    InstrumentManagerTreeModel(InstrumentManagerConnection connection) {
        this.m_connection = connection;
        this.m_root = new DefaultMutableTreeNode("Root");
    }

    public void opened(InstrumentManagerConnection connection) {
        this.refreshModel();
    }

    public void closed(InstrumentManagerConnection connection) {
        this.refreshModel();
    }

    public void deleted(InstrumentManagerConnection connection) {
        this.refreshModel();
    }

    public Object getRoot() {
        return this.m_root;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent;
            return node.getChildAt(index);
        }
        return "---";
    }

    public int getChildCount(Object parent) {
        if (parent instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent;
            return node.getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        if (node == this.m_root) {
            return false;
        }
        if (node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode inode = (DefaultMutableTreeNode)node;
            return inode.isLeaf();
        }
        return true;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent;
            return node.getIndex((DefaultMutableTreeNode)child);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeModelListener(TreeModelListener listener) {
        InstrumentManagerTreeModel instrumentManagerTreeModel = this;
        synchronized (instrumentManagerTreeModel) {
            this.m_listeners.add(listener);
            this.m_listenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTreeModelListener(TreeModelListener listener) {
        InstrumentManagerTreeModel instrumentManagerTreeModel = this;
        synchronized (instrumentManagerTreeModel) {
            this.m_listeners.remove(listener);
            this.m_listenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeModelListener[] getListeners() {
        TreeModelListener[] listeners = this.m_listenerArray;
        if (listeners == null) {
            InstrumentManagerTreeModel instrumentManagerTreeModel = this;
            synchronized (instrumentManagerTreeModel) {
                this.m_listenerArray = new TreeModelListener[this.m_listeners.size()];
                this.m_listeners.toArray(this.m_listenerArray);
                listeners = this.m_listenerArray;
            }
        }
        return listeners;
    }

    private void fireTreeNodesChanged(TreeModelEvent event) {
        TreeModelListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].treeNodesChanged(event);
            ++i;
        }
    }

    private void fireTreeNodesInserted(TreeModelEvent event) {
        TreeModelListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].treeNodesInserted(event);
            ++i;
        }
    }

    private void fireTreeNodesRemoved(TreeModelEvent event) {
        TreeModelListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].treeNodesRemoved(event);
            ++i;
        }
    }

    private void fireTreeStructureChanged(TreeModelEvent event) {
        TreeModelListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].treeStructureChanged(event);
            ++i;
        }
    }

    public DefaultMutableTreeNode getInstrumentableTreeNode(String name) {
        Object element;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_elementMap.get(name);
        if (node != null && (element = node.getUserObject()) instanceof InstrumentableNodeData) {
            return node;
        }
        return null;
    }

    public DefaultMutableTreeNode getInstrumentTreeNode(String name) {
        Object element;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_elementMap.get(name);
        if (node != null && (element = node.getUserObject()) instanceof InstrumentNodeData) {
            return node;
        }
        return null;
    }

    public DefaultMutableTreeNode getInstrumentSampleTreeNode(String name) {
        Object element;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_elementMap.get(name);
        if (node != null && (element = node.getUserObject()) instanceof InstrumentSampleNodeData) {
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultMutableTreeNode[] getLeasedSampleArray() {
        DefaultMutableTreeNode[] leasedSampleArray = this.m_leasedSampleArray;
        if (leasedSampleArray == null) {
            InstrumentManagerTreeModel instrumentManagerTreeModel = this;
            synchronized (instrumentManagerTreeModel) {
                this.m_leasedSampleArray = new DefaultMutableTreeNode[this.m_leasedSampleMap.size()];
                this.m_leasedSampleMap.values().toArray(this.m_leasedSampleArray);
                leasedSampleArray = this.m_leasedSampleArray;
            }
        }
        return leasedSampleArray;
    }

    void renewAllSampleLeases() {
        DefaultMutableTreeNode[] leasedSampleArray = this.getLeasedSampleArray();
        int i = 0;
        while (i < leasedSampleArray.length) {
            InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)leasedSampleArray[i].getUserObject();
            InstrumentSampleDescriptor sampleDescriptor = sampleNodeData.getDescriptor();
            this.updateInstrumentSample(sampleDescriptor);
            ++i;
        }
    }

    void purgeExpiredSamples() {
        DefaultMutableTreeNode[] leasedSampleArray = this.getLeasedSampleArray();
        int i = 0;
        while (i < leasedSampleArray.length) {
            InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)leasedSampleArray[i].getUserObject();
            if (sampleNodeData.getRemainingLeaseTime() < 0L) {
                DefaultMutableTreeNode instrumentTreeNode = (DefaultMutableTreeNode)leasedSampleArray[i].getParent();
                InstrumentDescriptor instrumentDescriptor = ((InstrumentNodeData)instrumentTreeNode.getUserObject()).getDescriptor();
                this.updateInstrument(instrumentDescriptor, instrumentTreeNode, -1);
            }
            ++i;
        }
    }

    void refreshModel() {
        InstrumentManagerClient client = this.m_connection.getInstrumentManagerClient();
        if (client == null) {
            if (this.m_lastClient != null) {
                this.m_root.removeAllChildren();
                this.m_elementMap.clear();
                this.m_leasedSampleMap.clear();
                this.m_leasedSampleArray = null;
                this.m_lastClientStateVersion = -1;
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.m_root.getPath()));
            }
        } else {
            if (client != this.m_lastClient) {
                this.m_root.removeAllChildren();
                this.m_elementMap.clear();
                this.m_leasedSampleMap.clear();
                this.m_leasedSampleArray = null;
                this.m_lastClientStateVersion = -1;
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.m_root}));
            }
            try {
                this.updateInstrumentModelClient(client, this.m_root, this.m_lastClientStateVersion);
            }
            catch (InvocationException e) {
                System.out.println("Error updating the Instrumentables on " + this.m_connection.getHost() + ":" + this.m_connection.getPort() + ": " + e.getMessage());
            }
        }
        this.m_lastClient = client;
    }

    private void updateInstrumentModelClient(InstrumentManagerClient client, DefaultMutableTreeNode rootTreeNode, int oldStateVersion) {
        int stateVersion = client.getStateVersion();
        if (stateVersion == oldStateVersion) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("update client(" + client.getName() + ") " + "state new=" + stateVersion + ", old=" + oldStateVersion);
        }
        InstrumentableDescriptor[] descriptors = client.getInstrumentableDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            InstrumentableDescriptor descriptor = descriptors[i];
            int oldInstrumentableStateVersion = -1;
            DefaultMutableTreeNode newChild = null;
            int childCount = rootTreeNode.getChildCount();
            if (i < childCount) {
                int cmp;
                do {
                    DefaultMutableTreeNode oldChild;
                    if ((cmp = ((InstrumentableNodeData)(oldChild = (DefaultMutableTreeNode)rootTreeNode.getChildAt(i)).getUserObject()).getDescription().compareTo(descriptor.getDescription())) == 0) {
                        InstrumentableNodeData nodeData = (InstrumentableNodeData)oldChild.getUserObject();
                        oldInstrumentableStateVersion = nodeData.getStateVersion();
                        if (nodeData.update()) {
                            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, rootTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                        }
                        newChild = oldChild;
                        continue;
                    }
                    if (cmp > 0) {
                        newChild = new DefaultMutableTreeNode(new InstrumentableNodeData(descriptor, this.m_connection), true);
                        rootTreeNode.insert(newChild, i);
                        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, rootTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                        this.m_elementMap.put(((InstrumentableNodeData)newChild.getUserObject()).getName(), newChild);
                        continue;
                    }
                    if (cmp >= 0) continue;
                    rootTreeNode.remove(i);
                    this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, rootTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                    this.m_elementMap.remove(((InstrumentableNodeData)oldChild.getUserObject()).getName());
                } while (cmp < 0);
            } else {
                newChild = new DefaultMutableTreeNode(new InstrumentableNodeData(descriptor, this.m_connection), true);
                rootTreeNode.insert(newChild, i);
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, rootTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                this.m_elementMap.put(((InstrumentableNodeData)newChild.getUserObject()).getName(), newChild);
            }
            this.updateInstrumentable(descriptor, newChild, oldInstrumentableStateVersion);
            ++i;
        }
        while (i < rootTreeNode.getChildCount()) {
            DefaultMutableTreeNode oldChild = (DefaultMutableTreeNode)rootTreeNode.getChildAt(i);
            rootTreeNode.remove(i);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, rootTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
            this.m_elementMap.remove(((InstrumentableNodeData)oldChild.getUserObject()).getName());
        }
        this.m_lastClientStateVersion = stateVersion;
    }

    private void updateInstrumentable(InstrumentableDescriptor instrumentableDescriptor, DefaultMutableTreeNode instrumentableTreeNode, int oldStateVersion) {
        int stateVersion = instrumentableDescriptor.getStateVersion();
        if (stateVersion == oldStateVersion) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("update instrumentable(" + instrumentableDescriptor.getName() + ") " + "state new=" + stateVersion + ", old=" + oldStateVersion);
        }
        InstrumentableDescriptor[] descriptors = instrumentableDescriptor.getChildInstrumentableDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            InstrumentableDescriptor descriptor = descriptors[i];
            int oldInstrumentableStateVersion = -1;
            DefaultMutableTreeNode newChild = null;
            int childCount = instrumentableTreeNode.getChildCount();
            if (i < childCount) {
                int cmp;
                do {
                    DefaultMutableTreeNode oldChild;
                    if ((cmp = (oldChild = (DefaultMutableTreeNode)instrumentableTreeNode.getChildAt(i)).getUserObject() instanceof InstrumentableNodeData ? ((InstrumentableNodeData)oldChild.getUserObject()).getDescription().compareTo(descriptor.getDescription()) : 1) == 0) {
                        InstrumentableNodeData nodeData = (InstrumentableNodeData)oldChild.getUserObject();
                        oldInstrumentableStateVersion = nodeData.getStateVersion();
                        if (nodeData.update()) {
                            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                        }
                        newChild = oldChild;
                        continue;
                    }
                    if (cmp > 0) {
                        newChild = new DefaultMutableTreeNode(new InstrumentableNodeData(descriptor, this.m_connection), true);
                        instrumentableTreeNode.insert(newChild, i);
                        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                        this.m_elementMap.put(((InstrumentableNodeData)newChild.getUserObject()).getName(), newChild);
                        continue;
                    }
                    if (cmp >= 0) continue;
                    instrumentableTreeNode.remove(i);
                    this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                    this.m_elementMap.remove(((InstrumentableNodeData)oldChild.getUserObject()).getName());
                } while (cmp < 0);
            } else {
                newChild = new DefaultMutableTreeNode(new InstrumentableNodeData(descriptor, this.m_connection), true);
                instrumentableTreeNode.insert(newChild, i);
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                this.m_elementMap.put(((InstrumentableNodeData)newChild.getUserObject()).getName(), newChild);
            }
            this.updateInstrumentable(descriptor, newChild, oldInstrumentableStateVersion);
            ++i;
        }
        while (i < instrumentableTreeNode.getChildCount()) {
            DefaultMutableTreeNode oldChild = (DefaultMutableTreeNode)instrumentableTreeNode.getChildAt(i);
            if (!(oldChild.getUserObject() instanceof InstrumentableNodeData)) break;
            instrumentableTreeNode.remove(i);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
            this.m_elementMap.remove(((InstrumentableNodeData)oldChild.getUserObject()).getName());
        }
        InstrumentDescriptor[] instrumentDescriptors = instrumentableDescriptor.getInstrumentDescriptors();
        i = descriptors.length;
        while (i < instrumentDescriptors.length + descriptors.length) {
            InstrumentDescriptor descriptor = instrumentDescriptors[i - descriptors.length];
            int oldInstrumentStateVersion = -1;
            DefaultMutableTreeNode newChild = null;
            int childCount = instrumentableTreeNode.getChildCount();
            if (i < childCount) {
                int cmp;
                do {
                    DefaultMutableTreeNode oldChild;
                    if ((cmp = (oldChild = (DefaultMutableTreeNode)instrumentableTreeNode.getChildAt(i)).getUserObject() instanceof InstrumentNodeData ? ((InstrumentNodeData)oldChild.getUserObject()).getDescription().compareTo(descriptor.getDescription()) : 1) == 0) {
                        InstrumentNodeData nodeData = (InstrumentNodeData)oldChild.getUserObject();
                        oldInstrumentStateVersion = nodeData.getStateVersion();
                        if (nodeData.update()) {
                            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                        }
                        newChild = oldChild;
                        continue;
                    }
                    if (cmp > 0) {
                        newChild = new DefaultMutableTreeNode(new InstrumentNodeData(descriptor, this.m_connection), true);
                        instrumentableTreeNode.insert(newChild, i);
                        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                        this.m_elementMap.put(((InstrumentNodeData)newChild.getUserObject()).getName(), newChild);
                        continue;
                    }
                    if (cmp >= 0) continue;
                    instrumentableTreeNode.remove(i);
                    this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                    this.m_elementMap.remove(((InstrumentNodeData)oldChild.getUserObject()).getName());
                } while (cmp < 0);
            } else {
                newChild = new DefaultMutableTreeNode(new InstrumentNodeData(descriptor, this.m_connection), true);
                instrumentableTreeNode.insert(newChild, i);
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                this.m_elementMap.put(((InstrumentNodeData)newChild.getUserObject()).getName(), newChild);
            }
            this.updateInstrument(descriptor, newChild, oldInstrumentStateVersion);
            ++i;
        }
        while (i < instrumentableTreeNode.getChildCount()) {
            DefaultMutableTreeNode oldChild = (DefaultMutableTreeNode)instrumentableTreeNode.getChildAt(i);
            instrumentableTreeNode.remove(i);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
            this.m_elementMap.remove(((InstrumentNodeData)oldChild.getUserObject()).getName());
        }
    }

    void updateInstrument(InstrumentDescriptor instrumentDescriptor) {
        DefaultMutableTreeNode instrumentTreeNode = this.getInstrumentTreeNode(instrumentDescriptor.getName());
        if (instrumentTreeNode != null) {
            this.updateInstrument(instrumentDescriptor, instrumentTreeNode, -1);
        }
    }

    void updateInstrument(InstrumentDescriptor instrumentDescriptor, DefaultMutableTreeNode instrumentTreeNode, int oldStateVersion) {
        int stateVersion = instrumentDescriptor.getStateVersion();
        if (stateVersion == oldStateVersion) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("update instrument(" + instrumentDescriptor.getName() + ") " + "state new=" + stateVersion + ", old=" + oldStateVersion);
        }
        InstrumentSampleDescriptor[] descriptors = instrumentDescriptor.getInstrumentSampleDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            InstrumentSampleDescriptor descriptor = descriptors[i];
            DefaultMutableTreeNode newChild = null;
            int childCount = instrumentTreeNode.getChildCount();
            if (i < childCount) {
                int cmp;
                do {
                    String sampleName;
                    DefaultMutableTreeNode oldChild;
                    if ((cmp = (oldChild = (DefaultMutableTreeNode)instrumentTreeNode.getChildAt(i)).getUserObject() instanceof InstrumentSampleNodeData ? ((InstrumentSampleNodeData)oldChild.getUserObject()).getDescription().compareTo(descriptor.getDescription()) : 1) == 0) {
                        if (((InstrumentSampleNodeData)oldChild.getUserObject()).update()) {
                            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, instrumentTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                        }
                        newChild = oldChild;
                        continue;
                    }
                    if (cmp > 0) {
                        MaintainedSampleLease lease;
                        newChild = new DefaultMutableTreeNode(new InstrumentSampleNodeData(instrumentDescriptor.getName(), descriptor, this.m_connection), true);
                        instrumentTreeNode.insert(newChild, i);
                        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                        InstrumentSampleNodeData newNodeData = (InstrumentSampleNodeData)newChild.getUserObject();
                        sampleName = newNodeData.getName();
                        this.m_elementMap.put(sampleName, newChild);
                        if (newNodeData.isLeased()) {
                            this.m_leasedSampleMap.put(sampleName, newChild);
                            this.m_leasedSampleArray = null;
                        }
                        if ((lease = this.m_connection.getMaintainedSampleLease(sampleName)) == null) continue;
                        newNodeData.setLeaseDuration(lease.getLeaseDuration());
                        continue;
                    }
                    if (cmp >= 0) continue;
                    instrumentTreeNode.remove(i);
                    this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                    InstrumentSampleNodeData oldNodeData = (InstrumentSampleNodeData)oldChild.getUserObject();
                    sampleName = oldNodeData.getName();
                    this.m_elementMap.remove(sampleName);
                    if (!oldNodeData.isLeased()) continue;
                    this.m_leasedSampleMap.remove(sampleName);
                    this.m_leasedSampleArray = null;
                } while (cmp < 0);
            } else {
                MaintainedSampleLease lease;
                newChild = new DefaultMutableTreeNode(new InstrumentSampleNodeData(instrumentDescriptor.getName(), descriptor, this.m_connection), true);
                instrumentTreeNode.insert(newChild, i);
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                InstrumentSampleNodeData newNodeData = (InstrumentSampleNodeData)newChild.getUserObject();
                String sampleName = newNodeData.getName();
                this.m_elementMap.put(sampleName, newChild);
                if (newNodeData.isLeased()) {
                    this.m_leasedSampleMap.put(sampleName, newChild);
                    this.m_leasedSampleArray = null;
                }
                if ((lease = this.m_connection.getMaintainedSampleLease(sampleName)) != null) {
                    newNodeData.setLeaseDuration(lease.getLeaseDuration());
                }
            }
            ++i;
        }
        while (i < instrumentTreeNode.getChildCount()) {
            DefaultMutableTreeNode oldChild = (DefaultMutableTreeNode)instrumentTreeNode.getChildAt(i);
            if (!(oldChild.getUserObject() instanceof InstrumentSampleNodeData)) break;
            instrumentTreeNode.remove(i);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
            InstrumentSampleNodeData oldNodeData = (InstrumentSampleNodeData)oldChild.getUserObject();
            String sampleName = oldNodeData.getName();
            this.m_elementMap.remove(sampleName);
            if (!oldNodeData.isLeased()) continue;
            this.m_leasedSampleMap.remove(sampleName);
            this.m_leasedSampleArray = null;
        }
    }

    void updateInstrumentSample(InstrumentSampleDescriptor sampleDescriptor) {
        DefaultMutableTreeNode sampleTreeNode = this.getInstrumentSampleTreeNode(sampleDescriptor.getName());
        if (sampleTreeNode != null) {
            this.updateInstrumentSample(sampleDescriptor, sampleTreeNode);
        }
    }

    void updateInstrumentSample(InstrumentSampleDescriptor sampleDescriptor, DefaultMutableTreeNode sampleTreeNode) {
        ((InstrumentSampleNodeData)sampleTreeNode.getUserObject()).update();
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, sampleTreeNode.getPath(), new int[0], new Object[0]));
    }
}

