/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.altrmi.client.ClientMonitor;
import org.apache.altrmi.client.ConnectionRefusedException;
import org.apache.altrmi.client.Factory;
import org.apache.altrmi.client.HostContext;
import org.apache.altrmi.client.InvocationException;
import org.apache.altrmi.client.impl.ClientSideClassFactory;
import org.apache.altrmi.client.impl.DefaultClientMonitor;
import org.apache.altrmi.client.impl.socket.SocketCustomStreamHostContext;
import org.apache.altrmi.common.ConnectionException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.instrument.client.CreateSampleDialog;
import org.apache.excalibur.instrument.client.InstrumentClientFrame;
import org.apache.excalibur.instrument.client.InstrumentManagerConnectionListener;
import org.apache.excalibur.instrument.client.InstrumentManagerTree;
import org.apache.excalibur.instrument.client.InstrumentManagerTreeModel;
import org.apache.excalibur.instrument.client.InstrumentNodeData;
import org.apache.excalibur.instrument.client.InstrumentSampleFrame;
import org.apache.excalibur.instrument.client.InstrumentSampleNodeData;
import org.apache.excalibur.instrument.client.MaintainedSampleLease;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentManagerClient;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleSnapshot;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleUtils;

class InstrumentManagerConnection
extends JComponent
implements LogEnabled {
    protected final InstrumentClientFrame m_frame;
    private final String m_host;
    private final int m_port;
    private Logger m_logger;
    private boolean m_closed;
    private boolean m_deleted;
    private HostContext m_altrmiHostContext;
    private Factory m_altrmiFactory;
    private InstrumentManagerClient m_manager;
    protected InstrumentManagerTreeModel m_treeModel;
    private InstrumentManagerTree m_tree;
    private final ArrayList m_listeners = new ArrayList();
    private InstrumentManagerConnectionListener[] m_listenerArray = null;
    private long m_lastLeaseRenewalTime;
    private HashMap m_maintainedSampleLeaseMap = new HashMap();
    private MaintainedSampleLease[] m_maintainedSampleLeaseArray = null;
    private HashMap m_sampleFrames = new HashMap();

    InstrumentManagerConnection(InstrumentClientFrame frame, String host, int port) {
        this.m_frame = frame;
        this.m_host = host;
        this.m_port = port;
        this.m_closed = true;
        this.m_treeModel = new InstrumentManagerTreeModel(this);
        this.addInstrumentManagerConnectionListener(this.m_treeModel);
        this.setLayout(new BorderLayout());
        Box topPane = Box.createVerticalBox();
        JPanel labels = new JPanel();
        labels.setLayout(new FlowLayout(0));
        JLabel hostLabelLabel = new JLabel("Host: ");
        labels.add(hostLabelLabel);
        JLabel hostLabel = new JLabel(this.getHost());
        hostLabel.setForeground(Color.black);
        labels.add(hostLabel);
        JLabel portLabelLabel = new JLabel("  Port: ");
        labels.add(portLabelLabel);
        JLabel portLabel = new JLabel(Integer.toString(this.getPort()));
        portLabel.setForeground(Color.black);
        labels.add(portLabel);
        topPane.add(labels);
        AbstractAction gcAction = new AbstractAction("Invoke GC"){

            public void actionPerformed(ActionEvent event) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).invokeGC();
                    }
                });
            }

            static /* synthetic */ InstrumentManagerConnection access$000(1 x0) {
                return x0.InstrumentManagerConnection.this;
            }
        };
        JButton gcButton = new JButton(gcAction);
        AbstractAction refreshAction = new AbstractAction("Refresh"){

            public void actionPerformed(ActionEvent event) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        3.access$100(this.this$1).getTreeModel().refreshModel();
                    }
                });
            }

            static /* synthetic */ InstrumentManagerConnection access$100(3 x0) {
                return x0.InstrumentManagerConnection.this;
            }
        };
        JButton refreshButton = new JButton(refreshAction);
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(0));
        buttons.add(gcButton);
        buttons.add(refreshButton);
        topPane.add(buttons);
        this.add((Component)topPane, "North");
        this.m_tree = new InstrumentManagerTree(this);
        this.add((Component)this.m_tree, "Center");
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger.getChildLogger("conn_" + this.m_host + "_" + this.m_port);
        this.m_treeModel.enableLogging(this.m_logger.getChildLogger("treeModel"));
    }

    Logger getLogger() {
        return this.m_logger;
    }

    String getTabTitle() {
        String tabTitle;
        InstrumentManagerClient manager2 = this.m_manager;
        if (manager2 == null) {
            tabTitle = "[Not Connected]";
        } else {
            try {
                tabTitle = manager2.getDescription();
            }
            catch (InvocationException e) {
                tabTitle = "[Not Connected]";
            }
        }
        return tabTitle;
    }

    String getHost() {
        return this.m_host;
    }

    int getPort() {
        return this.m_port;
    }

    String getTitle() {
        return this.getTabTitle() + " (" + this.m_host + ":" + this.m_port + ")";
    }

    InstrumentManagerClient getInstrumentManagerClient() {
        return this.m_manager;
    }

    InstrumentManagerTreeModel getTreeModel() {
        return this.m_treeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaintainedSampleLease[] getMaintainedSampleLeaseArray() {
        MaintainedSampleLease[] array = this.m_maintainedSampleLeaseArray;
        if (array == null) {
            InstrumentManagerConnection instrumentManagerConnection = this;
            synchronized (instrumentManagerConnection) {
                this.m_maintainedSampleLeaseArray = new MaintainedSampleLease[this.m_maintainedSampleLeaseMap.size()];
                this.m_maintainedSampleLeaseMap.values().toArray(this.m_maintainedSampleLeaseArray);
                array = this.m_maintainedSampleLeaseArray;
            }
        }
        return array;
    }

    void handleLeasedSamples() {
        long now = System.currentTimeMillis();
        if (now - this.m_lastLeaseRenewalTime > 60000L) {
            MaintainedSampleLease[] leases = this.getMaintainedSampleLeaseArray();
            int i = 0;
            while (i < leases.length) {
                MaintainedSampleLease lease = leases[i];
                DefaultMutableTreeNode sampleTreeNode = this.m_treeModel.getInstrumentSampleTreeNode(lease.getSampleName());
                if (sampleTreeNode == null) {
                    DefaultMutableTreeNode instrumentTreeNode = this.m_treeModel.getInstrumentTreeNode(lease.getInstrumentName());
                    if (instrumentTreeNode != null) {
                        InstrumentDescriptor instrumentDescriptor = ((InstrumentNodeData)instrumentTreeNode.getUserObject()).getDescriptor();
                        try {
                            instrumentDescriptor.createInstrumentSample(lease.getDescription(), lease.getInterval(), lease.getSize(), lease.getLeaseDuration(), lease.getType());
                            this.m_treeModel.updateInstrument(instrumentDescriptor, instrumentTreeNode, -1);
                        }
                        catch (InvocationException e) {
                            this.close();
                        }
                    }
                } else {
                    InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)sampleTreeNode.getUserObject();
                    InstrumentSampleDescriptor sampleDescriptor = sampleNodeData.getDescriptor();
                    try {
                        long newExpireTime = sampleDescriptor.extendLease(lease.getLeaseDuration());
                        sampleNodeData.setLeaseExpireTime(newExpireTime);
                        this.m_treeModel.updateInstrumentSample(sampleDescriptor, sampleTreeNode);
                    }
                    catch (InvocationException e) {
                        this.close();
                    }
                }
                ++i;
            }
            this.m_treeModel.renewAllSampleLeases();
            this.m_lastLeaseRenewalTime = now;
        }
        this.m_treeModel.purgeExpiredSamples();
    }

    void open() throws ConnectionException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Attempt to open a new connection to " + this.m_host + ":" + this.m_port);
        }
        SocketCustomStreamHostContext altrmiHostContext = new SocketCustomStreamHostContext(this.m_host, this.m_port);
        altrmiHostContext.setClientMonitor((ClientMonitor)new DefaultClientMonitor(0));
        this.m_altrmiHostContext = altrmiHostContext;
        this.m_altrmiFactory = new ClientSideClassFactory(false);
        this.m_altrmiFactory.setHostContext((HostContext)altrmiHostContext);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Connected.  Listing Published Altrmi Objects At Server...");
        }
        String[] listOfPublishedObjectsOnServer = this.m_altrmiFactory.list();
        int i = 0;
        while (i < listOfPublishedObjectsOnServer.length) {
            this.getLogger().debug("  [" + i + "]:" + listOfPublishedObjectsOnServer[i]);
            ++i;
        }
        this.m_manager = (InstrumentManagerClient)this.m_altrmiFactory.lookup("InstrumentManagerClient");
        this.m_closed = false;
        InstrumentManagerConnectionListener[] listenerArray = this.getListenerArray();
        int i2 = 0;
        while (i2 < listenerArray.length) {
            listenerArray[i2].opened(this);
            ++i2;
        }
    }

    void tryOpen() {
        block5: {
            try {
                this.open();
            }
            catch (ConnectionRefusedException e) {
                this.getLogger().debug("Connection refused.  Server not running?");
            }
            catch (ConnectionException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Unable to open connection.  Got an unexpected Altrmi exception.", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!this.getLogger().isDebugEnabled()) break block5;
                this.getLogger().debug("Unable to open connection.  Got an unexpected IO exception.", (Throwable)e);
            }
        }
    }

    boolean isClosed() {
        return this.m_closed;
    }

    void close() {
        this.getLogger().debug("close()");
        if (!this.m_closed) {
            this.m_closed = true;
            this.m_manager = null;
            this.m_altrmiFactory.close();
            this.m_altrmiFactory = null;
            this.m_altrmiHostContext = null;
        }
        InstrumentManagerConnectionListener[] listenerArray = this.getListenerArray();
        int i = 0;
        while (i < listenerArray.length) {
            listenerArray[i].closed(this);
            ++i;
        }
    }

    boolean isDeleted() {
        return this.m_deleted;
    }

    void delete() {
        this.getLogger().debug("delete()");
        this.close();
        this.m_deleted = true;
        InstrumentManagerConnectionListener[] listenerArray = this.getListenerArray();
        int i = 0;
        while (i < listenerArray.length) {
            listenerArray[i].deleted(this);
            ++i;
        }
    }

    boolean ping() {
        InstrumentManagerClient manager2 = this.m_manager;
        if (manager2 != null) {
            try {
                manager2.getName();
                return true;
            }
            catch (InvocationException e) {
                this.getLogger().debug("Ping Failed.", (Throwable)e);
                this.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInstrumentManagerConnectionListener(InstrumentManagerConnectionListener listener) {
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            this.m_listeners.add(listener);
            this.m_listenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInstrumentManagerConnectionListener(InstrumentManagerConnectionListener listener) {
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            this.m_listeners.remove(listener);
            this.m_listenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentManagerConnectionListener[] getListenerArray() {
        InstrumentManagerConnectionListener[] listenerArray = this.m_listenerArray;
        if (listenerArray == null) {
            InstrumentManagerConnection instrumentManagerConnection = this;
            synchronized (instrumentManagerConnection) {
                this.m_listenerArray = new InstrumentManagerConnectionListener[this.m_listeners.size()];
                this.m_listeners.toArray(this.m_listenerArray);
                listenerArray = this.m_listenerArray;
            }
        }
        return listenerArray;
    }

    private InstrumentSampleFrame getSampleFrame(String sampleName) {
        this.getLogger().debug("InstrumentManagerConnection.getSampleFrame(" + sampleName + ")");
        return (InstrumentSampleFrame)this.m_sampleFrames.get(sampleName);
    }

    private void addSampleFrame(String sampleName, InstrumentSampleFrame sampleFrame) {
        this.getLogger().debug("InstrumentManagerConnection.addSampleFrame(" + sampleName + ", frame)");
        this.m_sampleFrames.put(sampleName, sampleFrame);
    }

    private void removeSampleFrame(String sampleName) {
        this.getLogger().debug("InstrumentManagerConnection.removeSampleFrame(" + sampleName + ")");
        this.m_sampleFrames.remove(sampleName);
    }

    void instrumentCreateSample(final InstrumentDescriptor instrumentDescriptor) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CreateSampleDialog dialog = new CreateSampleDialog(InstrumentManagerConnection.this.m_frame, instrumentDescriptor);
                dialog.setSampleDescription("Each Second");
                dialog.setInterval(1000L);
                dialog.setSampleCount(600);
                dialog.setLeaseTime(600L);
                dialog.setMaintainLease(true);
                dialog.show();
                if (dialog.getAction() == 1) {
                    InstrumentManagerConnection.this.getLogger().debug("New Sample: desc=" + dialog.getSampleDescription() + ", interval=" + dialog.getInterval() + ", size=" + dialog.getSampleCount() + ", lease=" + dialog.getLeaseTime() + ", type=" + dialog.getSampleType());
                    instrumentDescriptor.createInstrumentSample(dialog.getSampleDescription(), dialog.getInterval(), dialog.getSampleCount(), dialog.getLeaseTime(), dialog.getSampleType());
                    InstrumentManagerConnection.this.m_treeModel.updateInstrument(instrumentDescriptor);
                    InstrumentSampleNodeData sampleNodeData = InstrumentManagerConnection.this.startMaintainingSample(instrumentDescriptor.getName(), dialog.getSampleType(), dialog.getInterval(), dialog.getSampleCount(), dialog.getLeaseTime(), dialog.getSampleDescription());
                    if (sampleNodeData != null) {
                        InstrumentManagerConnection.this.viewSample(sampleNodeData);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadSampleFrame(Configuration sampleFrameState) throws ConfigurationException {
        String sampleName = sampleFrameState.getAttribute("sample");
        this.getLogger().debug("Loading sample frame: " + sampleName);
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            InstrumentSampleFrame sampleFrame = this.getSampleFrame(sampleName);
            if (sampleFrame != null) {
                sampleFrame.hideFrame();
                sampleFrame = null;
            }
            sampleFrame = new InstrumentSampleFrame(sampleFrameState, this, this.m_frame);
            this.addSampleFrame(sampleName, sampleFrame);
            sampleFrame.addToDesktop(this.m_frame.getDesktopPane());
            sampleFrame.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void viewSample(InstrumentSampleNodeData sampleNodeData) {
        InstrumentSampleFrame sampleFrame;
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            String sampleName = sampleNodeData.getName();
            sampleFrame = this.getSampleFrame(sampleName);
            if (sampleFrame == null) {
                sampleFrame = new InstrumentSampleFrame(this, sampleName, this.m_frame);
                this.addSampleFrame(sampleName, sampleFrame);
                sampleFrame.addToDesktop(this.m_frame.getDesktopPane());
            }
        }
        sampleFrame.show();
        if (sampleFrame.isIcon()) {
            try {
                sampleFrame.setIcon(false);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        try {
            sampleFrame.setSelected(true);
        }
        catch (PropertyVetoException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideSampleFrame(InstrumentSampleFrame sampleFrame) {
        String sampleName = sampleFrame.getInstrumentSampleName();
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            this.removeSampleFrame(sampleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstrumentSampleNodeData startMaintainingSample(String instrumentName, int type, long interval, int size, long leaseDuration, String description) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startMaintainingSample(" + instrumentName + ", " + type + ", " + interval + ", " + size + ", " + leaseDuration + ", " + description + ")");
        }
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            InstrumentSampleNodeData sampleNodeData;
            MaintainedSampleLease sampleLease = new MaintainedSampleLease(instrumentName, type, interval, size, leaseDuration, description);
            String sampleName = sampleLease.getSampleName();
            this.m_maintainedSampleLeaseMap.put(sampleName, sampleLease);
            this.m_maintainedSampleLeaseArray = null;
            this.m_lastLeaseRenewalTime = 0L;
            DefaultMutableTreeNode sampleTreeNode = this.m_treeModel.getInstrumentSampleTreeNode(sampleName);
            if (sampleTreeNode != null) {
                sampleNodeData = (InstrumentSampleNodeData)sampleTreeNode.getUserObject();
                sampleNodeData.setLeaseDuration(leaseDuration);
                sampleNodeData.setDescription(description);
                this.m_treeModel.updateInstrumentSample(sampleNodeData.getDescriptor(), sampleTreeNode);
            } else {
                sampleNodeData = null;
            }
            return sampleNodeData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopMaintainingSample(String sampleName) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("stopMaintainingSample(" + sampleName + ")");
        }
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            this.m_maintainedSampleLeaseMap.remove(sampleName);
            this.m_maintainedSampleLeaseArray = null;
            DefaultMutableTreeNode sampleTreeNode = this.m_treeModel.getInstrumentSampleTreeNode(sampleName);
            if (sampleTreeNode != null) {
                InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)sampleTreeNode.getUserObject();
                sampleNodeData.setLeaseDuration(0L);
                this.m_treeModel.updateInstrumentSample(sampleNodeData.getDescriptor(), sampleTreeNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MaintainedSampleLease getMaintainedSampleLease(String sampleName) {
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            return (MaintainedSampleLease)this.m_maintainedSampleLeaseMap.get(sampleName);
        }
    }

    protected void invokeGC() {
        block2: {
            InstrumentManagerClient manager2 = this.getInstrumentManagerClient();
            if (manager2 == null) break block2;
            try {
                manager2.invokeGarbageCollection();
            }
            catch (InvocationException e) {
                this.getLogger().warn("Error executing GC on " + this.getHost() + ":" + this.getPort() + ": " + e.getMessage());
            }
        }
    }

    DefaultMutableTreeNode getInstrumentSampleTreeNode(String sampleName) {
        return this.m_treeModel.getInstrumentSampleTreeNode(sampleName);
    }

    InstrumentSampleSnapshot getInstrumentSampleSnapshot(String sampleName) {
        DefaultMutableTreeNode sampleNode = this.getInstrumentSampleTreeNode(sampleName);
        if (sampleNode == null) {
            return null;
        }
        InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)sampleNode.getUserObject();
        InstrumentSampleDescriptor sampleDescriptor = sampleNodeData.getDescriptor();
        if (sampleDescriptor == null) {
            return null;
        }
        try {
            return sampleDescriptor.getSnapshot();
        }
        catch (InvocationException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Configuration saveState() {
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            DefaultConfiguration state = new DefaultConfiguration("connection", "-");
            state.setAttribute("host", this.m_host);
            state.setAttribute("port", Integer.toString(this.m_port));
            MaintainedSampleLease[] samples = this.getMaintainedSampleLeaseArray();
            int i = 0;
            while (i < samples.length) {
                state.addChild(samples[i].saveState());
                ++i;
            }
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadState(Configuration state) throws ConfigurationException {
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            Configuration[] sampleConfs = state.getChildren("maintained-sample");
            int i = 0;
            while (i < sampleConfs.length) {
                Configuration sampleConf = sampleConfs[i];
                String instrumentName = sampleConf.getAttribute("instrument-name");
                int sampleType = InstrumentSampleUtils.resolveInstrumentSampleType((String)sampleConf.getAttribute("type"));
                long sampleInterval = sampleConf.getAttributeAsLong("interval");
                int sampleSize = sampleConf.getAttributeAsInteger("size");
                long sampleLeaseDuration = sampleConf.getAttributeAsLong("lease-duration");
                String sampleDescription = sampleConf.getAttribute("description");
                this.startMaintainingSample(instrumentName, sampleType, sampleInterval, sampleSize, sampleLeaseDuration, sampleDescription);
                ++i;
            }
        }
    }
}

