/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.instrument.client.AbstractInternalFrame;
import org.apache.excalibur.instrument.client.ConnectDialog;
import org.apache.excalibur.instrument.client.DesktopPane;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.InstrumentManagerConnectionListener;
import org.apache.excalibur.instrument.client.InstrumentSampleFrame;
import org.apache.excalibur.instrument.client.MenuBar;
import org.apache.excalibur.instrument.client.StatusBar;

class InstrumentClientFrame
extends JFrame
implements Runnable,
InstrumentManagerConnectionListener,
LogEnabled {
    static final String SHUTDOWN_HOOK_NAME = "InstrumentClientShutdownHook";
    private String m_title;
    private JTabbedPane m_connectionsPane;
    private JDesktopPane m_desktopPane;
    private JSplitPane m_splitPane;
    private MenuBar m_menuBar;
    private StatusBar m_statusBar;
    private File m_desktopFile;
    private File m_desktopFileDir;
    private HashMap m_connections = new HashMap();
    private InstrumentManagerConnection[] m_connectionArray;
    private Thread m_hook;
    private Thread m_runner;
    private Logger m_logger;
    static /* synthetic */ Class class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer;

    InstrumentClientFrame(String title) {
        this.m_title = title;
        this.init();
        this.m_runner = new Thread((Runnable)this, "InstrumentClientFrameRunner");
        this.m_runner.start();
        ClassLoader cl = (class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer == null ? (class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer = InstrumentClientFrame.class$("org.apache.excalibur.instrument.client.InstrumentManagerTreeCellRenderer")) : class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer).getClassLoader();
        this.setIconImage(new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/client.gif")).getImage());
    }

    public void run() {
        while (this.m_runner != null) {
            try {
                block11: {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        if (this.m_runner != null) break block11;
                        return;
                    }
                }
                InstrumentManagerConnection[] connectionArray = this.getInstrumentManagerConnections();
                int i = 0;
                while (i < connectionArray.length) {
                    InstrumentManagerConnection connection = connectionArray[i];
                    if (connection.isClosed()) {
                        connection.tryOpen();
                    } else if (connection.ping()) {
                        connection.handleLeasedSamples();
                    }
                    ++i;
                }
                JInternalFrame[] frames = this.m_desktopPane.getAllFrames();
                int i2 = 0;
                while (i2 < frames.length) {
                    JInternalFrame frame = frames[i2];
                    if (frame instanceof InstrumentSampleFrame) {
                        ((InstrumentSampleFrame)frame).update();
                    }
                    ++i2;
                }
            }
            catch (Throwable t) {
                this.getLogger().error("Unexpected error caught in InstrumentClientFrame runner:", t);
            }
        }
    }

    public void opened(InstrumentManagerConnection connection) {
        int tabIndex = this.m_connectionsPane.indexOfComponent(connection);
        if (tabIndex >= 0) {
            this.m_connectionsPane.setTitleAt(tabIndex, connection.getTabTitle());
            this.m_connectionsPane.setToolTipTextAt(tabIndex, connection.getTitle());
        }
    }

    public void closed(InstrumentManagerConnection connection) {
        int tabIndex = this.m_connectionsPane.indexOfComponent(connection);
        if (tabIndex >= 0) {
            this.m_connectionsPane.setTitleAt(tabIndex, connection.getTabTitle());
            this.m_connectionsPane.setToolTipTextAt(tabIndex, connection.getTitle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(InstrumentManagerConnection connection) {
        int tabIndex = this.m_connectionsPane.indexOfComponent(connection);
        if (tabIndex >= 0 && Thread.currentThread() != this.m_hook) {
            this.m_connectionsPane.remove(connection);
        }
        connection.removeInstrumentManagerConnectionListener(this);
        String key = connection.getHost() + ":" + connection.getPort();
        HashMap hashMap = this.m_connections;
        synchronized (hashMap) {
            this.m_connections.remove(key);
            this.m_connectionArray = null;
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    Logger getLogger() {
        return this.m_logger;
    }

    void setDefaultStateFile(File defaultStateFile) {
        File defaultStateFileDir = defaultStateFile.getParentFile();
        if (defaultStateFileDir.exists()) {
            this.m_desktopFileDir = defaultStateFileDir;
        }
        if (defaultStateFile.exists()) {
            try {
                this.m_desktopFile = null;
                this.loadStateFromFile(defaultStateFile, true);
                this.m_desktopFile = defaultStateFile;
            }
            catch (Exception e) {
                this.showErrorDialog("Unable to load desktop file.", e);
            }
            this.updateTitle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadStateFromFile(File stateFile, boolean showErrorDialog) throws Exception {
        long now = System.currentTimeMillis();
        this.getLogger().debug("Loading Instrument Client state from: " + stateFile.getAbsolutePath());
        FileInputStream is = new FileInputStream(stateFile);
        try {
            this.loadStateFromStream(is, showErrorDialog);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            is.close();
            throw throwable;
        }
        is.close();
        this.getLogger().debug("Loading Instrument Client state took " + (System.currentTimeMillis() - now) + "ms.");
    }

    void loadStateFromStream(InputStream is, boolean showErrorDialog) throws Exception {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration stateConfig = builder.build(is);
        this.loadStateFromConfiguration(stateConfig, showErrorDialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadStateFromConfiguration(Configuration state, boolean showErrorDialog) throws ConfigurationException {
        String msg;
        try {
            Configuration frameState = state.getChild("frame");
            this.setLocation(frameState.getAttributeAsInteger("x"), frameState.getAttributeAsInteger("y"));
            this.setSize(frameState.getAttributeAsInteger("width"), frameState.getAttributeAsInteger("height"));
            if (frameState.getAttributeAsBoolean("iconized", false)) {
                this.setState(1);
            }
            this.m_splitPane.setDividerLocation(frameState.getAttributeAsInteger("divider-location"));
            this.m_splitPane.setLastDividerLocation(frameState.getAttributeAsInteger("last-divider-location"));
        }
        catch (ConfigurationException e) {
            String msg2 = "Unable to fully load the frame state.";
            if (showErrorDialog) {
                this.showErrorDialog(msg2, e);
            }
            this.getLogger().warn(msg2, (Throwable)e);
        }
        this.show();
        Configuration[] connConfs = state.getChildren("connection");
        int i = 0;
        while (i < connConfs.length) {
            InstrumentManagerConnection connection;
            Configuration connConf = connConfs[i];
            String host = connConf.getAttribute("host");
            int port = connConf.getAttributeAsInteger("port");
            String key = this.getInstrumentManagerConnectionKey(host, port);
            HashMap hashMap = this.m_connections;
            synchronized (hashMap) {
                connection = (InstrumentManagerConnection)this.m_connections.get(key);
                if (connection == null) {
                    connection = this.createInstrumentManagerConnection(host, port);
                }
            }
            try {
                connection.loadState(connConf);
            }
            catch (ConfigurationException e) {
                msg = "Unable to fully load the state of connection, " + key;
                if (showErrorDialog) {
                    this.showErrorDialog(msg, e);
                }
                this.getLogger().warn(msg, (Throwable)e);
            }
            ++i;
        }
        Configuration[] frameConfs = state.getChildren("inner-frame");
        int i2 = 0;
        while (i2 < frameConfs.length) {
            block22: {
                Configuration frameConf = frameConfs[i2];
                String type = frameConf.getAttribute("type");
                if (type.equals("sample-frame")) {
                    int port;
                    String host = frameConf.getAttribute("host");
                    InstrumentManagerConnection connection = this.getInstrumentManagerConnection(host, port = frameConf.getAttributeAsInteger("port"));
                    if (connection == null) {
                        msg = "Sample frame not being loaded becase no connection to " + host + ":" + port + " exists.";
                        if (showErrorDialog) {
                            this.showErrorDialog(msg);
                        } else {
                            this.getLogger().warn(msg);
                        }
                    } else {
                        try {
                            connection.loadSampleFrame(frameConf);
                        }
                        catch (ConfigurationException e) {
                            String msg3 = "Unable to fully load the state of an inner frame for sample: " + frameConf.getAttribute("sample", "Sample name missing");
                            if (showErrorDialog) {
                                this.showErrorDialog(msg3, e);
                                break block22;
                            }
                            this.getLogger().warn(msg3, (Throwable)e);
                        }
                    }
                } else {
                    this.getLogger().warn("Not loading inner frame due to unknown type: " + type);
                }
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveStateToFile(File stateFile) throws Exception {
        byte[] data;
        long now = System.currentTimeMillis();
        this.getLogger().debug("Saving Instrument Client state to: " + stateFile.getAbsolutePath());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.saveStateToStream(os);
            data = os.toByteArray();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            os.close();
            throw throwable;
        }
        os.close();
        File renameFile = null;
        boolean success = false;
        if (stateFile.exists()) {
            renameFile = new File(stateFile.getAbsolutePath() + "." + now + ".backup");
            stateFile.renameTo(renameFile);
        }
        FileOutputStream fos = new FileOutputStream(stateFile);
        try {
            fos.write(data);
            success = true;
        }
        finally {
            fos.close();
            if (!success) {
                stateFile.delete();
            }
            if (renameFile != null) {
                if (success) {
                    renameFile.delete();
                } else {
                    renameFile.renameTo(stateFile);
                }
            }
        }
        this.getLogger().debug("Saving Instrument Client state took " + (System.currentTimeMillis() - now) + "ms.");
    }

    void saveStateToStream(OutputStream os) throws Exception {
        Configuration stateConfig = this.saveStateToConfiguration();
        DefaultConfigurationSerializer serializer = new DefaultConfigurationSerializer();
        serializer.setIndent(true);
        serializer.serialize(os, stateConfig);
    }

    Configuration saveStateToConfiguration() {
        DefaultConfiguration state = new DefaultConfiguration("instrument-client-state", "-");
        DefaultConfiguration frameState = new DefaultConfiguration("frame", "-");
        frameState.setAttribute("x", Integer.toString(this.getX()));
        frameState.setAttribute("y", Integer.toString(this.getY()));
        frameState.setAttribute("width", Integer.toString(this.getWidth()));
        frameState.setAttribute("height", Integer.toString(this.getHeight()));
        if (this.getState() == 1) {
            frameState.setAttribute("iconized", "true");
        }
        frameState.setAttribute("divider-location", Integer.toString(this.m_splitPane.getDividerLocation()));
        frameState.setAttribute("last-divider-location", Integer.toString(this.m_splitPane.getLastDividerLocation()));
        state.addChild((Configuration)frameState);
        InstrumentManagerConnection[] connections = this.getInstrumentManagerConnections();
        int i = 0;
        while (i < connections.length) {
            state.addChild(connections[i].saveState());
            ++i;
        }
        JInternalFrame[] frames = this.m_desktopPane.getAllFrames();
        int i2 = 0;
        while (i2 < frames.length) {
            if (frames[i2] instanceof AbstractInternalFrame) {
                AbstractInternalFrame internalFrame = (AbstractInternalFrame)frames[i2];
                state.addChild(internalFrame.getState());
            }
            ++i2;
        }
        return state;
    }

    private void init() {
        this.updateTitle();
        this.m_hook = new Thread(SHUTDOWN_HOOK_NAME){

            public void run() {
                InstrumentClientFrame.this.getLogger().debug("InstrumentClientFrame.shutdownHook start");
                InstrumentClientFrame.this.shutdown();
                InstrumentClientFrame.this.getLogger().debug("InstrumentClientFrame.shutdownHook end");
            }
        };
        Runtime.getRuntime().addShutdownHook(this.m_hook);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                InstrumentClientFrame.this.fileExit();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.m_connectionsPane = new JTabbedPane(1);
        this.m_desktopPane = new DesktopPane();
        JPanel dBorder = new JPanel();
        dBorder.setBorder(new BevelBorder(1));
        dBorder.setLayout(new BorderLayout());
        dBorder.add((Component)this.m_desktopPane, "Center");
        this.m_splitPane = new JSplitPane(1, true, this.m_connectionsPane, dBorder);
        this.m_splitPane.setOneTouchExpandable(true);
        this.m_splitPane.setDividerLocation(250);
        this.getContentPane().add((Component)this.m_splitPane, "Center");
        this.m_menuBar = new MenuBar(this);
        this.setJMenuBar(this.m_menuBar);
        this.m_statusBar = new StatusBar();
        this.getContentPane().add((Component)this.m_statusBar, "South");
        Toolkit toolkit = this.getToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        this.setLocation(20, 20);
        this.setSize((int)((double)screenSize.width * 0.9), (int)((double)screenSize.height * 0.9));
    }

    private void updateTitle() {
        if (this.m_desktopFile == null) {
            this.setTitle(this.m_title);
        } else {
            this.setTitle(this.m_title + " - " + this.m_desktopFile.getAbsolutePath());
        }
    }

    void setStatusMessage(String message) {
        this.m_statusBar.setStatusMessage(message);
    }

    JDesktopPane getDesktopPane() {
        return this.m_desktopPane;
    }

    void closeAllFrames() {
        JInternalFrame[] frames = this.m_desktopPane.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            frames[i].setVisible(false);
            frames[i].dispose();
            ++i;
        }
    }

    void tileFrames() {
        JInternalFrame[] openFrames = this.getOpenFrames();
        int count = openFrames.length;
        if (count == 0) {
            return;
        }
        float targetRatio = 5.0f;
        Dimension size = this.getDesktopPane().getSize();
        int cols = 1;
        int rows = count;
        int frameWidth = size.width / cols;
        int frameHeight = size.height / rows;
        float ratio = (float)frameWidth / (float)frameHeight;
        while (rows > 1 && (ratio > targetRatio || frameHeight < 70 && frameWidth > 100)) {
            rows = (int)Math.ceil((float)count / (float)(++cols));
            frameWidth = size.width / cols;
            frameHeight = size.height / rows;
            ratio = (float)frameWidth / (float)frameHeight;
        }
        this.reorganizeFrames(rows, cols, openFrames);
    }

    JInternalFrame[] getOpenFrames() {
        JInternalFrame[] frames = this.m_desktopPane.getAllFrames();
        int count = frames.length;
        if (count == 0) {
            return frames;
        }
        ArrayList<JInternalFrame> openFrames = new ArrayList<JInternalFrame>();
        int i = 0;
        while (i < count) {
            JInternalFrame f = frames[i];
            if (!f.isClosed() && !f.isIcon()) {
                openFrames.add(f);
            }
            ++i;
        }
        frames = new JInternalFrame[openFrames.size()];
        openFrames.toArray(frames);
        return frames;
    }

    void reorganizeFrames(int rows, int cols, JInternalFrame[] frames) {
        Dimension desktopsize = this.m_desktopPane.getSize();
        int w = desktopsize.width / cols;
        int h = desktopsize.height / rows;
        int x = 0;
        int y = 0;
        int count = frames.length;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols && i * cols + j < count) {
                JInternalFrame f = frames[i * cols + j];
                this.m_desktopPane.getDesktopManager().resizeFrame(f, x, y, w, h);
                x += w;
                ++j;
            }
            y += h;
            x = 0;
            ++i;
        }
    }

    void tileFramesH() {
        JInternalFrame[] openFrames = this.getOpenFrames();
        int count = openFrames.length;
        if (count == 0) {
            return;
        }
        this.reorganizeFrames(count, 1, openFrames);
    }

    void tileFramesV() {
        JInternalFrame[] openFrames = this.getOpenFrames();
        int count = openFrames.length;
        if (count == 0) {
            return;
        }
        this.reorganizeFrames(1, count, openFrames);
    }

    InstrumentManagerConnection[] getInstrumentManagerConnections() {
        InstrumentManagerConnection[] array = this.m_connectionArray;
        if (array == null) {
            array = this.updateInstrumentManagerConnectionArray();
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentManagerConnection[] updateInstrumentManagerConnectionArray() {
        InstrumentClientFrame instrumentClientFrame = this;
        synchronized (instrumentClientFrame) {
            InstrumentManagerConnection[] array = new InstrumentManagerConnection[this.m_connections.size()];
            this.m_connections.values().toArray(array);
            this.m_connectionArray = array;
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstrumentManagerConnection getInstrumentManagerConnection(String host, int port) {
        String key = host + ":" + port;
        HashMap hashMap = this.m_connections;
        synchronized (hashMap) {
            return (InstrumentManagerConnection)this.m_connections.get(key);
        }
    }

    void showConnectDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectDialog dialog = new ConnectDialog(InstrumentClientFrame.this);
                dialog.setHost("localhost");
                dialog.setPort(15555);
                dialog.show();
                if (dialog.getAction() == 1) {
                    InstrumentClientFrame.this.openInstrumentManagerConnection(dialog.getHost(), dialog.getPort());
                }
            }
        });
    }

    private String getInstrumentManagerConnectionKey(String host, int port) {
        return host + ":" + port;
    }

    private InstrumentManagerConnection createInstrumentManagerConnection(String host, int port) {
        String key = this.getInstrumentManagerConnectionKey(host, port);
        InstrumentManagerConnection connection = new InstrumentManagerConnection(this, host, port);
        connection.enableLogging(this.getLogger());
        this.m_connections.put(key, connection);
        this.m_connectionArray = null;
        connection.addInstrumentManagerConnectionListener(this);
        this.m_connectionsPane.add(connection.getTabTitle(), connection);
        return connection;
    }

    void openInstrumentManagerConnection(final String host, final int port) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String key = InstrumentClientFrame.this.getInstrumentManagerConnectionKey(host, port);
                HashMap hashMap = InstrumentClientFrame.this.m_connections;
                synchronized (hashMap) {
                    InstrumentManagerConnection connection = (InstrumentManagerConnection)InstrumentClientFrame.this.m_connections.get(key);
                    if (connection == null) {
                        InstrumentClientFrame.this.createInstrumentManagerConnection(host, port);
                        return;
                    }
                }
                InstrumentClientFrame.this.showErrorDialog("A connection to " + key + " already exists.");
            }
        });
    }

    private void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this, "<html><body><font color=\"black\">" + message + "</font>" + "</body></html>", this.m_title + " Error", 0);
    }

    private void showErrorDialog(String message, Throwable t) {
        JOptionPane.showMessageDialog(this, "<html><body><font color=\"black\">" + message + "</font><br><br><font color=\"black\">Reason: " + t.getMessage() + "</font></body></html>", this.m_title + " Error", 0);
    }

    private void shutdown() {
        this.getLogger().debug("InstrumentClientFrame.shutdown()");
        boolean fallThrough = false;
        if (this.m_hook != null) {
            if (this.m_hook == Thread.currentThread()) {
                fallThrough = true;
            } else {
                Runtime.getRuntime().removeShutdownHook(this.m_hook);
                this.m_hook = null;
            }
        }
        this.m_runner.interrupt();
        this.m_runner = null;
        InstrumentManagerConnection[] connections = this.getInstrumentManagerConnections();
        int i = 0;
        while (i < connections.length) {
            connections[i].delete();
            ++i;
        }
        if (!fallThrough) {
            System.exit(1);
        }
    }

    void fileNew() {
        this.m_desktopFile = null;
        this.closeAllFrames();
        this.updateTitle();
    }

    void fileOpen() {
        JFileChooser chooser = new JFileChooser();
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".desktop");
            }

            public String getDescription() {
                return "Desktop state files";
            }
        };
        if (this.m_desktopFileDir != null) {
            chooser.setCurrentDirectory(this.m_desktopFileDir);
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                this.m_desktopFile = null;
                File file = chooser.getSelectedFile();
                this.m_desktopFileDir = file.getParentFile();
                this.loadStateFromFile(file, true);
                this.m_desktopFile = file;
            }
            catch (Exception e) {
                this.showErrorDialog("Unable to load desktop file.", e);
            }
            this.updateTitle();
        }
    }

    void fileSave() {
        if (this.m_desktopFile != null) {
            try {
                this.saveStateToFile(this.m_desktopFile);
            }
            catch (Exception e) {
                this.showErrorDialog("Unable to save desktop file.", e);
            }
        } else {
            this.fileSaveAs();
        }
    }

    void fileSaveAs() {
        JFileChooser chooser = new JFileChooser();
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".desktop");
            }

            public String getDescription() {
                return "Desktop state files";
            }
        };
        if (this.m_desktopFileDir != null) {
            chooser.setCurrentDirectory(this.m_desktopFileDir);
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            if (file.getName().indexOf(46) < 0) {
                file = new File(file.getAbsolutePath() + ".desktop");
            }
            try {
                this.saveStateToFile(file);
                this.m_desktopFile = file;
                this.m_desktopFileDir = this.m_desktopFile.getParentFile();
            }
            catch (Exception e) {
                this.showErrorDialog("Unable to save desktop file.", e);
            }
            this.updateTitle();
        }
    }

    void fileExit() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstrumentClientFrame.this.shutdown();
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

