/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.Component;
import java.awt.Container;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.excalibur.instrument.client.AbstractTabularOptionDialog;
import org.apache.excalibur.instrument.client.InstrumentClientFrame;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentDescriptor;

class CreateSampleDialog
extends AbstractTabularOptionDialog {
    private InstrumentDescriptor m_instrumentDescriptor;
    private JTextField m_instrumentNameField;
    private JTextField m_instrumentDescriptionField;
    private JTextField m_sampleDescriptionField;
    private String m_sampleDescription;
    private JTextField m_intervalField;
    private long m_interval;
    private JTextField m_sizeField;
    private int m_size;
    private JTextField m_leaseTimeField;
    private long m_leaseTime;
    private JCheckBox m_maintainLeaseCheckBox;
    private Container m_sampleTypePanel;
    private ButtonGroup m_sampleTypeGroup;
    private int m_sampleType;
    private JRadioButton m_sampleTypeCounter;
    private JRadioButton m_sampleTypeMaximum;
    private JRadioButton m_sampleTypeMinimum;
    private JRadioButton m_sampleTypeMean;

    CreateSampleDialog(InstrumentClientFrame frame, InstrumentDescriptor instrumentDescriptor) {
        super(frame, "Create Instrument Sample", 3);
        this.m_instrumentDescriptor = instrumentDescriptor;
        this.m_instrumentNameField.setText(this.m_instrumentDescriptor.getName());
        this.m_instrumentDescriptionField.setText(this.m_instrumentDescriptor.getDescription());
        this.buildSampleTypeComponent();
        this.pack();
    }

    protected String getMessage() {
        return "Please enter the parameters for the sample to be created.";
    }

    protected boolean validateFields() {
        String description = this.m_sampleDescriptionField.getText().trim();
        if (description.length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter a valid description.", "Invalid description", 0);
            return false;
        }
        this.m_sampleDescription = description;
        boolean intervalOk = true;
        long interval = 0L;
        try {
            interval = Long.parseLong(this.m_intervalField.getText().trim());
        }
        catch (NumberFormatException e) {
            intervalOk = false;
        }
        if (interval < 100L || interval > 86400000L) {
            intervalOk = false;
        }
        if (!intervalOk) {
            JOptionPane.showMessageDialog(this, "Please enter a valid interval. (100ms - 24hrs, 86400000)", "Invalid interval", 0);
            return false;
        }
        this.m_interval = interval;
        boolean sizeOk = true;
        int size = 0;
        try {
            size = Integer.parseInt(this.m_sizeField.getText().trim());
        }
        catch (NumberFormatException e) {
            sizeOk = false;
        }
        if (size < 1 || size > 2048) {
            sizeOk = false;
        }
        if (!sizeOk) {
            JOptionPane.showMessageDialog(this, "Please enter a valid size. (1 - 2048)", "Invalid size", 0);
            return false;
        }
        this.m_size = size;
        boolean leaseTimeOk = true;
        int leaseTime = 0;
        try {
            leaseTime = Integer.parseInt(this.m_leaseTimeField.getText().trim());
        }
        catch (NumberFormatException e) {
            leaseTimeOk = false;
        }
        if (leaseTime < 60 || (long)leaseTime > (long)size * interval / 1000L + 86400L) {
            leaseTimeOk = false;
        }
        if (!leaseTimeOk) {
            JOptionPane.showMessageDialog(this, "Please enter a valid lease time. Must be between 1 minute (60) and 24 hours greater than the interval * size (" + ((long)size * interval / 1000L + 86400L) + ")", "Invalid leaseTime", 0);
            return false;
        }
        this.m_leaseTime = (long)leaseTime * 1000L;
        this.m_sampleType = this.m_sampleTypeCounter.isSelected() ? 101 : (this.m_sampleTypeMaximum.isSelected() ? 103 : (this.m_sampleTypeMean.isSelected() ? 104 : (this.m_sampleTypeMinimum.isSelected() ? 102 : -1)));
        return true;
    }

    protected String[] getMainPanelLabels() {
        return new String[]{"Instrument Name:", "Instrument Description:", "Sample Description:", "Sample Interval (milliseconds):", "Number of Samples:", "Lease Time (Seconds):", "Maintain Lease:", "Sample Type:"};
    }

    protected Component[] getMainPanelComponents() {
        this.m_instrumentNameField = new JTextField();
        this.m_instrumentNameField.setColumns(40);
        this.m_instrumentNameField.setEditable(false);
        this.m_instrumentDescriptionField = new JTextField();
        this.m_instrumentDescriptionField.setColumns(40);
        this.m_instrumentDescriptionField.setEditable(false);
        this.m_sampleDescriptionField = new JTextField();
        this.m_sampleDescriptionField.setColumns(40);
        this.m_intervalField = new JTextField();
        this.m_intervalField.setColumns(10);
        this.m_sizeField = new JTextField();
        this.m_sizeField.setColumns(4);
        this.m_leaseTimeField = new JTextField();
        this.m_leaseTimeField.setColumns(10);
        this.m_maintainLeaseCheckBox = new JCheckBox();
        this.m_sampleTypePanel = Box.createVerticalBox();
        return new Component[]{this.m_instrumentNameField, this.m_instrumentDescriptionField, this.m_sampleDescriptionField, this.m_intervalField, this.m_sizeField, this.m_leaseTimeField, this.m_maintainLeaseCheckBox, this.m_sampleTypePanel};
    }

    private void buildSampleTypeComponent() {
        this.m_sampleTypeGroup = new ButtonGroup();
        this.m_sampleTypeCounter = new JRadioButton("Count over each sample");
        this.m_sampleTypeMaximum = new JRadioButton("Maximum value over each sample");
        this.m_sampleTypeMinimum = new JRadioButton("Minumum value over each sample");
        this.m_sampleTypeMean = new JRadioButton("Mean value over each sample");
        switch (this.m_instrumentDescriptor.getType()) {
            case 1: {
                this.m_sampleTypePanel.add(this.m_sampleTypeCounter);
                this.m_sampleTypeGroup.add(this.m_sampleTypeCounter);
                this.m_sampleTypeCounter.setSelected(true);
                this.m_sampleType = 101;
                break;
            }
            case 2: {
                this.m_sampleTypePanel.add(this.m_sampleTypeMaximum);
                this.m_sampleTypeGroup.add(this.m_sampleTypeMaximum);
                this.m_sampleTypePanel.add(this.m_sampleTypeMinimum);
                this.m_sampleTypeGroup.add(this.m_sampleTypeMinimum);
                this.m_sampleTypePanel.add(this.m_sampleTypeMean);
                this.m_sampleTypeGroup.add(this.m_sampleTypeMean);
                this.m_sampleTypeMaximum.setSelected(true);
                this.m_sampleType = 103;
                break;
            }
        }
    }

    void setSampleDescription(String sampleDescription) {
        this.m_sampleDescription = sampleDescription;
        this.m_sampleDescriptionField.setText(sampleDescription);
    }

    String getSampleDescription() {
        return this.m_sampleDescription;
    }

    void setInterval(long interval) {
        this.m_interval = interval;
        this.m_intervalField.setText(Long.toString(interval));
    }

    long getInterval() {
        return this.m_interval;
    }

    void setSampleCount(int size) {
        this.m_size = size;
        this.m_sizeField.setText(Integer.toString(size));
    }

    int getSampleCount() {
        return this.m_size;
    }

    void setLeaseTime(long leaseTime) {
        this.m_leaseTime = leaseTime;
        this.m_leaseTimeField.setText(Long.toString(leaseTime));
    }

    long getLeaseTime() {
        return this.m_leaseTime;
    }

    void setMaintainLease(boolean maintainLease) {
        this.m_maintainLeaseCheckBox.setSelected(maintainLease);
    }

    boolean getMaintainLease() {
        return this.m_maintainLeaseCheckBox.isSelected();
    }

    void setSampleType(int type) {
        this.m_sampleType = type;
        switch (type) {
            case 101: {
                this.m_sampleTypeCounter.setSelected(true);
                break;
            }
            case 103: {
                this.m_sampleTypeMaximum.setSelected(true);
                break;
            }
            case 104: {
                this.m_sampleTypeMean.setSelected(true);
                break;
            }
            case 102: {
                this.m_sampleTypeMinimum.setSelected(true);
                break;
            }
        }
    }

    int getSampleType() {
        return this.m_sampleType;
    }
}

