/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.excalibur.instrument.client.AbstractTabularOptionDialog;
import org.apache.excalibur.instrument.client.InstrumentClientFrame;

class ConnectDialog
extends AbstractTabularOptionDialog {
    private JTextField m_hostField;
    private String m_host;
    private JTextField m_portField;
    private int m_port;

    ConnectDialog(InstrumentClientFrame frame) {
        super(frame, "Connect to Remote Instrument Manager", 3);
    }

    protected String getMessage() {
        return "Please enter the host and port of the InstrumentManager to connect to.";
    }

    protected boolean validateFields() {
        String host = this.m_hostField.getText().trim();
        if (host.length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter a valid host name or IP address.", "Invalid host", 0);
            return false;
        }
        this.m_host = host;
        boolean portOk = true;
        int port = 0;
        try {
            port = Integer.parseInt(this.m_portField.getText().trim());
        }
        catch (NumberFormatException e) {
            portOk = false;
        }
        if (port < 0 || port > 65535) {
            portOk = false;
        }
        if (!portOk) {
            JOptionPane.showMessageDialog(this, "Please enter a valid port. (1-65535)", "Invalid port", 0);
            return false;
        }
        this.m_port = port;
        return true;
    }

    protected String[] getMainPanelLabels() {
        return new String[]{"Host:", "Port:"};
    }

    protected Component[] getMainPanelComponents() {
        this.m_hostField = new JTextField();
        this.m_hostField.setColumns(20);
        this.m_portField = new JTextField();
        this.m_portField.setColumns(6);
        return new Component[]{this.m_hostField, this.m_portField};
    }

    void setHost(String host) {
        this.m_host = host;
        this.m_hostField.setText(host);
    }

    String getHost() {
        return this.m_host;
    }

    void setPort(int port) {
        this.m_port = port;
        this.m_portField.setText(Integer.toString(port));
    }

    int getPort() {
        return this.m_port;
    }
}

