/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator;

import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterIterator
extends WrappedIterator {
    Filter f;
    Object current;
    boolean dead;

    public FilterIterator(Filter filter, Iterator iterator) {
        super(iterator);
        this.f = filter;
        this.current = null;
        this.dead = false;
    }

    public synchronized boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        while (super.hasNext()) {
            this.current = super.next();
            if (!this.f.accept(this.current)) continue;
            return true;
        }
        this.current = null;
        this.dead = true;
        return false;
    }

    public synchronized void remove() {
        if (this.current != null || this.dead) {
            throw new IllegalStateException("FilterIterator does not permit calls to hasNext between calls to next and remove.");
        }
        super.remove();
    }

    public synchronized Object next() {
        if (this.hasNext()) {
            Object object = this.current;
            this.current = null;
            return object;
        }
        throw new NoSuchElementException();
    }
}

