/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import java.util.NoSuchElementException;

public class Tokenizer {
    protected String source;
    protected int p;
    protected String delim;
    protected boolean returnDelims;
    protected String literalDelim;
    protected int state;
    protected String lookahead;
    protected static final int NORMAL = 1;
    protected static final int LITERAL_START = 2;
    protected static final int LITERAL_END = 3;

    public Tokenizer(String string, String string2, String string3, boolean bl) {
        this.source = string;
        this.delim = string2;
        this.literalDelim = string3;
        this.returnDelims = bl;
        this.p = 0;
        this.state = 1;
    }

    public String nextToken() {
        char c;
        String string = null;
        if (this.lookahead != null) {
            string = this.lookahead;
            this.lookahead = null;
        } else {
            string = this.getNextToken();
        }
        if (string == null) {
            throw new NoSuchElementException("No more elements in tokenized string");
        }
        if (!(this.returnDelims || string.length() != 1 || this.delim.indexOf(c = string.charAt(0)) == -1 && this.literalDelim.indexOf(c) == -1)) {
            return this.nextToken();
        }
        return string;
    }

    public boolean hasMoreTokens() {
        if (this.lookahead != null) {
            this.lookahead = this.getNextToken();
        }
        return this.lookahead != null;
    }

    private String getNextToken() {
        if (this.p >= this.source.length()) {
            return null;
        }
        switch (this.state) {
            case 1: {
                if (this.is(this.literalDelim)) {
                    this.state = 2;
                    ++this.p;
                    return this.source.substring(this.p - 1, this.p);
                }
                if (this.is(this.delim)) {
                    ++this.p;
                    return this.source.substring(this.p - 1, this.p);
                }
                int n = this.p++;
                while (this.p < this.source.length() && !this.is(this.delim)) {
                    ++this.p;
                }
                return this.source.substring(n, this.p);
            }
            case 2: {
                int n = this.p;
                while (this.isLiteral() && this.p < this.source.length()) {
                    ++this.p;
                }
                this.state = 3;
                return this.source.substring(n, this.p);
            }
            case 3: {
                this.state = 1;
                ++this.p;
                return this.source.substring(this.p - 1, this.p);
            }
        }
        return null;
    }

    private boolean is(String string) {
        return string.indexOf(this.source.charAt(this.p)) != -1;
    }

    private boolean isLiteral() {
        if (this.is(this.literalDelim)) {
            return this.source.charAt(this.p - 1) == '\\';
        }
        return true;
    }
}

