/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.transitiveReasoner;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;

public class TransitiveInfGraph
extends BaseInfGraph {
    protected TransitiveEngine transitiveEngine;
    protected Finder tbox = null;
    protected Finder dataFind;

    public TransitiveInfGraph(Graph graph, TransitiveReasoner transitiveReasoner) {
        super(graph, transitiveReasoner);
    }

    public void prepare() {
        this.tbox = ((TransitiveReasoner)this.reasoner).getTbox();
        this.transitiveEngine = new TransitiveEngine(((TransitiveReasoner)this.reasoner).getSubClassCache(), ((TransitiveReasoner)this.reasoner).getSubPropertyCache());
        this.dataFind = this.transitiveEngine.insert(this.tbox, this.fdata);
        this.transitiveEngine.setCaching(true, true);
        this.isPrepared = true;
    }

    public Graph getSchemaGraph() {
        if (this.tbox == null) {
            return null;
        }
        if (this.tbox instanceof FGraph) {
            return ((FGraph)this.tbox).getGraph();
        }
        throw new ReasonerException("Transitive reasoner got into an illegal state");
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        Finder finder2 = this.transitiveEngine.getFinder(triplePattern, FinderUtil.cascade(this.tbox, finder));
        return new UniqueExtendedIterator(finder2.find(triplePattern));
    }

    public ExtendedIterator find(Node node, Node node2, Node node3) {
        return this.findWithContinuation(new TriplePattern(node, node2, node3), this.fdata);
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        return this.findWithContinuation(triplePattern, this.fdata);
    }

    public synchronized void performAdd(Triple triple) {
        if (!this.isPrepared) {
            this.prepare();
        }
        this.fdata.getGraph().add(triple);
        this.transitiveEngine.add(triple);
    }

    public void performDelete(Triple triple) {
        this.fdata.getGraph().delete(triple);
        if (this.isPrepared) {
            this.transitiveEngine.delete(triple);
        }
    }
}

