/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.test.OWLWGTester;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTrialOWLRules
extends TestCase {
    protected String manifest;
    protected static boolean enableTracing = false;
    protected static boolean printStats = true;
    protected static Resource configuration;

    public TestTrialOWLRules(String string) {
        super(string);
        this.manifest = string;
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestTrialOWLRules("SymmetricProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("FunctionalProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("FunctionalProperty/Manifest002.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("FunctionalProperty/Manifest003.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("InverseFunctionalProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("InverseFunctionalProperty/Manifest002.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("InverseFunctionalProperty/Manifest003.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("rdf-charmod-uris/Manifest.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("I5.5/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("I5.5/Manifest002.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("I5.5/Manifest003.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("I5.5/Manifest004.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("inverseOf/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("TransitiveProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("equivalentClass/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("equivalentClass/Manifest002.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("equivalentClass/Manifest003.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("equivalentClass/Manifest005.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("equivalentProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("equivalentProperty/Manifest002.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("equivalentProperty/Manifest003.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("I4.6/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("I4.6/Manifest002.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("I5.1/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("I5.24/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("I5.24/Manifest002-mod.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("equivalentProperty/Manifest006.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("intersectionOf/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("differentFrom/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("disjointWith/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("disjointWith/Manifest002.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("AllDifferent/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("allValuesFrom/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("allValuesFrom/Manifest002.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("someValuesFrom/Manifest002.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("maxCardinality/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("maxCardinality/Manifest002.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("FunctionalProperty/Manifest005-mod.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("I5.24/Manifest004-mod.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("localtests/Manifest001.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("localtests/Manifest002.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest001-mod.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest002-mod.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest003-mod.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest004-mod.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("I5.24/Manifest003-mod.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest005-mod.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest006-mod.rdf"));
        testSuite.addTest((Test)new TestTrialOWLRules("equivalentClass/Manifest004.rdf"));
        return testSuite;
    }

    protected void runTest() throws IOException {
        OWLWGTester oWLWGTester = new OWLWGTester(GenericRuleReasonerFactory.theInstance(), this, configuration);
        oWLWGTester.runTests(this.manifest, enableTracing, printStats);
    }

    public static void main(String[] stringArray) {
        Model model = ModelLoader.loadModel("file:testing/wg/someValuesFrom/premises001.rdf");
        Reasoner reasoner = GenericRuleReasonerFactory.theInstance().create(configuration);
        InfModel infModel = ModelFactory.createInfModel(reasoner, model);
        System.out.println("Premises = ");
        Object object = model.listStatements();
        while (object.hasNext()) {
            System.out.println(" - " + object.next());
        }
        object = infModel.getResource("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#i");
        Property property = infModel.getProperty("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#p");
        Resource resource = infModel.getResource("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#c");
        Resource resource2 = infModel.getResource("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#r");
        Resource resource3 = (Resource)object.getRequiredProperty(property).getObject();
        System.out.println("Value of i.p = " + resource3);
        System.out.println("Types of v are: ");
        StmtIterator stmtIterator = infModel.listStatements(resource3, RDF.type, (RDFNode)null);
        while (stmtIterator.hasNext()) {
            System.out.println(" - " + stmtIterator.next());
        }
    }

    static {
        Model model = ModelFactory.createDefaultModel();
        configuration = model.createResource("http://jena.hpl.hp.com/2003/GenericRuleReasoner");
        configuration.addProperty(ReasonerVocabulary.PROPruleMode, "hybrid");
        configuration.addProperty(ReasonerVocabulary.PROPruleSet, "etc/owl-fb-test.rules");
        configuration.addProperty(ReasonerVocabulary.PROPenableOWLTranslation, true);
    }
}

