/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.reasoner.rulesys.impl.ConsumerChoicePointFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class LPTopGoalIterator
implements ClosableIterator,
LPInterpreterContext {
    Object lookAhead;
    LPInterpreter interpreter;
    protected Set choicePoints = new HashSet();
    protected ConsumerChoicePointFrame nextToRun;
    protected boolean isReady = true;
    protected boolean checkReadyNeeded = false;
    boolean started = false;

    public LPTopGoalIterator(LPInterpreter lPInterpreter) {
        this.interpreter = lPInterpreter;
        lPInterpreter.setTopInterpreter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveForward() {
        LPBRuleEngine lPBRuleEngine = this.interpreter.getEngine();
        synchronized (lPBRuleEngine) {
            this.started = true;
            this.lookAhead = this.interpreter.next();
            if (this.lookAhead == StateFlag.FAIL) {
                if (this.choicePoints.isEmpty()) {
                    this.close();
                } else {
                    this.nextToRun = null;
                    this.interpreter.getEngine().pump(this);
                    if (this.nextToRun == null) {
                        this.close();
                    } else {
                        this.interpreter.setState(this.nextToRun);
                        this.moveForward();
                    }
                }
            }
        }
    }

    public void notifyBlockedOn(ConsumerChoicePointFrame consumerChoicePointFrame) {
        this.choicePoints.add(consumerChoicePointFrame);
        this.checkReadyNeeded = true;
    }

    public void notifyFinished(ConsumerChoicePointFrame consumerChoicePointFrame) {
        this.choicePoints.remove(consumerChoicePointFrame);
        this.checkReadyNeeded = true;
    }

    public void setReady(ConsumerChoicePointFrame consumerChoicePointFrame) {
        this.nextToRun = consumerChoicePointFrame;
        this.isReady = true;
        this.checkReadyNeeded = false;
    }

    public boolean isReady() {
        if (this.checkReadyNeeded) {
            this.isReady = false;
            Iterator iterator = this.choicePoints.iterator();
            while (iterator.hasNext()) {
                if (!((ConsumerChoicePointFrame)iterator.next()).isReady()) continue;
                this.isReady = true;
                break;
            }
            this.checkReadyNeeded = false;
            return this.isReady;
        }
        return this.isReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.interpreter != null) {
            LPBRuleEngine lPBRuleEngine = this.interpreter.getEngine();
            synchronized (lPBRuleEngine) {
                this.interpreter.getEngine().checkForCompletions();
                this.lookAhead = null;
                this.interpreter.close();
                this.interpreter = null;
                this.isReady = false;
                this.checkReadyNeeded = false;
                this.nextToRun = null;
            }
        }
    }

    public boolean hasNext() {
        if (!this.started) {
            this.moveForward();
        }
        return this.lookAhead != null;
    }

    public Object next() {
        if (!this.started) {
            this.moveForward();
        }
        if (this.lookAhead == null) {
            throw new NoSuchElementException("Overran end of LP result set");
        }
        Object object = this.lookAhead;
        this.moveForward();
        return object;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

