/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.Generator;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPAgendaEntry;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPTopGoalIterator;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleClauseCode;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class LPBRuleEngine {
    protected LPRuleStore ruleStore;
    protected BackwardRuleInfGraphI infGraph;
    protected boolean traceOn = false;
    protected boolean recordDerivations;
    protected List activeInterpreters = new ArrayList();
    protected HashMap tabledGoals = new HashMap();
    protected Collection agenda = new HashSet();
    protected HashMap profile;
    public static final int CYCLES_BETWEEN_COMPLETION_CHECK = 3;
    static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$rulesys$impl$LPBRuleEngine == null ? (class$com$hp$hpl$jena$reasoner$rulesys$impl$LPBRuleEngine = LPBRuleEngine.class$("com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine")) : class$com$hp$hpl$jena$reasoner$rulesys$impl$LPBRuleEngine));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$impl$LPBRuleEngine;

    public LPBRuleEngine(BackwardRuleInfGraphI backwardRuleInfGraphI, LPRuleStore lPRuleStore) {
        this.infGraph = backwardRuleInfGraphI;
        this.ruleStore = lPRuleStore;
    }

    public LPBRuleEngine(BackwardRuleInfGraphI backwardRuleInfGraphI) {
        this.infGraph = backwardRuleInfGraphI;
        this.ruleStore = new LPRuleStore();
    }

    public synchronized ExtendedIterator find(TriplePattern triplePattern) {
        LPInterpreter lPInterpreter = new LPInterpreter(this, triplePattern);
        this.activeInterpreters.add(lPInterpreter);
        return WrappedIterator.create(new LPTopGoalIterator(lPInterpreter));
    }

    public synchronized void reset() {
        this.checkSafeToUpdate();
        this.tabledGoals = new HashMap();
        this.agenda.clear();
    }

    public synchronized void addRule(Rule rule) {
        this.checkSafeToUpdate();
        this.ruleStore.addRule(rule);
    }

    public synchronized void deleteRule(Rule rule) {
        this.checkSafeToUpdate();
        this.ruleStore.deleteRule(rule);
    }

    public synchronized List getAllRules() {
        this.checkSafeToUpdate();
        return this.ruleStore.getAllRules();
    }

    public synchronized void deleteAllRules() {
        this.checkSafeToUpdate();
        this.ruleStore.deleteAllRules();
    }

    public synchronized void halt() {
        Iterator iterator = this.activeInterpreters.iterator();
        while (iterator.hasNext()) {
            ((LPInterpreter)iterator.next()).close();
        }
    }

    public void setTraceOn(boolean bl) {
        this.traceOn = bl;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
    }

    public boolean getDerivationLogging() {
        return this.recordDerivations;
    }

    public LPRuleStore getRuleStore() {
        return this.ruleStore;
    }

    public BackwardRuleInfGraphI getInfGraph() {
        return this.infGraph;
    }

    public synchronized void detach(LPInterpreter lPInterpreter) {
        this.activeInterpreters.remove(lPInterpreter);
    }

    public void checkSafeToUpdate() {
        if (!this.activeInterpreters.isEmpty()) {
            ArrayList<LPInterpreterContext> arrayList = new ArrayList<LPInterpreterContext>();
            Iterator iterator = this.activeInterpreters.iterator();
            while (iterator.hasNext()) {
                LPInterpreter lPInterpreter = (LPInterpreter)iterator.next();
                if (!(lPInterpreter.getContext() instanceof LPTopGoalIterator)) continue;
                arrayList.add(lPInterpreter.getContext());
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((LPTopGoalIterator)iterator.next()).close();
            }
        }
    }

    public synchronized void tablePredicate(Node node) {
        this.ruleStore.tablePredicate(node);
    }

    public synchronized Generator generatorFor(TriplePattern triplePattern, List list) {
        Generator generator = (Generator)this.tabledGoals.get(triplePattern);
        if (generator == null) {
            LPInterpreter lPInterpreter = new LPInterpreter(this, triplePattern, list, false);
            this.activeInterpreters.add(lPInterpreter);
            generator = new Generator(lPInterpreter, triplePattern);
            this.schedule(generator);
            this.tabledGoals.put(triplePattern, generator);
        }
        return generator;
    }

    public synchronized Generator generatorFor(TriplePattern triplePattern) {
        Generator generator = (Generator)this.tabledGoals.get(triplePattern);
        if (generator == null) {
            LPInterpreter lPInterpreter = new LPInterpreter(this, triplePattern, false);
            this.activeInterpreters.add(lPInterpreter);
            generator = new Generator(lPInterpreter, triplePattern);
            this.schedule(generator);
            this.tabledGoals.put(triplePattern, generator);
        }
        return generator;
    }

    public void schedule(LPAgendaEntry lPAgendaEntry) {
        this.agenda.add(lPAgendaEntry);
    }

    public synchronized void pump(LPInterpreterContext lPInterpreterContext) {
        ArrayList<Generator> arrayList = null;
        arrayList = new ArrayList<Generator>(3);
        int n = 0;
        while (!lPInterpreterContext.isReady()) {
            if (this.agenda.isEmpty()) {
                return;
            }
            Iterator iterator = this.agenda.iterator();
            LPAgendaEntry lPAgendaEntry = (LPAgendaEntry)iterator.next();
            iterator.remove();
            lPAgendaEntry.pump();
            arrayList.add(lPAgendaEntry.getGenerator());
            if (++n % 3 != 0) continue;
            Generator.checkForCompletions(arrayList);
            arrayList.clear();
        }
        if (!arrayList.isEmpty()) {
            Generator.checkForCompletions(arrayList);
        }
    }

    public void checkForCompletions() {
        ArrayList<LPInterpreterContext> arrayList = new ArrayList<LPInterpreterContext>(this.activeInterpreters.size());
        Iterator iterator = this.activeInterpreters.iterator();
        while (iterator.hasNext()) {
            LPInterpreter lPInterpreter = (LPInterpreter)iterator.next();
            if (!(lPInterpreter.getContext() instanceof Generator)) continue;
            arrayList.add(lPInterpreter.getContext());
        }
        Generator.checkForCompletions(arrayList);
    }

    public void incrementProfile(RuleClauseCode ruleClauseCode) {
        if (this.profile != null) {
            String string = ruleClauseCode.toString();
            Count count = (Count)this.profile.get(string);
            if (count == null) {
                this.profile.put(string, new Count(ruleClauseCode).inc());
            } else {
                count.inc();
            }
        }
    }

    public void resetProfile(boolean bl) {
        this.profile = bl ? new HashMap() : null;
    }

    public void printProfile() {
        if (this.profile == null) {
            System.out.println("No profile collected");
        } else {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.profile.values());
            Collections.sort(arrayList);
            System.out.println("LP engine rule profile");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                System.out.println(iterator.next());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Count
    implements Comparable {
        protected int count = 0;
        protected RuleClauseCode clause;

        public Count(RuleClauseCode ruleClauseCode) {
            this.clause = ruleClauseCode;
        }

        public int getCount() {
            return this.count;
        }

        public Count inc() {
            ++this.count;
            return this;
        }

        public int compareTo(Object object) {
            Count count = (Count)object;
            return this.count < count.count ? -1 : (this.count == count.count ? 0 : 1);
        }

        public String toString() {
            return " " + this.count + "\t - " + this.clause;
        }
    }
}

