/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.impl.ConsumerChoicePointFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPAgendaEntry;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterState;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Generator
implements LPAgendaEntry,
LPInterpreterContext {
    protected LPInterpreter interpreter;
    protected ArrayList results = new ArrayList();
    protected Set resultSet;
    protected boolean isReady = true;
    protected boolean checkReadyNeeded = false;
    protected Set generatingCPs = new HashSet();
    protected Set consumingCPs = new HashSet();
    protected LFlag completionState;
    protected TriplePattern goal;
    protected boolean isSingleton;

    public Generator(LPInterpreter lPInterpreter, TriplePattern triplePattern) {
        this.interpreter = lPInterpreter;
        this.goal = triplePattern;
        this.isSingleton = triplePattern.isGround();
        if (!this.isSingleton) {
            this.resultSet = new HashSet();
        }
    }

    public int numResults() {
        return this.results.size();
    }

    public boolean isReady() {
        if (this.isComplete()) {
            return false;
        }
        if (this.checkReadyNeeded) {
            this.isReady = false;
            Iterator iterator = this.generatingCPs.iterator();
            while (iterator.hasNext()) {
                if (!((ConsumerChoicePointFrame)iterator.next()).isReady()) continue;
                this.isReady = true;
                break;
            }
            this.checkReadyNeeded = false;
            return this.isReady;
        }
        return this.isReady;
    }

    public void setReady(ConsumerChoicePointFrame consumerChoicePointFrame) {
        if (!this.isComplete()) {
            this.interpreter.engine.schedule(consumerChoicePointFrame);
            this.isReady = true;
            this.checkReadyNeeded = false;
        }
    }

    public boolean isComplete() {
        return this.interpreter == null;
    }

    public void setComplete() {
        if (!this.isComplete()) {
            this.interpreter.close();
            this.interpreter = null;
            this.resultSet = null;
            this.isReady = false;
            this.completionState = LFlag.DEAD;
            Iterator iterator = this.consumingCPs.iterator();
            while (iterator.hasNext()) {
                ConsumerChoicePointFrame consumerChoicePointFrame = (ConsumerChoicePointFrame)iterator.next();
                if (consumerChoicePointFrame.isReady()) continue;
                consumerChoicePointFrame.setFinished();
            }
            this.generatingCPs = null;
        }
    }

    public void addConsumer(ConsumerChoicePointFrame consumerChoicePointFrame) {
        this.consumingCPs.add(consumerChoicePointFrame);
    }

    public void removeConsumer(ConsumerChoicePointFrame consumerChoicePointFrame) {
        if (!this.isComplete()) {
            this.consumingCPs.remove(consumerChoicePointFrame);
            if (this.consumingCPs.isEmpty()) {
                this.setComplete();
            }
        }
    }

    public void notifyResults() {
        LPBRuleEngine lPBRuleEngine = this.interpreter.getEngine();
        Iterator iterator = this.consumingCPs.iterator();
        while (iterator.hasNext()) {
            ConsumerChoicePointFrame consumerChoicePointFrame = (ConsumerChoicePointFrame)iterator.next();
            consumerChoicePointFrame.setReady();
        }
    }

    public void notifyBlockedOn(ConsumerChoicePointFrame consumerChoicePointFrame) {
        this.generatingCPs.add(consumerChoicePointFrame);
        this.checkReadyNeeded = true;
    }

    public void notifyFinished(ConsumerChoicePointFrame consumerChoicePointFrame) {
        this.removeConsumer(consumerChoicePointFrame);
        this.checkReadyNeeded = true;
    }

    public void pump() {
        this.pump(this);
    }

    public void pump(LPInterpreterState lPInterpreterState) {
        if (this.isComplete()) {
            return;
        }
        this.interpreter.setState(lPInterpreterState);
        int n = this.results.size();
        while (true) {
            Object object;
            if ((object = this.interpreter.next()) == StateFlag.FAIL) {
                this.checkReadyNeeded = true;
                break;
            }
            if (this.isSingleton) {
                this.results.add(object);
                this.isReady = false;
                break;
            }
            if (!this.resultSet.add(object)) continue;
            this.results.add(object);
        }
        if (this.results.size() > n) {
            this.notifyResults();
        }
        if (this.isSingleton && this.results.size() == 1) {
            this.setComplete();
        }
    }

    public Generator getGenerator() {
        return this;
    }

    public void checkForCompletions() {
        HashSet hashSet = new HashSet();
        if (this.runCompletionCheck(hashSet) != LFlag.LIVE) {
            Generator.postCompletionCheckScan(hashSet);
        }
    }

    public static void checkForCompletions(Collection collection) {
        HashSet hashSet = new HashSet();
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Generator generator = (Generator)iterator.next();
            if (generator.runCompletionCheck(hashSet) == LFlag.LIVE) continue;
            bl = true;
        }
        if (bl) {
            Generator.postCompletionCheckScan(hashSet);
        }
    }

    protected LFlag runCompletionCheck(Set set) {
        if (this.isComplete()) {
            return LFlag.DEAD;
        }
        if (!set.add(this)) {
            return this.completionState;
        }
        this.completionState = LFlag.UNKNOWN;
        if (this.isReady()) {
            this.completionState = LFlag.LIVE;
        } else {
            Iterator iterator = this.generatingCPs.iterator();
            while (iterator.hasNext()) {
                ConsumerChoicePointFrame consumerChoicePointFrame = (ConsumerChoicePointFrame)iterator.next();
                if (consumerChoicePointFrame.isReady()) {
                    this.completionState = LFlag.LIVE;
                    break;
                }
                if (consumerChoicePointFrame.generator.runCompletionCheck(set) != LFlag.LIVE) continue;
                this.completionState = LFlag.LIVE;
                break;
            }
        }
        return this.completionState;
    }

    protected static void postCompletionCheckScan(Set set) {
        Generator generator;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            generator = (Generator)iterator.next();
            if (generator.completionState != LFlag.LIVE) continue;
            Iterator iterator2 = generator.consumingCPs.iterator();
            while (iterator2.hasNext()) {
                LPInterpreterContext lPInterpreterContext = ((ConsumerChoicePointFrame)iterator2.next()).getConsumingContext();
                if (!(lPInterpreterContext instanceof Generator)) continue;
                ((Generator)lPInterpreterContext).propagateLive(set);
            }
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            generator = (Generator)iterator.next();
            if (generator.completionState == LFlag.LIVE) continue;
            generator.setComplete();
        }
    }

    protected void propagateLive(Set set) {
        if (this.completionState != LFlag.LIVE) {
            this.completionState = LFlag.LIVE;
            Iterator iterator = this.consumingCPs.iterator();
            while (iterator.hasNext()) {
                LPInterpreterContext lPInterpreterContext = ((ConsumerChoicePointFrame)iterator.next()).getConsumingContext();
                if (!(lPInterpreterContext instanceof Generator)) continue;
                ((Generator)lPInterpreterContext).propagateLive(set);
            }
        }
    }

    private static class LFlag {
        private String label;
        public static final LFlag LIVE = new LFlag("Live");
        public static final LFlag DEAD = new LFlag("Dead");
        public static final LFlag UNKNOWN = new LFlag("Unknown");

        private LFlag(String string) {
            this.label = string;
        }

        public String toString() {
            return this.label;
        }
    }
}

