/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.IteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.RSIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.ReifiedStatementImpl;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;

public class ModelReifier {
    private ModelCom model;
    private Reifier reifier;
    private static boolean copyingReifications = false;
    protected final Map1 mapToRS = new Map1(){

        public Object map1(Object object) {
            return ModelReifier.this.getRS((Node)object);
        }
    };
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$ReifiedStatement;

    public ModelReifier(ModelCom modelCom) {
        this.model = modelCom;
        this.reifier = modelCom.asGraph().getReifier();
    }

    public static Model withHiddenStatements(Model model) {
        Graph graph = model.getGraph();
        Graph graph2 = graph.getReifier().getHiddenTriples();
        return new ModelCom(new Union(graph, graph2));
    }

    public Model getHiddenStatements() {
        return new ModelCom(this.reifier.getHiddenTriples());
    }

    public ReifiedStatement createReifiedStatement(Statement statement) {
        return this.createReifiedStatement(null, statement);
    }

    public ReifiedStatement createReifiedStatement(String string, Statement statement) {
        return ReifiedStatementImpl.create(this.model, string, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getAnyReifiedStatement(Statement statement) {
        RSIterator rSIterator = this.listReifiedStatements(statement);
        if (rSIterator.hasNext()) {
            try {
                ReifiedStatement reifiedStatement = rSIterator.nextRS();
                return reifiedStatement;
            }
            finally {
                rSIterator.close();
            }
        }
        return this.createReifiedStatement(statement);
    }

    public boolean isReified(Statement statement) {
        return this.reifier.hasTriple(statement.asTriple());
    }

    public void removeAllReifications(Statement statement) {
        this.reifier.remove(statement.asTriple());
    }

    public void removeReification(ReifiedStatement reifiedStatement) {
        this.reifier.remove(reifiedStatement.asNode(), reifiedStatement.getStatement().asTriple());
    }

    public RSIterator listReifiedStatements() {
        return new RSIteratorImpl(this.findReifiedStatements());
    }

    public RSIterator listReifiedStatements(Statement statement) {
        return new RSIteratorImpl(this.findReifiedStatements(statement.asTriple()));
    }

    public void noteIfReified(RDFNode rDFNode, RDFNode rDFNode2, RDFNode rDFNode3) {
        if (copyingReifications) {
            this.noteIfReified(rDFNode);
            this.noteIfReified(rDFNode2);
            this.noteIfReified(rDFNode3);
        }
    }

    private void noteIfReified(RDFNode rDFNode) {
        if (rDFNode.canAs(class$com$hp$hpl$jena$rdf$model$ReifiedStatement == null ? (class$com$hp$hpl$jena$rdf$model$ReifiedStatement = ModelReifier.class$("com.hp.hpl.jena.rdf.model.ReifiedStatement")) : class$com$hp$hpl$jena$rdf$model$ReifiedStatement)) {
            ReifiedStatement reifiedStatement = (ReifiedStatement)rDFNode.as(class$com$hp$hpl$jena$rdf$model$ReifiedStatement == null ? (class$com$hp$hpl$jena$rdf$model$ReifiedStatement = ModelReifier.class$("com.hp.hpl.jena.rdf.model.ReifiedStatement")) : class$com$hp$hpl$jena$rdf$model$ReifiedStatement);
            this.createReifiedStatement(reifiedStatement.getURI(), reifiedStatement.getStatement());
        }
    }

    private ExtendedIterator findReifiedStatements() {
        return this.reifier.allNodes().mapWith(this.mapToRS);
    }

    private ExtendedIterator findReifiedStatements(Triple triple) {
        return this.reifier.allNodes(triple).mapWith(this.mapToRS);
    }

    private ReifiedStatement getRS(Node node) {
        Triple triple = this.reifier.getTriple(node);
        Statement statement = IteratorFactory.asStatement(triple, this.model);
        return ReifiedStatementImpl.create(this.model, node, statement);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

