/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.ontology.tidy.AbsChecker;
import com.hp.hpl.jena.ontology.tidy.Blank;
import com.hp.hpl.jena.ontology.tidy.CBlank;
import com.hp.hpl.jena.ontology.tidy.CBuiltin;
import com.hp.hpl.jena.ontology.tidy.CLit;
import com.hp.hpl.jena.ontology.tidy.CNodeI;
import com.hp.hpl.jena.ontology.tidy.CURIref;
import com.hp.hpl.jena.ontology.tidy.Grammar;
import com.hp.hpl.jena.ontology.tidy.One;
import com.hp.hpl.jena.ontology.tidy.SyntaxException;
import com.hp.hpl.jena.ontology.tidy.SyntaxProblem;
import com.hp.hpl.jena.ontology.tidy.Two;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

abstract class CNode
extends EnhNode
implements CNodeI {
    public static final Implementation factory = new Implementation(){

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return true;
        }

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (node.isLiteral()) {
                return new CLit(node, enhGraph);
            }
            if (node.isURI()) {
                int n = Grammar.getBuiltinID(node.getURI());
                switch (n) {
                    case 2048: {
                        ((AbsChecker)enhGraph).addProblem(new SyntaxProblem("Disallowed vocabulary", node, 2));
                        return new CURIref(node, enhGraph);
                    }
                    case 1024: {
                        ((AbsChecker)enhGraph).addProblem(new SyntaxProblem("Unrecognised OWL vocabulary", node, 0));
                        return new CURIref(node, enhGraph);
                    }
                    case 1536: {
                        ((AbsChecker)enhGraph).addProblem(new SyntaxProblem("Unrecognised RDF vocabulary", node, 0));
                        return new CURIref(node, enhGraph);
                    }
                    case 512: {
                        ((AbsChecker)enhGraph).addProblem(new SyntaxProblem("Illadvised XSD datatype", node, 0));
                        return new CBuiltin(node, enhGraph, 10);
                    }
                    case -1: {
                        return new CURIref(node, enhGraph);
                    }
                }
                if (n < 148) {
                    return new CBuiltin(node, enhGraph, n);
                }
                return new CURIref(node, enhGraph, n);
            }
            return new CBlank(node, enhGraph);
        }
    };
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$tidy$One;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$tidy$Two;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$tidy$Blank;

    CNode(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    AbsChecker getChecker() {
        return (AbsChecker)this.getGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node getAttribute(Node node) {
        Graph graph = this.getGraph().asGraph();
        ExtendedIterator extendedIterator = graph.find(this.asNode(), node, null);
        Node node2 = null;
        try {
            if (extendedIterator.hasNext()) {
                node2 = ((Triple)extendedIterator.next()).getObject();
                if (extendedIterator.hasNext()) {
                    throw new SyntaxException("Internal error: <" + node.getURI() + "> may have at most one value.");
                }
            }
        }
        finally {
            extendedIterator.close();
        }
        return node2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttribute(Node node, Node node2) {
        Graph graph = this.getGraph().asGraph();
        ExtendedIterator extendedIterator = graph.find(this.asNode(), node, null);
        Triple triple = null;
        try {
            if (extendedIterator.hasNext()) {
                triple = (Triple)extendedIterator.next();
                if (extendedIterator.hasNext()) {
                    throw new SyntaxException("Internal error: <" + node.getURI() + "> may have at most one value.");
                }
            }
        }
        finally {
            extendedIterator.close();
        }
        if (triple != null) {
            graph.delete(triple);
        }
        graph.add(new Triple(this.asNode(), node, node2));
    }

    int getIntAttribute(Node node, int n) {
        Node node2 = this.getAttribute(node);
        if (node2 != null) {
            return ((Number)node2.getLiteral().getValue()).intValue();
        }
        return n;
    }

    void setIntAttribute(Node node, int n) {
        this.setAttribute(node, Node.createLiteral(new LiteralLabel(new Integer(n))));
    }

    void incrAttribute(Node node, int n) {
        int n2 = this.getIntAttribute(node, 0);
        this.setIntAttribute(node, n2 + n);
    }

    public One asOne() {
        return (One)((Object)this.viewAs(class$com$hp$hpl$jena$ontology$tidy$One == null ? (class$com$hp$hpl$jena$ontology$tidy$One = CNode.class$("com.hp.hpl.jena.ontology.tidy.One")) : class$com$hp$hpl$jena$ontology$tidy$One));
    }

    public Two asTwo() {
        return (Two)((Object)this.viewAs(class$com$hp$hpl$jena$ontology$tidy$Two == null ? (class$com$hp$hpl$jena$ontology$tidy$Two = CNode.class$("com.hp.hpl.jena.ontology.tidy.Two")) : class$com$hp$hpl$jena$ontology$tidy$Two));
    }

    public Blank asBlank() {
        return (Blank)((Object)this.viewAs(class$com$hp$hpl$jena$ontology$tidy$Blank == null ? (class$com$hp$hpl$jena$ontology$tidy$Blank = CNode.class$("com.hp.hpl.jena.ontology.tidy.Blank")) : class$com$hp$hpl$jena$ontology$tidy$Blank));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

