/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestOntDocumentManager
extends TestCase {
    private static Boolean F = Boolean.FALSE;
    private static Boolean T = Boolean.TRUE;
    public static Object[][] s_testData = new Object[][]{{"testing/ontology/testImport1", TestOntDocumentManager.cnt(1), T, null}, {"testing/ontology/testImport2", TestOntDocumentManager.cnt(2), T, null}, {"testing/ontology/testImport2", TestOntDocumentManager.cnt(1), F, null}, {"testing/ontology/testImport3", TestOntDocumentManager.cnt(3), T, null}, {"testing/ontology/testImport4", TestOntDocumentManager.cnt(2), T, null}, {"testing/ontology/testImport5", TestOntDocumentManager.cnt(2), T, "file:testing/ontology/testImport5/ont-policy.rdf"}};

    public static final Integer cnt(int n) {
        return new Integer(n);
    }

    public TestOntDocumentManager(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("TestOntDocumentManager");
        testSuite.addTest((Test)new TestOntDocumentManager("testInitialisation"));
        testSuite.addTest((Test)new TestOntDocumentManager("testManualAssociation"));
        testSuite.addTest((Test)new TestOntDocumentManager("testIgnoreImport"));
        testSuite.addTest((Test)new TestOntDocumentManager("testRemoveImport1"));
        testSuite.addTest((Test)new TestOntDocumentManager("testRemoveImport2"));
        testSuite.addTest((Test)new TestOntDocumentManager("testRemoveImport3"));
        testSuite.addTest((Test)new TestOntDocumentManager("testDynamicImports1"));
        testSuite.addTest((Test)new TestOntDocumentManager("testDynamicImports2"));
        testSuite.addTest((Test)new TestOntDocumentManager("testDynamicImports3"));
        for (int i = 0; i < s_testData.length; ++i) {
            testSuite.addTest((Test)new DocManagerImportTest((String)s_testData[i][0], (Integer)s_testData[i][1], (Boolean)s_testData[i][2], (String)s_testData[i][3]));
        }
        return testSuite;
    }

    public void testInitialisation() {
        OntDocumentManager ontDocumentManager = new OntDocumentManager();
        TestOntDocumentManager.assertTrue((String)"Should be at least one specification loaded", (boolean)ontDocumentManager.listDocuments().hasNext());
        TestOntDocumentManager.assertNotNull((String)"cache URL for owl should not be null", (Object)ontDocumentManager.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals((String)"cache URL for owl not correct", (String)"file:vocabularies/owl.owl", (String)ontDocumentManager.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals((String)"prefix for owl not correct", (String)"owl", (String)ontDocumentManager.getPrefixForURI("http://www.w3.org/2002/07/owl#"));
        ontDocumentManager = new OntDocumentManager("");
        TestOntDocumentManager.assertTrue((String)"Should be no specification loaded", (!ontDocumentManager.listDocuments().hasNext() ? 1 : 0) != 0);
        ontDocumentManager = new OntDocumentManager(null);
        TestOntDocumentManager.assertTrue((String)"Should be no specification loaded", (!ontDocumentManager.listDocuments().hasNext() ? 1 : 0) != 0);
    }

    public void testManualAssociation() {
        OntDocumentManager ontDocumentManager = new OntDocumentManager(null);
        ontDocumentManager.addPrefixMapping("http://www.w3.org/2002/07/owl#", "owl");
        TestOntDocumentManager.assertEquals((String)"prefix for owl not correct", (String)"owl", (String)ontDocumentManager.getPrefixForURI("http://www.w3.org/2002/07/owl#"));
        TestOntDocumentManager.assertEquals((String)"URI for owl not correct", (String)"http://www.w3.org/2002/07/owl#", (String)ontDocumentManager.getURIForPrefix("owl"));
        ontDocumentManager.addAltEntry("http://www.w3.org/2002/07/owl", "file:foo.bar");
        TestOntDocumentManager.assertEquals((String)"Failed to retrieve cache location", (String)"file:foo.bar", (String)ontDocumentManager.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        ontDocumentManager.addLanguageEntry("http://www.w3.org/2002/07/owl", "http://www.w3.org/2002/07/owl");
        TestOntDocumentManager.assertEquals((String)"Failed to retrieve language", (String)"http://www.w3.org/2002/07/owl", (String)ontDocumentManager.getLanguage("http://www.w3.org/2002/07/owl"));
    }

    public void testIgnoreImport() {
        OntDocumentManager ontDocumentManager = new OntDocumentManager();
        ontDocumentManager.addIgnoreImport("file:testing/ontology/testImport3/c.owl");
        OntModelSpec ontModelSpec = new OntModelSpec(null, ontDocumentManager, null, "http://www.w3.org/2002/07/owl#");
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        TestOntDocumentManager.assertNotNull((String)"Ontology model should not be null", (Object)ontModel);
        ontModel.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)2, (int)TestOntDocumentManager.countMarkers(ontModel));
    }

    public void testRemoveImport1() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)3, (int)TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        ontModel.getDocumentManager().unloadImport(ontModel, "file:testing/ontology/testImport3/c.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)2, (int)TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertFalse((String)"c should not be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
    }

    public void testRemoveImport2() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)3, (int)TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue((String)"b should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        ontModel.getDocumentManager().unloadImport(ontModel, "file:testing/ontology/testImport3/b.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)1, (int)TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertFalse((String)"c should not be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse((String)"b should not be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testRemoveImport3() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport6/a.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)4, (int)TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport6/c.owl"));
        TestOntDocumentManager.assertTrue((String)"b should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport6/b.owl"));
        TestOntDocumentManager.assertTrue((String)"d should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport6/d.owl"));
        ontModel.getDocumentManager().unloadImport(ontModel, "file:testing/ontology/testImport6/b.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)3, (int)TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport6/c.owl"));
        TestOntDocumentManager.assertTrue((String)"d should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport6/d.owl"));
        TestOntDocumentManager.assertFalse((String)"b should not be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport6/b.owl"));
    }

    public void testDynamicImports1() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("file:testing/ontology/testImport3/a.owl");
        Resource resource2 = ontModel.getResource("file:testing/ontology/testImport3/b.owl");
        ontModel.add(resource, ontModel.getProfile().IMPORTS(), resource2);
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)0, (int)TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertFalse((String)"c should not be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse((String)"b should not be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testDynamicImports2() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("file:testing/ontology/testImport3/a.owl");
        Resource resource2 = ontModel.getResource("file:testing/ontology/testImport3/b.owl");
        ontModel.setDynamicImports(true);
        ontModel.add(resource, ontModel.getProfile().IMPORTS(), resource2);
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)2, (int)TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue((String)"b should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testDynamicImports3() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)3, (int)TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue((String)"b should be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        ontModel.setDynamicImports(true);
        Resource resource = ontModel.getResource("file:testing/ontology/testImport3/a.owl");
        Resource resource2 = ontModel.getResource("file:testing/ontology/testImport3/b.owl");
        ontModel.remove(ontModel.createStatement(resource, ontModel.getProfile().IMPORTS(), resource2));
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)1, (int)TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertFalse((String)"c should not be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse((String)"b should not be imported", (boolean)ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public static int countMarkers(Model model) {
        int n = 0;
        Resource resource = model.getResource("http://jena.hpl.hp.com/2003/03/testont#Marker");
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, resource);
        while (stmtIterator.hasNext()) {
            ++n;
            stmtIterator.next();
        }
        return n;
    }

    static class DocManagerImportTest
    extends TestCase {
        String m_dir;
        int m_count;
        String m_path;
        boolean m_processImports;

        DocManagerImportTest(String string, int n, boolean bl, String string2) {
            super(string);
            this.m_dir = string;
            this.m_count = n;
            this.m_path = string2;
            this.m_processImports = bl;
        }

        public void runTest() {
            OntDocumentManager ontDocumentManager = new OntDocumentManager();
            ontDocumentManager.setProcessImports(this.m_processImports);
            if (this.m_path != null) {
                ontDocumentManager.setMetadataSearchPath(this.m_path, true);
            }
            OntModelSpec ontModelSpec = new OntModelSpec(null, ontDocumentManager, null, "http://www.w3.org/2002/07/owl#");
            OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
            DocManagerImportTest.assertNotNull((String)"Ontology model should not be null", (Object)ontModel);
            ontModel.read("file:" + this.m_dir + "/a.owl");
            DocManagerImportTest.assertEquals((String)"Marker count not correct", (int)this.m_count, (int)TestOntDocumentManager.countMarkers(ontModel));
        }
    }
}

