/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.OneToManyMap;
import java.util.Iterator;

public abstract class AbstractProfile
implements Profile {
    protected OneToManyMap m_aliasesMap;

    public boolean hasAliasFor(Resource resource) {
        return this.aliasMap().containsKey(resource);
    }

    public Resource getAliasFor(Resource resource) {
        return (Resource)this.aliasMap().get(resource);
    }

    public Iterator listAliasesFor(Resource resource) {
        return this.aliasMap().getAll(resource);
    }

    public static boolean containsSome(EnhGraph enhGraph, Node node, Property property) {
        return enhGraph.asGraph().contains(node, property.asNode(), Node.ANY);
    }

    protected abstract Resource[][] aliasTable();

    protected OneToManyMap aliasMap() {
        if (this.m_aliasesMap == null) {
            this.m_aliasesMap = new OneToManyMap();
            Resource[][] resourceArray = this.aliasTable();
            for (int i = 0; i < resourceArray.length; ++i) {
                this.m_aliasesMap.put(resourceArray[i][0], resourceArray[i][1]);
                this.m_aliasesMap.put(resourceArray[i][1], resourceArray[i][0]);
            }
        }
        return this.m_aliasesMap;
    }
}

